/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.common.message.UpdateFeaturesResponseData.*;

public class UpdateFeaturesResponseDataJsonConverter {
    public static UpdateFeaturesResponseData read(JsonNode _node, short _version) {
        UpdateFeaturesResponseData _object = new UpdateFeaturesResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("UpdateFeaturesResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        } else {
            _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "UpdateFeaturesResponseData");
        }
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("UpdateFeaturesResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        } else {
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "UpdateFeaturesResponseData");
        }
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("UpdateFeaturesResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        } else {
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("UpdateFeaturesResponseData expected a string type, but got " + _node.getNodeType());
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
        }
        JsonNode _resultsNode = _node.get("results");
        if (_resultsNode == null) {
            if (_version <= 1) {
                throw new RuntimeException("UpdateFeaturesResponseData: unable to locate field 'results', which is mandatory in version " + _version);
            } else {
                _object.results = new UpdatableFeatureResultCollection(0);
            }
        } else {
            if (!_resultsNode.isArray()) {
                throw new RuntimeException("UpdateFeaturesResponseData expected a JSON array, but got " + _node.getNodeType());
            }
            UpdatableFeatureResultCollection _collection = new UpdatableFeatureResultCollection(_resultsNode.size());
            _object.results = _collection;
            for (JsonNode _element : _resultsNode) {
                _collection.add(UpdatableFeatureResultJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(UpdateFeaturesResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", new ShortNode(_object.errorCode));
        if (_object.errorMessage == null) {
            _node.set("errorMessage", NullNode.instance);
        } else {
            _node.set("errorMessage", new TextNode(_object.errorMessage));
        }
        if (_version <= 1) {
            ArrayNode _resultsArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdatableFeatureResult _element : _object.results) {
                _resultsArray.add(UpdatableFeatureResultJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("results", _resultsArray);
        }
        return _node;
    }
    public static JsonNode write(UpdateFeaturesResponseData _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class UpdatableFeatureResultJsonConverter {
        public static UpdatableFeatureResult read(JsonNode _node, short _version) {
            UpdatableFeatureResult _object = new UpdatableFeatureResult();
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdatableFeatureResult");
            }
            JsonNode _featureNode = _node.get("feature");
            if (_featureNode == null) {
                throw new RuntimeException("UpdatableFeatureResult: unable to locate field 'feature', which is mandatory in version " + _version);
            } else {
                if (!_featureNode.isTextual()) {
                    throw new RuntimeException("UpdatableFeatureResult expected a string type, but got " + _node.getNodeType());
                }
                _object.feature = _featureNode.asText();
            }
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("UpdatableFeatureResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            } else {
                _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "UpdatableFeatureResult");
            }
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("UpdatableFeatureResult: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            } else {
                if (_errorMessageNode.isNull()) {
                    _object.errorMessage = null;
                } else {
                    if (!_errorMessageNode.isTextual()) {
                        throw new RuntimeException("UpdatableFeatureResult expected a string type, but got " + _node.getNodeType());
                    }
                    _object.errorMessage = _errorMessageNode.asText();
                }
            }
            return _object;
        }
        public static JsonNode write(UpdatableFeatureResult _object, short _version, boolean _serializeRecords) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdatableFeatureResult");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("feature", new TextNode(_object.feature));
            _node.set("errorCode", new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", NullNode.instance);
            } else {
                _node.set("errorMessage", new TextNode(_object.errorMessage));
            }
            return _node;
        }
        public static JsonNode write(UpdatableFeatureResult _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
