/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class UpdateFeaturesResponseTest {
    @Test
    public void testErrorCounts() {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        results.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("foo").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()));
        results.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("bar").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()));
        results.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("baz").setErrorCode(Errors.FEATURE_UPDATE_FAILED.code()));
        UpdateFeaturesResponse response = new UpdateFeaturesResponse(new UpdateFeaturesResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setResults(results));
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)3, (int)errorCounts.size());
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.INVALID_REQUEST)));
        Assertions.assertEquals((int)2, (int)((Integer)errorCounts.get(Errors.UNKNOWN_SERVER_ERROR)));
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.FEATURE_UPDATE_FAILED)));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.UPDATE_FEATURES)
    public void testSerialization(short version) {
        UpdateFeaturesResponse noErrorResponse = UpdateFeaturesResponse.parse((ByteBuffer)UpdateFeaturesResponse.createWithErrors((ApiError)ApiError.NONE, Set.of("feature-1", "feature-2"), (int)0).serialize(version), (short)version);
        int expectedSize = version <= 1 ? 2 : 0;
        Assertions.assertEquals((Object)ApiError.NONE, (Object)noErrorResponse.topLevelError());
        Assertions.assertEquals((int)expectedSize, (int)noErrorResponse.data().results().size());
        ApiError error = new ApiError(Errors.INVALID_UPDATE_VERSION);
        UpdateFeaturesResponse errorResponse = UpdateFeaturesResponse.parse((ByteBuffer)UpdateFeaturesResponse.createWithErrors((ApiError)error, Set.of("feature-1", "feature-2"), (int)0).serialize(version), (short)version);
        Assertions.assertEquals((Object)error, (Object)errorResponse.topLevelError());
        Assertions.assertEquals((int)0, (int)errorResponse.data().results().size());
    }
}

