/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Frequencies;
import org.apache.kafka.common.metrics.stats.Frequency;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FrequenciesTest {
    private static final double DELTA = 1.0E-4;
    private MetricConfig config;
    private Time time;
    private Metrics metrics;

    @BeforeEach
    public void setup() {
        this.config = new MetricConfig().eventWindow(50L).samples(2);
        this.time = new MockTime();
        this.metrics = new Metrics(this.config, Collections.singletonList(new JmxReporter()), this.time, true);
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testFrequencyCenterValueAboveMax() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", 20.0)}));
    }

    @Test
    public void testFrequencyCenterValueBelowMin() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", -20.0)}));
    }

    @Test
    public void testMoreFrequencyParametersThanBuckets() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Frequencies(1, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", -20.0)}));
    }

    @Test
    public void testBooleanFrequenciesStrategy1() {
        int i;
        MetricName metricTrue = this.metricName("true");
        MetricName metricFalse = this.metricName("false");
        Frequencies frequencies = Frequencies.forBooleanValues((MetricName)metricFalse, (MetricName)metricTrue);
        CompoundStat.NamedMeasurable falseMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(0);
        CompoundStat.NamedMeasurable trueMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(1);
        for (i = 0; i != 25; ++i) {
            frequencies.record(this.config, 0.0, this.time.milliseconds());
        }
        for (i = 0; i != 75; ++i) {
            frequencies.record(this.config, 1.0, this.time.milliseconds());
        }
        Assertions.assertEquals((double)0.25, (double)falseMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
        Assertions.assertEquals((double)0.75, (double)trueMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
    }

    @Test
    public void testBooleanFrequenciesStrategy2() {
        int i;
        MetricName metricTrue = this.metricName("true");
        MetricName metricFalse = this.metricName("false");
        Frequencies frequencies = Frequencies.forBooleanValues((MetricName)metricFalse, (MetricName)metricTrue);
        CompoundStat.NamedMeasurable falseMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(0);
        CompoundStat.NamedMeasurable trueMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(1);
        for (i = 0; i != 40; ++i) {
            frequencies.record(this.config, 0.0, this.time.milliseconds());
        }
        for (i = 0; i != 60; ++i) {
            frequencies.record(this.config, 1.0, this.time.milliseconds());
        }
        Assertions.assertEquals((double)0.4, (double)falseMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
        Assertions.assertEquals((double)0.6, (double)trueMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
    }

    @Test
    public void testWithMetricsStrategy1() {
        Frequencies frequencies = new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", 2.0), this.freq("3", 3.0), this.freq("4", 4.0)});
        Sensor sensor = this.metrics.sensor("test", this.config, new Sensor[0]);
        sensor.add((CompoundStat)frequencies);
        for (int i = 0; i < 100; ++i) {
            frequencies.record(this.config, (double)(i % 4 + 1), this.time.milliseconds());
        }
        Assertions.assertEquals((double)0.25, (double)this.metricValue("1"), (double)1.0E-4);
        Assertions.assertEquals((double)0.25, (double)this.metricValue("2"), (double)1.0E-4);
        Assertions.assertEquals((double)0.25, (double)this.metricValue("3"), (double)1.0E-4);
        Assertions.assertEquals((double)0.25, (double)this.metricValue("4"), (double)1.0E-4);
    }

    @Test
    public void testWithMetricsStrategy2() {
        Frequencies frequencies = new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", 2.0), this.freq("3", 3.0), this.freq("4", 4.0)});
        Sensor sensor = this.metrics.sensor("test", this.config, new Sensor[0]);
        sensor.add((CompoundStat)frequencies);
        for (int i = 0; i < 100; ++i) {
            frequencies.record(this.config, (double)(i % 2 + 1), this.time.milliseconds());
        }
        Assertions.assertEquals((double)0.5, (double)this.metricValue("1"), (double)1.0E-4);
        Assertions.assertEquals((double)0.5, (double)this.metricValue("2"), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)this.metricValue("3"), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)this.metricValue("4"), (double)1.0E-4);
    }

    @Test
    public void testWithMetricsStrategy3() {
        int i;
        Frequencies frequencies = new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", 2.0), this.freq("3", 3.0), this.freq("4", 4.0)});
        Sensor sensor = this.metrics.sensor("test", this.config, new Sensor[0]);
        sensor.add((CompoundStat)frequencies);
        for (i = 0; i < 50; ++i) {
            frequencies.record(this.config, (double)(i % 2 + 1), this.time.milliseconds());
        }
        for (i = 0; i < 50; ++i) {
            frequencies.record(this.config, 4.0, this.time.milliseconds());
        }
        Assertions.assertEquals((double)0.25, (double)this.metricValue("1"), (double)1.0E-4);
        Assertions.assertEquals((double)0.25, (double)this.metricValue("2"), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)this.metricValue("3"), (double)1.0E-4);
        Assertions.assertEquals((double)0.5, (double)this.metricValue("4"), (double)1.0E-4);
    }

    private MetricName metricName(String name) {
        return new MetricName(name, "group-id", "desc", Collections.emptyMap());
    }

    private Frequency freq(String name, double value) {
        return new Frequency(this.metricName(name), value);
    }

    private double metricValue(String name) {
        return (Double)((KafkaMetric)this.metrics.metrics().get(this.metricName(name))).metricValue();
    }
}

