/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class BrokerRegistrationRequestTest {
    BrokerRegistrationRequestTest() {
    }

    private static Stream<Arguments> BrokerRegistrationRequestVersions() {
        return IntStream.range(0, 5).mapToObj(version -> Arguments.of((Object[])new Object[]{(short)version}));
    }

    private static Stream<Arguments> BrokerRegistrationRequestVersionsWithoutV0() {
        return BrokerRegistrationRequestTest.BrokerRegistrationRequestVersions().skip(1L);
    }

    @ParameterizedTest
    @MethodSource(value={"BrokerRegistrationRequestVersions"})
    public void testBasicBuild(short version) {
        Uuid incarnationId = Uuid.randomUuid();
        BrokerRegistrationRequestData data = new BrokerRegistrationRequestData();
        data.setBrokerId(0).setIsMigratingZkBroker(false).setClusterId("test").setFeatures(new BrokerRegistrationRequestData.FeatureCollection()).setIncarnationId(incarnationId).setListeners(new BrokerRegistrationRequestData.ListenerCollection()).setRack("a").setPreviousBrokerEpoch(1L);
        BrokerRegistrationRequestData data2 = BrokerRegistrationRequestTest.readSerializedRequest(version, data);
        Assertions.assertEquals((int)0, (int)data2.brokerId(), (String)("Unexpected broker ID in " + data2));
        Assertions.assertEquals((Object)"test", (Object)data2.clusterId(), (String)("Unexpected cluster ID in " + data2));
        Assertions.assertEquals((Object)incarnationId, (Object)data2.incarnationId(), (String)("Unexpected incarnation ID in " + data2));
        Assertions.assertEquals((Object)"a", (Object)data2.rack(), (String)("Unexpected rack in " + data2));
        if (version >= 3) {
            Assertions.assertEquals((long)1L, (long)data2.previousBrokerEpoch(), (String)("Unexpected previousBrokerEpoch in " + data2));
        } else {
            Assertions.assertEquals((long)-1L, (long)data2.previousBrokerEpoch(), (String)("Unexpected previousBrokerEpoch in " + data2));
        }
    }

    @Test
    public void testV0SerializationFailsWithZkMigrationEnabled() {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> BrokerRegistrationRequestTest.readSerializedRequest((short)0, new BrokerRegistrationRequestData().setIsMigratingZkBroker(true)));
    }

    @ParameterizedTest
    @MethodSource(value={"BrokerRegistrationRequestVersionsWithoutV0"})
    public void testAlterFeaturesWithMinVersion0BeforeV4(short version) {
        BrokerRegistrationRequestData data = BrokerRegistrationRequestTest.readSerializedRequest(version, new BrokerRegistrationRequestData().setBrokerId(1).setIsMigratingZkBroker(true).setClusterId("test").setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Arrays.asList(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion((short)1).setMaxSupportedVersion((short)17), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion((short)0).setMaxSupportedVersion((short)1)).iterator())).setIncarnationId(Uuid.fromString((String)"EfIEKywJSaWl5yWDwlop1Q")).setListeners(new BrokerRegistrationRequestData.ListenerCollection()).setPreviousBrokerEpoch(1L));
        Assertions.assertEquals((int)1, (int)data.brokerId());
        Assertions.assertNull((Object)data.rack());
        Assertions.assertEquals((Object)Uuid.fromString((String)"EfIEKywJSaWl5yWDwlop1Q"), (Object)data.incarnationId());
        if (version < 4) {
            Assertions.assertEquals((Object)new BrokerRegistrationRequestData.FeatureCollection(Arrays.asList(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion((short)1).setMaxSupportedVersion((short)17)).iterator()), (Object)data.features());
        } else {
            Assertions.assertEquals((Object)new BrokerRegistrationRequestData.FeatureCollection(Arrays.asList(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion((short)1).setMaxSupportedVersion((short)17), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion((short)0).setMaxSupportedVersion((short)1)).iterator()), (Object)data.features());
        }
    }

    static BrokerRegistrationRequestData readSerializedRequest(short version, BrokerRegistrationRequestData input) {
        BrokerRegistrationRequest.Builder builder = new BrokerRegistrationRequest.Builder(input);
        if (input.isMigratingZkBroker()) {
            Assertions.assertEquals((short)1, (short)builder.oldestAllowedVersion());
        } else {
            Assertions.assertEquals((short)0, (short)builder.oldestAllowedVersion());
        }
        BrokerRegistrationRequest request = builder.build(version);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = request.data().size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        request.data().write((Writable)byteBufferAccessor, cache, version);
        BrokerRegistrationRequestData data2 = new BrokerRegistrationRequestData();
        buf.flip();
        data2.read((Readable)byteBufferAccessor, version);
        return data2;
    }
}

