/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public final class MessageUtilTest {
    @Test
    public void testDeepToString() {
        Assertions.assertEquals((Object)"[1, 2, 3]", (Object)MessageUtil.deepToString(Arrays.asList(1, 2, 3).iterator()));
        Assertions.assertEquals((Object)"[foo]", (Object)MessageUtil.deepToString(Collections.singletonList("foo").iterator()));
    }

    @Test
    public void testByteBufferToArray() {
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[]{1, 2, 3})));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }

    @Test
    public void testDuplicate() {
        Assertions.assertNull((Object)MessageUtil.duplicate(null));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])MessageUtil.duplicate((byte[])new byte[0]));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])MessageUtil.duplicate((byte[])new byte[]{1, 2, 3}));
    }

    @Test
    public void testCompareRawTaggedFields() {
        Assertions.assertTrue((boolean)MessageUtil.compareRawTaggedFields(null, null));
        Assertions.assertTrue((boolean)MessageUtil.compareRawTaggedFields(null, Collections.emptyList()));
        Assertions.assertTrue((boolean)MessageUtil.compareRawTaggedFields(Collections.emptyList(), null));
        Assertions.assertFalse((boolean)MessageUtil.compareRawTaggedFields(Collections.emptyList(), Collections.singletonList(new RawTaggedField(1, new byte[]{1}))));
        Assertions.assertFalse((boolean)MessageUtil.compareRawTaggedFields(null, Collections.singletonList(new RawTaggedField(1, new byte[]{1}))));
        Assertions.assertFalse((boolean)MessageUtil.compareRawTaggedFields(Collections.singletonList(new RawTaggedField(1, new byte[]{1})), Collections.emptyList()));
        Assertions.assertTrue((boolean)MessageUtil.compareRawTaggedFields(Arrays.asList(new RawTaggedField(1, new byte[]{1}), new RawTaggedField(2, new byte[0])), Arrays.asList(new RawTaggedField(1, new byte[]{1}), new RawTaggedField(2, new byte[0]))));
    }

    @Test
    public void testConstants() {
        Assertions.assertEquals((int)65535, (int)65535);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)0xFFFFFFFFL);
    }

    @Test
    public void testBinaryNode() throws IOException {
        byte[] expected = new byte[]{5, 2, 9, 4, 1, 8, 7, 0, 3, 6};
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeTree(mapper.createGenerator((Writer)writer), (JsonNode)new BinaryNode(expected));
        JsonNode textNode = mapper.readTree(writer.toString());
        Assertions.assertTrue((boolean)textNode.isTextual(), (String)String.format("Expected a JSON string but was: %s", textNode));
        byte[] actual = MessageUtil.jsonNodeToBinary((JsonNode)textNode, (String)"Test base64 JSON string");
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testInvalidBinaryNode() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MessageUtil.jsonNodeToBinary((JsonNode)new IntNode(42), (String)"Test int to binary"));
        Assertions.assertThrows(UncheckedIOException.class, () -> MessageUtil.jsonNodeToBinary((JsonNode)new TextNode("This is not base64!"), (String)"Test non-base64 to binary"));
    }
}

