/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataSnapshot;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockClusterResourceListener;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MetadataTest {
    private final long refreshBackoffMs = 100L;
    private final long refreshBackoffMaxMs = 1000L;
    private final long metadataExpireMs = 1000L;
    private Metadata metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());

    private static MetadataResponse emptyMetadataResponse() {
        return RequestTestUtils.metadataResponse(Collections.emptyList(), null, -1, Collections.emptyList());
    }

    @Test
    public void testMetadataUpdateAfterClose() {
        this.metadata.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 1000L));
    }

    private static void checkTimeToNextUpdate(long refreshBackoffMs, long metadataExpireMs) {
        long now = 10000L;
        if (metadataExpireMs > now || refreshBackoffMs > now) {
            throw new IllegalArgumentException("metadataExpireMs and refreshBackoffMs must be smaller than 'now'");
        }
        long largerOfBackoffAndExpire = Math.max(refreshBackoffMs, metadataExpireMs);
        Metadata metadata = new Metadata(refreshBackoffMs, refreshBackoffMs, metadataExpireMs, new LogContext(), new ClusterResourceListeners());
        Assertions.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now));
        metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, now);
        Assertions.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        metadata.requestUpdate(true);
        Assertions.assertEquals((long)refreshBackoffMs, (long)metadata.timeToNextUpdate(now));
        metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, now);
        Assertions.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        Assertions.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now += largerOfBackoffAndExpire));
        Assertions.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testUpdateMetadataAllowedImmediatelyAfterBootstrap() {
        MockTime time = new MockTime();
        Metadata metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());
        metadata.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9002)));
        Assertions.assertEquals((long)0L, (long)metadata.timeToAllowUpdate(time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)metadata.timeToNextUpdate(time.milliseconds()));
    }

    @Test
    public void testTimeToNextUpdate() {
        MetadataTest.checkTimeToNextUpdate(100L, 1000L);
        MetadataTest.checkTimeToNextUpdate(1000L, 100L);
        MetadataTest.checkTimeToNextUpdate(0L, 0L);
        MetadataTest.checkTimeToNextUpdate(0L, 100L);
        MetadataTest.checkTimeToNextUpdate(100L, 0L);
    }

    @Test
    public void testTimeToNextUpdateRetryBackoff() {
        long now = 10000L;
        this.metadata.failedUpdate(now);
        long lowerBoundBackoffMs = 80L;
        long upperBoundBackoffMs = 120L;
        Assertions.assertEquals((float)100.0f, (float)this.metadata.timeToNextUpdate(now), (float)(upperBoundBackoffMs - lowerBoundBackoffMs));
        this.metadata.requestUpdate(true);
        Assertions.assertEquals((float)100.0f, (float)this.metadata.timeToNextUpdate(now), (float)(upperBoundBackoffMs - lowerBoundBackoffMs));
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now += 100L + upperBoundBackoffMs));
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testIgnoreLeaderEpochInOlderMetadataResponse() {
        MetadataResponse.PartitionMetadata responseMetadata;
        MetadataResponse response;
        ByteBuffer buffer;
        short version;
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponseData.MetadataResponsePartition partitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setLeaderId(5).setLeaderEpoch(10).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setName(tp.topic()).setErrorCode(Errors.NONE.code()).setPartitions(Collections.singletonList(partitionMetadata)).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)topicMetadata);
        MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(topics).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
        for (version = ApiKeys.METADATA.oldestVersion(); version < 9; version = (short)(version + 1)) {
            buffer = MessageUtil.toByteBuffer((Message)data, (short)version);
            response = MetadataResponse.parse((ByteBuffer)buffer, (short)version);
            Assertions.assertFalse((boolean)response.hasReliableLeaderEpochs());
            this.metadata.updateWithCurrentRequestVersion(response, false, 100L);
            Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
            responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
            Assertions.assertEquals(Optional.empty(), (Object)responseMetadata.leaderEpoch);
        }
        for (version = 9; version <= ApiKeys.METADATA.latestVersion(); version = (short)(version + 1)) {
            buffer = MessageUtil.toByteBuffer((Message)data, (short)version);
            response = MetadataResponse.parse((ByteBuffer)buffer, (short)version);
            Assertions.assertTrue((boolean)response.hasReliableLeaderEpochs());
            this.metadata.updateWithCurrentRequestVersion(response, false, 100L);
            Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
            responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
            Assertions.assertEquals(Optional.of(10), (Object)responseMetadata.leaderEpoch);
        }
    }

    @Test
    public void testStaleMetadata() {
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponseData.MetadataResponsePartition partitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setLeaderId(1).setLeaderEpoch(10).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setName(tp.topic()).setErrorCode(Errors.NONE.code()).setPartitions(Collections.singletonList(partitionMetadata)).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)topicMetadata);
        MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(topics).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(data, ApiKeys.METADATA.latestVersion()), false, 100L);
        partitionMetadata.setPartitionIndex(tp.partition()).setLeaderId(1).setLeaderEpoch(9).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(data, ApiKeys.METADATA.latestVersion()), false, 101L);
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        MetadataResponse.PartitionMetadata responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)responseMetadata.inSyncReplicaIds);
        Assertions.assertEquals(Optional.of(10), (Object)responseMetadata.leaderEpoch);
    }

    @Test
    public void testFailedUpdate() {
        long time = 100L;
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time);
        Assertions.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
        this.metadata.failedUpdate(1100L);
        long lowerBoundBackoffMs = 80L;
        long upperBoundBackoffMs = 120L;
        Assertions.assertEquals((float)100.0f, (float)this.metadata.timeToNextUpdate(1100L), (float)(upperBoundBackoffMs - lowerBoundBackoffMs));
        Assertions.assertEquals((long)100L, (long)this.metadata.lastSuccessfulUpdate());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time);
        Assertions.assertEquals((float)100.0f, (float)this.metadata.timeToNextUpdate(1000L), (float)(upperBoundBackoffMs - lowerBoundBackoffMs));
    }

    @Test
    public void testClusterListenerGetsNotifiedOfUpdate() {
        MockClusterResourceListener mockClusterListener = new MockClusterResourceListener();
        ClusterResourceListeners listeners = new ClusterResourceListeners();
        listeners.maybeAdd((Object)mockClusterListener);
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), listeners);
        String hostName = "www.example.com";
        this.metadata.bootstrap(Collections.singletonList(new InetSocketAddress(hostName, 9002)));
        Assertions.assertFalse((boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get(), (String)"ClusterResourceListener should not called when metadata is updated with bootstrap Cluster");
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic", 1);
        partitionCounts.put("topic1", 1);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, partitionCounts);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 100L);
        Assertions.assertEquals((Object)"dummy", (Object)mockClusterListener.clusterResource().clusterId(), (String)"MockClusterResourceListener did not get cluster metadata correctly");
        Assertions.assertTrue((boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get(), (String)"MockClusterResourceListener should be called when metadata is updated with non-bootstrap Cluster");
    }

    @Test
    public void testRequestUpdate() {
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        int[] epochs = new int[]{42, 42, 41, 41, 42, 43, 43, 42, 41, 44};
        boolean[] updateResult = new boolean[]{true, false, false, false, false, true, false, false, false, true};
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic", 1), _tp -> 0);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        for (int i = 0; i < epochs.length; ++i) {
            this.metadata.updateLastSeenEpochIfNewer(tp, epochs[i]);
            if (updateResult[i]) {
                Assertions.assertTrue((boolean)this.metadata.updateRequested(), (String)("Expected metadata update to be requested [" + i + "]"));
            } else {
                Assertions.assertFalse((boolean)this.metadata.updateRequested(), (String)("Did not expect metadata update to be requested [" + i + "]"));
            }
            this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
            Assertions.assertFalse((boolean)this.metadata.updateRequested());
        }
    }

    @Test
    public void testUpdateLastEpoch() {
        TopicPartition tp = new TopicPartition("topic-1", 0);
        MetadataResponse metadataResponse = MetadataTest.emptyMetadataResponse();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 0));
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 2));
        Assertions.assertFalse((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 10);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)10));
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)10));
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 10));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)10));
        Assertions.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 12));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)12));
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 12);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 2L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)12));
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 11);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 3L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assertions.assertEquals((int)leaderAndEpoch, (int)12));
    }

    @Test
    public void testEpochUpdateAfterTopicDeletion() {
        TopicPartition tp = new TopicPartition("topic-1", 0);
        MetadataResponse metadataResponse = MetadataTest.emptyMetadataResponse();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        Map<String, Uuid> topicIds = Collections.singletonMap("topic-1", Uuid.randomUuid());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 10, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.singletonMap("topic-1", Errors.UNKNOWN_TOPIC_OR_PARTITION), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Map<String, Uuid> newTopicIds = Collections.singletonMap("topic-1", Uuid.randomUuid());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 5, newTopicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        Assertions.assertEquals(Optional.of(5), (Object)this.metadata.lastSeenLeaderEpoch(tp));
    }

    @Test
    public void testEpochUpdateOnChangedTopicIds() {
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Map<String, Uuid> topicIds = Collections.singletonMap("topic-1", Uuid.randomUuid());
        MetadataResponse metadataResponse = MetadataTest.emptyMetadataResponse();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        Assertions.assertEquals(Optional.of(100), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 10, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 2L);
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 10, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 3L);
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 12, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 4L);
        Assertions.assertEquals(Optional.of(12), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Map<String, Uuid> newTopicIds = Collections.singletonMap("topic-1", Uuid.randomUuid());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 3, newTopicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 5L);
        Assertions.assertEquals(Optional.of(3), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Map<String, Uuid> newTopicIds2 = Collections.singletonMap("topic-1", Uuid.randomUuid());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 20, newTopicIds2);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 6L);
        Assertions.assertEquals(Optional.of(20), (Object)this.metadata.lastSeenLeaderEpoch(tp));
    }

    @Test
    public void testRejectOldMetadata() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assertions.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertTrue((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas), ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assertions.assertEquals((int)this.metadata.fetch().partition(tp).inSyncReplicas().length, (int)1);
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas), ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assertions.assertEquals((int)this.metadata.fetch().partition(tp).inSyncReplicas().length, (int)0);
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assertions.assertNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assertions.assertNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
    }

    @Test
    public void testOutOfBandEpochUpdate() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 5);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        Assertions.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 99));
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assertions.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertTrue((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        Assertions.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 101));
        Assertions.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assertions.assertFalse((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assertions.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assertions.assertFalse((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 101);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 30L);
        Assertions.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assertions.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
    }

    @Test
    public void testNoEpoch() {
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1));
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Assertions.assertFalse((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get()).partition());
        Assertions.assertEquals(Optional.of(0), (Object)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent((TopicPartition)tp).get()).leaderId);
        this.metadata.updateLastSeenEpochIfNewer(tp, 10);
        Assertions.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assertions.assertFalse((boolean)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent((TopicPartition)tp).get()).leaderEpoch.isPresent());
    }

    @Test
    public void testClusterCopy() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        counts.put("topic1", 2);
        counts.put("topic2", 3);
        counts.put("__consumer_offsets", 3);
        errors.put("topic3", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("topic4", Errors.TOPIC_AUTHORIZATION_FAILED);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 4, errors, counts);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        Cluster cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)"dummy");
        Assertions.assertEquals((int)cluster.nodes().size(), (int)4);
        Assertions.assertEquals((Object)cluster.invalidTopics(), Collections.singleton("topic3"));
        Assertions.assertEquals((Object)cluster.unauthorizedTopics(), Collections.singleton("topic4"));
        Assertions.assertEquals((int)cluster.topics().size(), (int)3);
        Assertions.assertEquals((Object)cluster.internalTopics(), Collections.singleton("__consumer_offsets"));
        Assertions.assertEquals((int)cluster.partitionsForTopic("topic1").size(), (int)2);
        Assertions.assertEquals((int)cluster.partitionsForTopic("topic2").size(), (int)3);
        InetSocketAddress address = InetSocketAddress.createUnresolved("localhost", 0);
        Cluster fromMetadata = MetadataSnapshot.bootstrap(Collections.singletonList(address)).cluster();
        Cluster fromCluster = Cluster.bootstrap(Collections.singletonList(address));
        Assertions.assertEquals((Object)fromMetadata, (Object)fromCluster);
        Cluster fromMetadataEmpty = MetadataSnapshot.empty().cluster();
        Cluster fromClusterEmpty = Cluster.empty();
        Assertions.assertEquals((Object)fromMetadataEmpty, (Object)fromClusterEmpty);
    }

    @Test
    public void testRequestVersion() {
        MockTime time = new MockTime();
        this.metadata.requestUpdate(true);
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.requestUpdateForNewTopics();
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
    }

    @Test
    public void testPartialMetadataUpdate() {
        MockTime time = new MockTime();
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners()){

            protected MetadataRequest.Builder newMetadataRequestBuilderForNewTopics() {
                return this.newMetadataRequestBuilder();
            }
        };
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdate(true);
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertTrue((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdate(true);
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        long refreshTimeMs = time.milliseconds() + this.metadata.metadataExpireMs();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(refreshTimeMs);
        Assertions.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, refreshTimeMs);
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertTrue((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.requestUpdateForNewTopics();
        Metadata.MetadataRequestAndVersion overlappingVersionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertTrue((boolean)overlappingVersionAndBuilder.isPartialUpdate);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic-1", 1)), true, time.milliseconds());
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.update(overlappingVersionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(1, Collections.singletonMap("topic-2", 1)), true, time.milliseconds());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
    }

    @Test
    public void testInvalidTopicError() {
        MockTime time = new MockTime();
        String invalidTopic = "topic dfsa";
        MetadataResponse invalidTopicResponse = RequestTestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.INVALID_TOPIC_EXCEPTION), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(invalidTopicResponse, false, time.milliseconds());
        InvalidTopicException e = (InvalidTopicException)Assertions.assertThrows(InvalidTopicException.class, () -> this.metadata.maybeThrowAnyException());
        Assertions.assertEquals(Collections.singleton(invalidTopic), (Object)e.invalidTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(invalidTopicResponse, false, time.milliseconds());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time.milliseconds());
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testTopicAuthorizationError() {
        MockTime time = new MockTime();
        String invalidTopic = "foo";
        MetadataResponse unauthorizedTopicResponse = RequestTestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.TOPIC_AUTHORIZATION_FAILED), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(unauthorizedTopicResponse, false, time.milliseconds());
        TopicAuthorizationException e = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowAnyException());
        Assertions.assertEquals(Collections.singleton(invalidTopic), (Object)e.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(unauthorizedTopicResponse, false, time.milliseconds());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time.milliseconds());
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testMetadataTopicErrors() {
        MockTime time = new MockTime();
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>(3);
        topicErrors.put("invalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        topicErrors.put("sensitiveTopic1", Errors.TOPIC_AUTHORIZATION_FAILED);
        topicErrors.put("sensitiveTopic2", Errors.TOPIC_AUTHORIZATION_FAILED);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("clusterId", 1, topicErrors, Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        TopicAuthorizationException e1 = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowExceptionForTopic("sensitiveTopic1"));
        Assertions.assertEquals(Collections.singleton("sensitiveTopic1"), (Object)e1.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        TopicAuthorizationException e2 = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowExceptionForTopic("sensitiveTopic2"));
        Assertions.assertEquals(Collections.singleton("sensitiveTopic2"), (Object)e2.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        InvalidTopicException e3 = (InvalidTopicException)Assertions.assertThrows(InvalidTopicException.class, () -> this.metadata.maybeThrowExceptionForTopic("invalidTopic"));
        Assertions.assertEquals(Collections.singleton("invalidTopic"), (Object)e3.invalidTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        this.metadata.maybeThrowExceptionForTopic("anotherTopic");
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testNodeIfOffline() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        Node node0 = new Node(0, "localhost", 9092);
        Node node1 = new Node(1, "localhost", 9093);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 2, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, Optional.of(node0.id()), leaderEpoch, Collections.singletonList(node0.id()), Collections.emptyList(), Collections.singletonList(node1.id())), ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        TestUtils.assertOptional(this.metadata.fetch().nodeIfOnline(tp, 0), node -> Assertions.assertEquals((int)node.id(), (int)0));
        Assertions.assertFalse((boolean)this.metadata.fetch().nodeIfOnline(tp, 1).isPresent());
        Assertions.assertEquals((int)this.metadata.fetch().nodeById(0).id(), (int)0);
        Assertions.assertEquals((int)this.metadata.fetch().nodeById(1).id(), (int)1);
    }

    @Test
    public void testNodeIfOnlineWhenNotInReplicaSet() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        Node node0 = new Node(0, "localhost", 9092);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith("dummy", 2, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, Optional.of(node0.id()), leaderEpoch, Collections.singletonList(node0.id()), Collections.emptyList(), Collections.emptyList()), ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Assertions.assertEquals((int)1, (int)this.metadata.fetch().nodeById(1).id());
        Assertions.assertFalse((boolean)this.metadata.fetch().nodeIfOnline(tp, 1).isPresent());
    }

    @Test
    public void testNodeIfOnlineNonExistentTopicPartition() {
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith(2, Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Assertions.assertEquals((int)this.metadata.fetch().nodeById(0).id(), (int)0);
        Assertions.assertNull((Object)this.metadata.fetch().partition(tp));
        Assertions.assertEquals((Object)this.metadata.fetch().nodeIfOnline(tp, 0), Optional.empty());
    }

    @Test
    public void testLeaderMetadataInconsistentWithBrokerMetadata() {
        TopicPartition tp = new TopicPartition("topic", 0);
        Node node0 = new Node(0, "localhost", 9092);
        Node node1 = new Node(1, "localhost", 9093);
        Node node2 = new Node(2, "localhost", 9094);
        MetadataResponseData.MetadataResponsePartition firstPartitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(10).setLeaderId(0).setReplicaNodes(Arrays.asList(0, 1, 2)).setIsrNodes(Arrays.asList(0, 1, 2)).setOfflineReplicas(Collections.emptyList());
        MetadataResponseData.MetadataResponsePartition secondPartitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(8).setLeaderId(1).setReplicaNodes(Arrays.asList(0, 1, 2)).setIsrNodes(Arrays.asList(1, 2)).setOfflineReplicas(Collections.singletonList(0));
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(new MetadataResponseData().setTopics(this.buildTopicCollection(tp.topic(), firstPartitionMetadata)).setBrokers(this.buildBrokerCollection(Arrays.asList(node0, node1, node2))), ApiKeys.METADATA.latestVersion()), false, 10L);
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(new MetadataResponseData().setTopics(this.buildTopicCollection(tp.topic(), secondPartitionMetadata)).setBrokers(this.buildBrokerCollection(Arrays.asList(node1, node2))), ApiKeys.METADATA.latestVersion()), false, 20L);
        Assertions.assertNull((Object)this.metadata.fetch().leaderFor(tp));
        Assertions.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Assertions.assertFalse((boolean)this.metadata.currentLeader((TopicPartition)tp).leader.isPresent());
    }

    private MetadataResponseData.MetadataResponseTopicCollection buildTopicCollection(String topic, MetadataResponseData.MetadataResponsePartition partitionMetadata) {
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setIsInternal(false);
        topicMetadata.setPartitions(Collections.singletonList(partitionMetadata));
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)topicMetadata);
        return topics;
    }

    private MetadataResponseData.MetadataResponseBrokerCollection buildBrokerCollection(List<Node> nodes) {
        MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
        for (Node node : nodes) {
            MetadataResponseData.MetadataResponseBroker broker = new MetadataResponseData.MetadataResponseBroker().setNodeId(node.id()).setHost(node.host()).setPort(node.port()).setRack(node.rack());
            brokers.add((ImplicitLinkedHashCollection.Element)broker);
        }
        return brokers;
    }

    @Test
    public void testMetadataMerge() {
        MockTime time = new MockTime();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        final AtomicReference retainTopics = new AtomicReference(new HashSet());
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners()){

            protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
                return ((Set)retainTopics.get()).contains(topic);
            }
        };
        String oldClusterId = "oldClusterId";
        int oldNodes = 2;
        HashMap<String, Errors> oldTopicErrors = new HashMap<String, Errors>();
        oldTopicErrors.put("oldInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        oldTopicErrors.put("keepInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        oldTopicErrors.put("oldUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        oldTopicErrors.put("keepUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        HashMap<String, Integer> oldTopicPartitionCounts = new HashMap<String, Integer>();
        oldTopicPartitionCounts.put("oldValidTopic", 2);
        oldTopicPartitionCounts.put("keepValidTopic", 3);
        retainTopics.set(Utils.mkSet((Object[])new String[]{"oldInvalidTopic", "keepInvalidTopic", "oldUnauthorizedTopic", "keepUnauthorizedTopic", "oldValidTopic", "keepValidTopic"}));
        topicIds.put("oldValidTopic", Uuid.randomUuid());
        topicIds.put("keepValidTopic", Uuid.randomUuid());
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWithIds(oldClusterId, oldNodes, oldTopicErrors, oldTopicPartitionCounts, _tp -> 100, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        Map metadataTopicIds1 = this.metadata.topicIds();
        ((Set)retainTopics.get()).forEach(topic -> Assertions.assertEquals(metadataTopicIds1.get(topic), topicIds.get(topic)));
        Cluster cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)oldClusterId);
        Assertions.assertEquals((int)cluster.nodes().size(), (int)oldNodes);
        Assertions.assertEquals((Object)cluster.invalidTopics(), new HashSet<String>(Arrays.asList("oldInvalidTopic", "keepInvalidTopic")));
        Assertions.assertEquals((Object)cluster.unauthorizedTopics(), new HashSet<String>(Arrays.asList("oldUnauthorizedTopic", "keepUnauthorizedTopic")));
        Assertions.assertEquals((Object)cluster.topics(), new HashSet<String>(Arrays.asList("oldValidTopic", "keepValidTopic")));
        Assertions.assertEquals((int)cluster.partitionsForTopic("oldValidTopic").size(), (int)2);
        Assertions.assertEquals((int)cluster.partitionsForTopic("keepValidTopic").size(), (int)3);
        Assertions.assertEquals(new HashSet(cluster.topicIds()), new HashSet(topicIds.values()));
        String newClusterId = "newClusterId";
        int newNodes = oldNodes + 1;
        HashMap<String, Errors> newTopicErrors = new HashMap<String, Errors>();
        newTopicErrors.put("newInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        newTopicErrors.put("newUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        HashMap<String, Integer> newTopicPartitionCounts = new HashMap<String, Integer>();
        newTopicPartitionCounts.put("keepValidTopic", 2);
        newTopicPartitionCounts.put("newValidTopic", 4);
        retainTopics.set(Utils.mkSet((Object[])new String[]{"keepInvalidTopic", "newInvalidTopic", "keepUnauthorizedTopic", "newUnauthorizedTopic", "keepValidTopic", "newValidTopic"}));
        topicIds.put("newValidTopic", Uuid.randomUuid());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds(newClusterId, newNodes, newTopicErrors, newTopicPartitionCounts, _tp -> 200, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        topicIds.remove("oldValidTopic");
        Map metadataTopicIds2 = this.metadata.topicIds();
        ((Set)retainTopics.get()).forEach(topic -> Assertions.assertEquals(metadataTopicIds2.get(topic), topicIds.get(topic)));
        Assertions.assertNull(metadataTopicIds2.get("oldValidTopic"));
        cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)newClusterId);
        Assertions.assertEquals((int)cluster.nodes().size(), (int)newNodes);
        Assertions.assertEquals((Object)cluster.invalidTopics(), new HashSet<String>(Arrays.asList("keepInvalidTopic", "newInvalidTopic")));
        Assertions.assertEquals((Object)cluster.unauthorizedTopics(), new HashSet<String>(Arrays.asList("keepUnauthorizedTopic", "newUnauthorizedTopic")));
        Assertions.assertEquals((Object)cluster.topics(), new HashSet<String>(Arrays.asList("keepValidTopic", "newValidTopic")));
        Assertions.assertEquals((int)cluster.partitionsForTopic("keepValidTopic").size(), (int)2);
        Assertions.assertEquals((int)cluster.partitionsForTopic("newValidTopic").size(), (int)4);
        Assertions.assertEquals(new HashSet(cluster.topicIds()), new HashSet(topicIds.values()));
        retainTopics.set(Collections.emptySet());
        metadataResponse = RequestTestUtils.metadataUpdateWithIds(newClusterId, newNodes, newTopicErrors, newTopicPartitionCounts, _tp -> 300, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        Map metadataTopicIds3 = this.metadata.topicIds();
        topicIds.forEach((topicName, topicId) -> Assertions.assertNull(metadataTopicIds3.get(topicName)));
        cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)newClusterId);
        Assertions.assertEquals((int)cluster.nodes().size(), (int)newNodes);
        Assertions.assertEquals((Object)cluster.invalidTopics(), Collections.emptySet());
        Assertions.assertEquals((Object)cluster.unauthorizedTopics(), Collections.emptySet());
        Assertions.assertEquals((Object)cluster.topics(), Collections.emptySet());
        Assertions.assertTrue((boolean)cluster.topicIds().isEmpty());
    }

    @Test
    public void testMetadataMergeOnIdDowngrade() {
        MockTime time = new MockTime();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        final AtomicReference retainTopics = new AtomicReference(new HashSet());
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners()){

            protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
                return ((Set)retainTopics.get()).contains(topic);
            }
        };
        String clusterId = "clusterId";
        int nodes = 2;
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        topicPartitionCounts.put("validTopic1", 2);
        topicPartitionCounts.put("validTopic2", 3);
        retainTopics.set(Utils.mkSet((Object[])new String[]{"validTopic1", "validTopic2"}));
        topicIds.put("validTopic1", Uuid.randomUuid());
        topicIds.put("validTopic2", Uuid.randomUuid());
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWithIds(clusterId, nodes, Collections.emptyMap(), topicPartitionCounts, _tp -> 100, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        Map metadataTopicIds1 = this.metadata.topicIds();
        ((Set)retainTopics.get()).forEach(topic -> Assertions.assertEquals(metadataTopicIds1.get(topic), topicIds.get(topic)));
        topicIds.remove("validTopic1");
        metadataResponse = RequestTestUtils.metadataUpdateWithIds(clusterId, nodes, Collections.emptyMap(), topicPartitionCounts, _tp -> 200, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        Map metadataTopicIds2 = this.metadata.topicIds();
        ((Set)retainTopics.get()).forEach(topic -> Assertions.assertEquals(metadataTopicIds2.get(topic), topicIds.get(topic)));
        Cluster cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"validTopic1", "validTopic2"}), (Object)cluster.topics());
        Assertions.assertEquals((int)2, (int)cluster.partitionsForTopic("validTopic1").size());
        Assertions.assertEquals(new HashSet(topicIds.values()), new HashSet(cluster.topicIds()));
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)cluster.topicId("validTopic1"));
    }

    @Test
    public void testTopicMetadataOnUpdatePartitionLeadership() {
        String topic = "input-topic";
        Uuid topicId = Uuid.randomUuid();
        MockTime time = new MockTime();
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());
        Node node1 = new Node(1, "localhost", 9091);
        Node node2 = new Node(2, "localhost", 9091);
        TopicPartition tp0 = new TopicPartition(topic, 0);
        MetadataResponse.PartitionMetadata partition0 = new MetadataResponse.PartitionMetadata(Errors.NONE, tp0, Optional.of(1), Optional.of(1), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.emptyList());
        TopicPartition tp1 = new TopicPartition(topic, 1);
        MetadataResponse.PartitionMetadata partition1 = new MetadataResponse.PartitionMetadata(Errors.NONE, tp1, Optional.of(1), Optional.of(1), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.emptyList());
        MetadataResponse.TopicMetadata topicMetadata = new MetadataResponse.TopicMetadata(Errors.NONE, topic, topicId, false, Arrays.asList(partition0, partition1), Integer.MIN_VALUE);
        MetadataResponse response = RequestTestUtils.metadataResponse(Arrays.asList(node1, node2), "clusterId", node1.id(), Collections.singletonList(topicMetadata));
        this.metadata.updateWithCurrentRequestVersion(response, false, time.milliseconds());
        Assertions.assertEquals((int)2, (int)this.metadata.fetch().partitionsForTopic(topic).size());
        Assertions.assertEquals((int)1, (int)this.metadata.fetch().partition(tp0).leader().id());
        Assertions.assertEquals((int)1, (int)this.metadata.fetch().partition(tp1).leader().id());
        this.metadata.updatePartitionLeadership(Collections.singletonMap(tp1, new Metadata.LeaderIdAndEpoch(Optional.of(2), Optional.of(3))), Collections.singletonList(node1));
        Assertions.assertEquals((int)2, (int)this.metadata.fetch().partitionsForTopic(topic).size());
        Assertions.assertEquals((int)1, (int)this.metadata.fetch().partition(tp0).leader().id());
        Assertions.assertEquals((int)2, (int)this.metadata.fetch().partition(tp1).leader().id());
    }

    @Test
    public void testUpdatePartitionLeadership() {
        MockTime time = new MockTime();
        int numNodes = 5;
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());
        ClusterResourceListener mockListener = (ClusterResourceListener)Mockito.mock(ClusterResourceListener.class);
        this.metadata.addClusterUpdateListener(mockListener);
        String topic1 = "topic1";
        TopicPartition tp11 = new TopicPartition(topic1, 0);
        MetadataResponse.PartitionMetadata part1Metadata = new MetadataResponse.PartitionMetadata(Errors.NONE, tp11, Optional.of(1), Optional.of(100), Arrays.asList(1, 2), Arrays.asList(1, 2), Collections.singletonList(3));
        Uuid topic1Id = Uuid.randomUuid();
        TopicPartition tp12 = new TopicPartition(topic1, 1);
        MetadataResponse.PartitionMetadata part12Metadata = new MetadataResponse.PartitionMetadata(Errors.NONE, tp12, Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        String topic2 = "topic2";
        TopicPartition tp21 = new TopicPartition(topic2, 0);
        MetadataResponse.PartitionMetadata part2Metadata = new MetadataResponse.PartitionMetadata(Errors.NONE, tp21, Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        Uuid topic2Id = Uuid.randomUuid();
        Set<String> internalTopics = Collections.singleton("__consumer_offsets");
        TopicPartition internalPart = new TopicPartition("__consumer_offsets", 0);
        Uuid internalTopicId = Uuid.randomUuid();
        MetadataResponse.PartitionMetadata internalTopicMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, internalPart, Optional.of(2), Optional.of(200), Arrays.asList(2, 3), Arrays.asList(2, 3), Collections.singletonList(1));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic1, topic1Id);
        topicIds.put(topic2, topic2Id);
        topicIds.put(internalTopics.iterator().next(), internalTopicId);
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        topicPartitionCounts.put(topic1, 2);
        topicPartitionCounts.put(topic2, 1);
        topicPartitionCounts.put(internalTopics.iterator().next(), 1);
        RequestTestUtils.PartitionMetadataSupplier metadataSupplier = (error, partition, leaderId, leaderEpoch, replicas, isr, offlineReplicas) -> {
            if (partition.equals((Object)tp11)) {
                return part1Metadata;
            }
            if (partition.equals((Object)tp21)) {
                return part2Metadata;
            }
            if (partition.equals((Object)tp12)) {
                return part12Metadata;
            }
            if (partition.equals((Object)internalPart)) {
                return internalTopicMetadata;
            }
            throw new RuntimeException("Unexpected partition " + partition);
        };
        HashMap<String, Errors> errorCounts = new HashMap<String, Errors>();
        Set<String> invalidTopics = Collections.singleton("topic3");
        errorCounts.put(invalidTopics.iterator().next(), Errors.INVALID_TOPIC_EXCEPTION);
        Set<String> unauthorizedTopics = Collections.singleton("topic4");
        errorCounts.put(unauthorizedTopics.iterator().next(), Errors.TOPIC_AUTHORIZATION_FAILED);
        this.metadata.requestUpdate(true);
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assertions.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        String clusterId = "kafka-cluster";
        this.metadata.update(versionAndBuilder.requestVersion, RequestTestUtils.metadataUpdateWith(clusterId, numNodes, errorCounts, topicPartitionCounts, tp -> null, metadataSupplier, ApiKeys.METADATA.latestVersion(), topicIds), false, time.milliseconds());
        ArrayList<Node> nodes = new ArrayList<Node>(this.metadata.fetch().nodes());
        Node controller = this.metadata.fetch().controller();
        Assertions.assertEquals((int)numNodes, (int)nodes.size());
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.validateForUpdatePartitionLeadership(this.metadata, part1Metadata, part2Metadata, part12Metadata, internalTopicMetadata, nodes, clusterId, unauthorizedTopics, invalidTopics, internalTopics, controller, topicIds);
        ((ClusterResourceListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.times((int)1))).onUpdate((ClusterResource)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClusterResourceListener[]{mockListener});
        HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> updates = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
        updates.put(new TopicPartition(topic1, 999), new Metadata.LeaderIdAndEpoch(Optional.empty(), Optional.empty()));
        updates.put(tp21, new Metadata.LeaderIdAndEpoch(Optional.of(99999), Optional.of(99999)));
        updates.put(new TopicPartition("topic_missing_from_existing_metadata", 1), new Metadata.LeaderIdAndEpoch(Optional.of(0), Optional.of(99999)));
        updates.put(tp11, new Metadata.LeaderIdAndEpoch(part1Metadata.leaderId, Optional.of((Integer)part1Metadata.leaderEpoch.get() - 1)));
        Set updatedTps = this.metadata.updatePartitionLeadership(updates, nodes);
        Assertions.assertTrue((boolean)updatedTps.isEmpty());
        this.validateForUpdatePartitionLeadership(this.metadata, part1Metadata, part2Metadata, part12Metadata, internalTopicMetadata, nodes, clusterId, unauthorizedTopics, invalidTopics, internalTopics, controller, topicIds);
        ((ClusterResourceListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.never())).onUpdate((ClusterResource)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClusterResourceListener[]{mockListener});
        Integer part1NewLeaderId = (Integer)part1Metadata.leaderId.get() + 1;
        Integer part1NewLeaderEpoch = (Integer)part1Metadata.leaderEpoch.get() + 1;
        updates.put(tp11, new Metadata.LeaderIdAndEpoch(Optional.of(part1NewLeaderId), Optional.of(part1NewLeaderEpoch)));
        MetadataResponse.PartitionMetadata updatedPart1Metadata = new MetadataResponse.PartitionMetadata(part1Metadata.error, part1Metadata.topicPartition, Optional.of(part1NewLeaderId), Optional.of(part1NewLeaderEpoch), part1Metadata.replicaIds, part1Metadata.inSyncReplicaIds, part1Metadata.offlineReplicaIds);
        Node newNode = new Node(999, "testhost", 99999, "testrack");
        nodes.add(newNode);
        int index = nodes.stream().filter(node -> node.id() == 0).findFirst().map(nodes::indexOf).orElse(-1);
        Node existingNode = (Node)nodes.get(index);
        Node updatedNode = new Node(existingNode.id(), "newhost", existingNode.port(), "newrack");
        nodes.remove(index);
        nodes.add(updatedNode);
        updatedTps = this.metadata.updatePartitionLeadership(updates, nodes);
        Assertions.assertEquals((int)1, (int)updatedTps.size());
        Assertions.assertEquals((Object)part1Metadata.topicPartition, (Object)updatedTps.toArray()[0]);
        this.validateForUpdatePartitionLeadership(this.metadata, updatedPart1Metadata, part2Metadata, part12Metadata, internalTopicMetadata, nodes, clusterId, unauthorizedTopics, invalidTopics, internalTopics, controller, topicIds);
        ((ClusterResourceListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.times((int)1))).onUpdate((ClusterResource)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClusterResourceListener[]{mockListener});
    }

    @Test
    public void testConcurrentUpdateAndFetchForSnapshotAndCluster() throws InterruptedException {
        MockTime time = new MockTime();
        this.metadata = new Metadata(100L, 1000L, 1000L, new LogContext(), new ClusterResourceListeners());
        int oldNodeCount = 10;
        String topic1 = "test_topic1";
        String topic2 = "test_topic2";
        TopicPartition topic1Part0 = new TopicPartition(topic1, 0);
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        int oldPartitionCount = 1;
        topicPartitionCounts.put(topic1, oldPartitionCount);
        topicPartitionCounts.put(topic2, oldPartitionCount);
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic1, Uuid.randomUuid());
        topicIds.put(topic2, Uuid.randomUuid());
        int oldLeaderEpoch = 100;
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWithIds("cluster", oldNodeCount, Collections.emptyMap(), topicPartitionCounts, _tp -> oldLeaderEpoch, topicIds);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        MetadataSnapshot snapshot = this.metadata.fetchMetadataSnapshot();
        Cluster cluster = this.metadata.fetch();
        Assertions.assertEquals((Object)cluster, (Object)snapshot.cluster());
        Assertions.assertEquals((int)oldNodeCount, (int)snapshot.cluster().nodes().size());
        Assertions.assertEquals((int)oldPartitionCount, (Integer)snapshot.cluster().partitionCountForTopic(topic1));
        Assertions.assertEquals((int)oldPartitionCount, (Integer)snapshot.cluster().partitionCountForTopic(topic2));
        Assertions.assertEquals((Object)OptionalInt.of(oldLeaderEpoch), (Object)snapshot.leaderEpochFor(topic1Part0));
        int numThreads = 6;
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        CountDownLatch allThreadsDoneLatch = new CountDownLatch(numThreads);
        CountDownLatch atleastMetadataUpdatedOnceLatch = new CountDownLatch(1);
        AtomicReference newSnapshot = new AtomicReference();
        AtomicReference newCluster = new AtomicReference();
        for (int i = 0; i < numThreads; ++i) {
            int id = i + 1;
            service.execute(() -> {
                if (id % 2 == 0) {
                    String oldClusterId = "clusterId";
                    int nNodes = oldNodeCount + id;
                    HashMap<String, Integer> newTopicPartitionCounts = new HashMap<String, Integer>();
                    newTopicPartitionCounts.put(topic1, oldPartitionCount + id);
                    newTopicPartitionCounts.put(topic2, oldPartitionCount + id);
                    MetadataResponse newMetadataResponse = RequestTestUtils.metadataUpdateWithIds(oldClusterId, nNodes, Collections.emptyMap(), newTopicPartitionCounts, _tp -> oldLeaderEpoch + id, topicIds);
                    this.metadata.updateWithCurrentRequestVersion(newMetadataResponse, true, time.milliseconds());
                    atleastMetadataUpdatedOnceLatch.countDown();
                } else {
                    Assertions.assertTrue((boolean)((Boolean)Assertions.assertDoesNotThrow(() -> atleastMetadataUpdatedOnceLatch.await(5L, TimeUnit.MINUTES))));
                    newSnapshot.set(this.metadata.fetchMetadataSnapshot());
                    newCluster.set(this.metadata.fetch());
                }
                allThreadsDoneLatch.countDown();
            });
        }
        Assertions.assertTrue((boolean)allThreadsDoneLatch.await(5L, TimeUnit.MINUTES));
        int newNodeCount = ((MetadataSnapshot)newSnapshot.get()).cluster().nodes().size();
        Assertions.assertTrue((oldNodeCount < newNodeCount ? 1 : 0) != 0, (String)("Unexpected value " + newNodeCount));
        int newPartitionCountTopic1 = ((MetadataSnapshot)newSnapshot.get()).cluster().partitionCountForTopic(topic1);
        Assertions.assertTrue((oldPartitionCount < newPartitionCountTopic1 ? 1 : 0) != 0, (String)("Unexpected value " + newPartitionCountTopic1));
        int newPartitionCountTopic2 = ((MetadataSnapshot)newSnapshot.get()).cluster().partitionCountForTopic(topic2);
        Assertions.assertTrue((oldPartitionCount < newPartitionCountTopic2 ? 1 : 0) != 0, (String)("Unexpected value " + newPartitionCountTopic2));
        int newLeaderEpoch = ((MetadataSnapshot)newSnapshot.get()).leaderEpochFor(topic1Part0).getAsInt();
        Assertions.assertTrue((oldLeaderEpoch < newLeaderEpoch ? 1 : 0) != 0, (String)("Unexpected value " + newLeaderEpoch));
        newNodeCount = ((Cluster)newCluster.get()).nodes().size();
        Assertions.assertTrue((oldNodeCount < newNodeCount ? 1 : 0) != 0, (String)("Unexpected value " + newNodeCount));
        newPartitionCountTopic1 = ((Cluster)newCluster.get()).partitionCountForTopic(topic1);
        Assertions.assertTrue((oldPartitionCount < newPartitionCountTopic1 ? 1 : 0) != 0, (String)("Unexpected value " + newPartitionCountTopic1));
        newPartitionCountTopic2 = ((Cluster)newCluster.get()).partitionCountForTopic(topic2);
        Assertions.assertTrue((oldPartitionCount < newPartitionCountTopic2 ? 1 : 0) != 0, (String)("Unexpected value " + newPartitionCountTopic2));
        service.shutdown();
        Assertions.assertTrue((boolean)service.awaitTermination(60L, TimeUnit.SECONDS));
    }

    void validateForUpdatePartitionLeadership(Metadata updatedMetadata, MetadataResponse.PartitionMetadata part1Metadata, MetadataResponse.PartitionMetadata part2Metadata, MetadataResponse.PartitionMetadata part12Metadata, MetadataResponse.PartitionMetadata internalPartMetadata, List<Node> expectedNodes, String expectedClusterId, Set<String> expectedUnauthorisedTopics, Set<String> expectedInvalidTopics, Set<String> expectedInternalTopics, Node expectedController, Map<String, Uuid> expectedTopicIds) {
        Cluster updatedCluster = updatedMetadata.fetch();
        Assertions.assertEquals((Object)updatedCluster.clusterResource().clusterId(), (Object)expectedClusterId);
        Assertions.assertEquals(new HashSet<Node>(expectedNodes), new HashSet(updatedCluster.nodes()));
        Assertions.assertEquals((int)3, (int)updatedCluster.topics().size());
        Assertions.assertEquals(expectedInternalTopics, (Object)updatedCluster.internalTopics());
        Assertions.assertEquals(expectedInvalidTopics, (Object)updatedCluster.invalidTopics());
        Assertions.assertEquals(expectedUnauthorisedTopics, (Object)updatedCluster.unauthorizedTopics());
        Assertions.assertEquals((Object)expectedController, (Object)updatedCluster.controller());
        Assertions.assertEquals(expectedTopicIds, (Object)updatedMetadata.topicIds());
        Map<Integer, Node> nodeMap = expectedNodes.stream().collect(Collectors.toMap(Node::id, e -> e));
        for (MetadataResponse.PartitionMetadata partitionMetadata : Arrays.asList(part1Metadata, part2Metadata, part12Metadata, internalPartMetadata)) {
            TopicPartition tp = new TopicPartition(partitionMetadata.topic(), partitionMetadata.partition());
            Metadata.LeaderAndEpoch expectedLeaderInfo = new Metadata.LeaderAndEpoch(Optional.of(nodeMap.get(partitionMetadata.leaderId.get())), partitionMetadata.leaderEpoch);
            Assertions.assertEquals((Object)expectedLeaderInfo, (Object)updatedMetadata.currentLeader(tp));
            Optional optionalUpdatedMetadata = updatedMetadata.partitionMetadataIfCurrent(tp);
            Assertions.assertTrue((boolean)optionalUpdatedMetadata.isPresent());
            MetadataResponse.PartitionMetadata updatedPartMetadata = (MetadataResponse.PartitionMetadata)optionalUpdatedMetadata.get();
            Assertions.assertEquals((Object)partitionMetadata.topicPartition, (Object)updatedPartMetadata.topicPartition);
            Assertions.assertEquals((Object)partitionMetadata.error, (Object)updatedPartMetadata.error);
            Assertions.assertEquals((Object)partitionMetadata.leaderId, (Object)updatedPartMetadata.leaderId);
            Assertions.assertEquals((Object)partitionMetadata.leaderEpoch, (Object)updatedPartMetadata.leaderEpoch);
            Assertions.assertEquals((Object)partitionMetadata.replicaIds, (Object)updatedPartMetadata.replicaIds);
            Assertions.assertEquals((Object)partitionMetadata.inSyncReplicaIds, (Object)updatedPartMetadata.inSyncReplicaIds);
            Assertions.assertEquals((Object)partitionMetadata.offlineReplicaIds, (Object)partitionMetadata.offlineReplicaIds);
        }
    }
}

