/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.ShareConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.clients.consumer.internals.metrics.ShareRebalanceMetricsManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareMembershipManagerTest {
    private static final String GROUP_ID = "test-group";
    private static final String MEMBER_ID = "test-member-1";
    private static final String RACK_ID = null;
    private static final int MEMBER_EPOCH = 1;
    private final LogContext logContext = new LogContext();
    private SubscriptionState subscriptionState;
    private ConsumerMetadata metadata;
    private ShareConsumerTestBuilder testBuilder;
    private Time time;
    private ShareRebalanceMetricsManager shareRebalanceMetricsManager;
    private Metrics metrics;

    @BeforeEach
    public void setup() {
        this.testBuilder = new ShareConsumerTestBuilder(ShareConsumerTestBuilder.createDefaultGroupInformation());
        this.metadata = this.testBuilder.metadata;
        this.subscriptionState = this.testBuilder.subscriptions;
        this.time = this.testBuilder.time;
        this.metrics = new Metrics(this.time);
        this.shareRebalanceMetricsManager = new ShareRebalanceMetricsManager(this.metrics);
    }

    @AfterEach
    public void tearDown() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
        }
    }

    private ShareMembershipManager createMembershipManagerJoiningGroup() {
        ShareMembershipManager manager = (ShareMembershipManager)Mockito.spy((Object)new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, Optional.empty(), this.time, this.shareRebalanceMetricsManager));
        manager.transitionToJoining();
        return manager;
    }

    @Test
    public void testMembershipManagerRegistersForClusterMetadataUpdatesOnFirstJoin() {
        ShareMembershipManager manager = new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, Optional.empty(), this.time, this.shareRebalanceMetricsManager);
        manager.transitionToJoining();
        Mockito.clearInvocations((Object[])new ConsumerMetadata[]{this.metadata});
        this.receiveEmptyAssignment(manager);
        this.mockLeaveGroup();
        manager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)manager.state());
        manager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)manager.state());
        manager.transitionToJoining();
    }

    @Test
    public void testReconcilingWhenReceivingAssignmentFoundInMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testTransitionToAcknowledgingOnlyIfAssignmentReceived() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        ShareGroupHeartbeatResponse responseWithoutAssignment = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(responseWithoutAssignment.data());
        Assertions.assertNotEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ShareGroupHeartbeatResponse responseWithAssignment = this.createShareGroupHeartbeatResponse(this.createAssignment(true));
        membershipManager.onHeartbeatSuccess(responseWithAssignment.data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    @Test
    public void testMemberIdAndEpochResetOnFencedMembers() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testTransitionToFatal() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testTransitionToFailedWhenTryingToJoin() {
        ShareMembershipManager membershipManager = new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, Optional.empty(), this.time, this.shareRebalanceMetricsManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToJoining();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToFatal() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.subscriptionState.subscribe(Collections.singleton("topic1"), Optional.empty());
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), Optional.empty());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToLeavingGroup() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), Optional.empty());
    }

    @Test
    public void testListenersGetNotifiedOfMemberEpochUpdatesOnlyIfItChanges() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        int epoch = 5;
        membershipManager.onHeartbeatSuccess(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(epoch));
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(epoch), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.onHeartbeatSuccess(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(epoch));
        ((MemberStateListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onMemberEpochUpdated((Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
    }

    private void mockStableMember(ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testFencingWhenStateIsReconciling() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFencingWhenStateIsLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockPrepareLeaving(membershipManager);
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
    }

    @Test
    public void testLeaveGroupEpoch() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testDelayedMetadataUsedToCompleteAssignment() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        TopicIdPartition topicId1Partition0 = new TopicIdPartition(topicId1, new TopicPartition(topic1, 0));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        TopicIdPartition topicId2Partition0 = new TopicIdPartition(topicId2, new TopicPartition(topic2, 0));
        ShareMembershipManager membershipManager = this.mockMemberSuccessfullyReceivesAndAcknowledgesAssignment(topicId1, topic1, Collections.singletonList(0));
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(Collections.singleton(topicId1Partition0)));
        Mockito.clearInvocations((Object[])new Object[]{membershipManager, this.subscriptionState});
        Map newAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0})), Utils.mkEntry((Object)topicId2, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0}))});
        this.receiveAssignment(newAssignment, membershipManager);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.clearInvocations((Object[])new ShareMembershipManager[]{membershipManager});
        Map fullTopicMetadata = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)topic1), Utils.mkEntry((Object)topicId2, (Object)topic2)});
        Mockito.when((Object)this.metadata.topicNames()).thenReturn((Object)fullTopicMetadata);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Arrays.asList(topicId1Partition0, topicId2Partition0));
    }

    @Test
    public void testLeaveGroupWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenStateIsReconciling() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
    }

    @Test
    public void testIgnoreHeartbeatWhenLeavingGroup() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(this.createAssignment(true)).data());
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isEmpty());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
    }

    @Test
    public void testLeaveGroupWhenMemberOwnsAssignment() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = Arrays.asList(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), new TopicIdPartition(topicId, new TopicPartition(topicName, 1)));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        Assertions.assertEquals((int)1, (int)membershipManager.currentAssignment().size());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        Assertions.assertFalse((boolean)leaveResult2.isDone());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertFalse((boolean)leaveResult1.isCompletedExceptionally());
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeft() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertFalse((boolean)leaveResult1.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFatalFailureWhenStateIsNotJoined() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenMemberAlreadyLeft() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testUpdateStateFailsOnResponsesWithErrors() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse unknownMemberResponse = this.createShareGroupHeartbeatResponseWithError();
        Assertions.assertThrows(IllegalArgumentException.class, () -> membershipManager.onHeartbeatSuccess(unknownMemberResponse.data()));
    }

    @Test
    public void testNewAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 0));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(expectedAssignment);
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testNewEmptyAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveEmptyAssignment(membershipManager);
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testNewAssignmentNotInMetadataReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((Object)topicId, membershipManager.topicsAwaitingReconciliation().iterator().next());
    }

    @Test
    public void testUnresolvedTargetAssignmentIsReconciledWhenMetadataReceived() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("rebalance-total").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("rebalance-rate-per-hour").metricValue());
        membershipManager.poll(this.time.milliseconds());
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 1));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(expectedAssignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric("rebalance-total").metricValue());
        Assertions.assertEquals((double)120.0, (double)((Double)this.getMetric("rebalance-rate-per-hour").metricValue()), (double)0.2);
    }

    @Test
    public void testMemberKeepsUnresolvedAssignmentWaitingForMetadataUntilResolved() {
        Uuid topic1 = Uuid.randomUuid();
        String topic1Name = "topic1";
        Uuid topic2 = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment assignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(1, 3))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, topic1Name));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, assignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment).data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenNoPartitionOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenOtherPartitionsOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.receiveAssignment(topicId, Arrays.asList(0, 1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        ArrayList<TopicIdPartition> assignedPartitions = new ArrayList<TopicIdPartition>();
        assignedPartitions.add(ownedPartition);
        assignedPartitions.addAll(this.topicIdPartitions(topicId, topicName, 1, 2));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconciliationSkippedWhenSameAssignmentReceived() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager});
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, expectedAssignmentReconciled);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testReconcileNewPartitionsAssignedAndRevoked() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.mockRevocation();
        this.receiveAssignment(topicId, Arrays.asList(1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 1, 2), (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testMetadataUpdatesReconcilesUnresolvedAssignments() {
        Uuid topicId = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false, targetAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        String topicName = "topic1";
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), true);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testMetadataUpdatesRequestsAnotherUpdateIfNeeded() {
        Uuid topicId = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false, targetAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)2))).requestUpdate(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRevokePartitionsUsesTopicNamesLocalCacheWhenMetadataNotAvailable() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        List<Integer> partitions = Arrays.asList(0, 1);
        Set assignedPartitions = partitions.stream().map(p -> new TopicPartition(topicName, p.intValue())).collect(Collectors.toSet());
        Map<Uuid, TreeSet<Integer>> assignedTopicIdPartitions = Collections.singletonMap(topicId, new TreeSet<Integer>(partitions));
        Assertions.assertEquals(assignedTopicIdPartitions, (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        this.mockAckSent(membershipManager);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(assignedPartitions);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.mockRevocation();
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), false);
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        membershipManager.poll(this.time.milliseconds());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).requestUpdate(ArgumentMatchers.anyBoolean());
        List<TopicIdPartition> remainingAssignment = this.topicIdPartitions(topicId, topicName, 1);
        this.testRevocationCompleted(membershipManager, remainingAssignment);
    }

    @Test
    public void testOnSubscriptionUpdatedTransitionsToJoiningOnlyIfNotInGroup() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).transitionToJoining();
        Mockito.clearInvocations((Object[])new ShareMembershipManager[]{membershipManager});
        membershipManager.onSubscriptionUpdated();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
    }

    private SortedSet<TopicIdPartition> topicIdPartitionsSet(Uuid topicId, String topicName, int ... partitions) {
        TreeSet<TopicIdPartition> topicIdPartitions = new TreeSet<TopicIdPartition>((Comparator<TopicIdPartition>)new Utils.TopicIdPartitionComparator());
        for (int partition : partitions) {
            topicIdPartitions.add(new TopicIdPartition(topicId, new TopicPartition(topicName, partition)));
        }
        return topicIdPartitions;
    }

    private List<TopicIdPartition> topicIdPartitions(Uuid topicId, String topicName, int ... partitions) {
        return new ArrayList<TopicIdPartition>(this.topicIdPartitionsSet(topicId, topicName, partitions));
    }

    private Map<Uuid, SortedSet<Integer>> topicIdPartitionsMap(Uuid topicId, int ... partitions) {
        TreeSet<Integer> topicIdPartitions = new TreeSet<Integer>();
        for (int partition : partitions) {
            topicIdPartitions.add(partition);
        }
        return Collections.singletonMap(topicId, topicIdPartitions);
    }

    private void testFenceIsNoOp(ShareMembershipManager membershipManager) {
        Assertions.assertNotEquals((int)0, (int)membershipManager.memberEpoch());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
    }

    private void assertStaleMemberLeavesGroupAndClearsAssignment(ShareMembershipManager membershipManager) {
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isEmpty());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testMemberJoiningTransitionsToStableWhenReceivingEmptyAssignment() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.receiveEmptyAssignment(membershipManager);
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    private ShareMembershipManager mockMemberSuccessfullyReceivesAndAcknowledgesAssignment(Uuid topicId, String topicName, List<Integer> partitions) {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, partitions, membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = partitions.stream().map(tp -> new TopicIdPartition(topicId, new TopicPartition(topicName, tp.intValue()))).collect(Collectors.toList());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        return membershipManager;
    }

    private void verifyReconciliationNotTriggered(ShareMembershipManager membershipManager) {
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
    }

    private void verifyReconciliationTriggeredAndCompleted(ShareMembershipManager membershipManager, List<TopicIdPartition> expectedAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationCompleted();
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitions = this.buildTopicPartitions(expectedAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(new HashSet<TopicPartition>(expectedTopicPartitions));
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment());
    }

    private List<TopicPartition> buildTopicPartitions(List<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toList());
    }

    private void mockAckSent(ShareMembershipManager membershipManager) {
        membershipManager.onHeartbeatRequestSent();
    }

    private void mockTopicNameInMetadataCache(Map<Uuid, String> topicNames, boolean isPresent) {
        if (isPresent) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        } else {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        }
    }

    private CompletableFuture<Void> mockRevocation() {
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        return CompletableFuture.completedFuture(null);
    }

    private void mockMemberHasAutoAssignedPartition() {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private void testRevocationCompleted(ShareMembershipManager membershipManager, List<TopicIdPartition> expectedCurrentAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedCurrentAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        List<TopicPartition> expectedTopicPartitionAssignment = this.buildTopicPartitions(expectedCurrentAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(new HashSet<TopicPartition>(expectedTopicPartitionAssignment));
    }

    private Map<Uuid, SortedSet<Integer>> assignmentByTopicId(List<TopicIdPartition> topicIdPartitions) {
        HashMap<Uuid, SortedSet<Integer>> assignmentByTopicId = new HashMap<Uuid, SortedSet<Integer>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            Uuid topicId = topicIdPartition.topicId();
            assignmentByTopicId.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
        });
        return assignmentByTopicId;
    }

    private void mockOwnedPartitionAndAssignmentReceived(ShareMembershipManager membershipManager, Uuid topicId, String topicName, Collection<TopicIdPartition> previouslyOwned) {
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(previouslyOwned));
        membershipManager.updateAssignment(new HashSet<TopicIdPartition>(previouslyOwned));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private Set<TopicPartition> getTopicPartitions(Collection<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(topicIdPartition -> new TopicPartition(topicIdPartition.topic(), topicIdPartition.partition())).collect(Collectors.toSet());
    }

    private ShareMembershipManager mockJoinAndReceiveAssignment(boolean expectSubscriptionUpdated) {
        return this.mockJoinAndReceiveAssignment(expectSubscriptionUpdated, this.createAssignment(expectSubscriptionUpdated));
    }

    private ShareMembershipManager mockJoinAndReceiveAssignment(boolean expectSubscriptionUpdated, ShareGroupHeartbeatResponseData.Assignment assignment) {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(assignment);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        membershipManager.poll(this.time.milliseconds());
        if (expectSubscriptionUpdated) {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(ArgumentMatchers.anyCollection());
        } else {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        }
        return membershipManager;
    }

    private ShareMembershipManager createMemberInStableState() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        return membershipManager;
    }

    private void receiveAssignment(Map<Uuid, SortedSet<Integer>> topicIdPartitionList, ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(topicIdPartitionList.entrySet().stream().map(tp -> new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)tp.getKey()).setPartitions(new ArrayList((Collection)tp.getValue()))).collect(Collectors.toList()));
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment);
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
    }

    private void receiveAssignment(Uuid topicId, List<Integer> partitions, ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment);
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
    }

    private void receiveEmptyAssignment(ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.emptyList());
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment);
        membershipManager.onHeartbeatSuccess(heartbeatResponse.data());
    }

    private void testFencedMemberReleasesAssignmentAndTransitionsToJoining(ShareMembershipManager membershipManager) {
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private void testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(ShareMembershipManager membershipManager) {
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveResult.isDone());
        Assertions.assertFalse((boolean)leaveResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isEmpty());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testStaleMemberDoesNotSendHeartbeatAndAllowsTransitionToJoiningToRecover() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat(), (String)"Stale member should not send heartbeats");
        Assertions.assertDoesNotThrow(() -> ((ShareMembershipManager)membershipManager).maybeRejoinStaleMember());
    }

    @Test
    public void testStaleMemberRejoinsWhenTimerResetsNoCallbacks() {
        ShareMembershipManager membershipManager = this.mockStaleMember();
        this.assertStaleMemberLeavesGroupAndClearsAssignment(membershipManager);
        membershipManager.maybeRejoinStaleMember();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private ShareMembershipManager mockStaleMember() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestSent();
        return membershipManager;
    }

    private void mockLeaveGroup() {
        this.mockMemberHasAutoAssignedPartition();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
    }

    private void mockPrepareLeaving(ShareMembershipManager membershipManager) {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        membershipManager.leaveGroup();
    }

    private void testStateUpdateOnFatalFailure(ShareMembershipManager membershipManager) {
        String memberId = membershipManager.memberId();
        int lastEpoch = membershipManager.memberEpoch();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertEquals((Object)memberId, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)lastEpoch, (int)membershipManager.memberEpoch());
    }

    private ShareGroupHeartbeatResponse createShareGroupHeartbeatResponse(ShareGroupHeartbeatResponseData.Assignment assignment) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(1).setAssignment(assignment));
    }

    private ShareGroupHeartbeatResponse createShareGroupHeartbeatResponseWithError() {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setMemberId(MEMBER_ID).setMemberEpoch(5));
    }

    private ShareGroupHeartbeatResponseData.Assignment createAssignment(boolean mockMetadata) {
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        if (mockMetadata) {
            HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
            topicNames.put(topic1, "topic1");
            topicNames.put(topic2, "topic2");
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        }
        return new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(3, 4, 5))));
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, "consumer-share-coordinator-metrics"));
    }
}

