/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GzipCompressionTest {
    @Test
    public void testCompressionDecompression() throws IOException {
        GzipCompression.Builder builder = Compression.gzip();
        byte[] data = String.join((CharSequence)"", Collections.nCopies(256, "data")).getBytes(StandardCharsets.UTF_8);
        for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
            for (int level : Arrays.asList(1, -1, 9)) {
                GzipCompression compression = builder.level(level).build();
                ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(4);
                try (OutputStream out = compression.wrapForOutput(bufferStream, magic);){
                    out.write(data);
                    out.flush();
                }
                bufferStream.buffer().flip();
                InputStream inputStream = compression.wrapForInput(bufferStream.buffer(), magic, BufferSupplier.create());
                var10_10 = null;
                try {
                    byte[] result = new byte[data.length];
                    int read = inputStream.read(result);
                    Assertions.assertEquals((int)data.length, (int)read);
                    Assertions.assertArrayEquals((byte[])data, (byte[])result);
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream == null) continue;
                    if (var10_10 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testCompressionLevels() {
        GzipCompression.Builder builder = Compression.gzip();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.level(0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.level(10));
        builder.level(1);
        builder.level(9);
    }

    @Test
    public void testLevelValidator() {
        GzipCompression.LevelValidator validator = new GzipCompression.LevelValidator();
        for (int level = 1; level <= 9; ++level) {
            validator.ensureValid("", (Object)level);
        }
        validator.ensureValid("", (Object)-1);
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("", (Object)0));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("", (Object)10));
    }
}

