/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryUtils;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ClientTelemetryUtilsTest {
    @Test
    public void testMaybeFetchErrorIntervalMs() {
        Assertions.assertEquals(Optional.empty(), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.NONE.code(), (int)-1));
        Assertions.assertEquals(Optional.of(Integer.MAX_VALUE), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.INVALID_REQUEST.code(), (int)-1));
        Assertions.assertEquals(Optional.of(Integer.MAX_VALUE), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.INVALID_RECORD.code(), (int)-1));
        Assertions.assertEquals(Optional.of(0), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.UNKNOWN_SUBSCRIPTION_ID.code(), (int)-1));
        Assertions.assertEquals(Optional.of(0), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (int)-1));
        Assertions.assertEquals(Optional.of(300000), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.TELEMETRY_TOO_LARGE.code(), (int)-1));
        Assertions.assertEquals(Optional.of(20000), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.TELEMETRY_TOO_LARGE.code(), (int)20000));
        Assertions.assertEquals(Optional.of(300000), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.THROTTLING_QUOTA_EXCEEDED.code(), (int)-1));
        Assertions.assertEquals(Optional.of(20000), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.THROTTLING_QUOTA_EXCEEDED.code(), (int)20000));
        Assertions.assertEquals(Optional.of(Integer.MAX_VALUE), (Object)ClientTelemetryUtils.maybeFetchErrorIntervalMs((short)Errors.UNKNOWN_SERVER_ERROR.code(), (int)-1));
    }

    @Test
    public void testGetSelectorFromRequestedMetrics() {
        Assertions.assertEquals((Object)ClientTelemetryUtils.SELECTOR_NO_METRICS, (Object)ClientTelemetryUtils.getSelectorFromRequestedMetrics(Collections.emptyList()));
        Assertions.assertEquals((Object)ClientTelemetryUtils.SELECTOR_NO_METRICS, (Object)ClientTelemetryUtils.getSelectorFromRequestedMetrics(null));
        Assertions.assertEquals((Object)ClientTelemetryUtils.SELECTOR_ALL_METRICS, (Object)ClientTelemetryUtils.getSelectorFromRequestedMetrics(Collections.singletonList("*")));
        Predicate selector = ClientTelemetryUtils.getSelectorFromRequestedMetrics(Arrays.asList("metric1", "metric2"));
        Assertions.assertNotEquals((Object)ClientTelemetryUtils.SELECTOR_NO_METRICS, (Object)selector);
        Assertions.assertNotEquals((Object)ClientTelemetryUtils.SELECTOR_ALL_METRICS, (Object)selector);
        Assertions.assertTrue((boolean)selector.test(new MetricKey("metric1.test")));
        Assertions.assertTrue((boolean)selector.test(new MetricKey("metric2.test")));
        Assertions.assertFalse((boolean)selector.test(new MetricKey("test.metric1")));
        Assertions.assertFalse((boolean)selector.test(new MetricKey("test.metric2")));
    }

    @Test
    public void testGetCompressionTypesFromAcceptedList() {
        Assertions.assertEquals((int)0, (int)ClientTelemetryUtils.getCompressionTypesFromAcceptedList(null).size());
        Assertions.assertEquals((int)0, (int)ClientTelemetryUtils.getCompressionTypesFromAcceptedList(Collections.emptyList()).size());
        ArrayList<Byte> compressionTypes = new ArrayList<Byte>();
        compressionTypes.add(CompressionType.GZIP.id);
        compressionTypes.add(CompressionType.LZ4.id);
        compressionTypes.add(CompressionType.SNAPPY.id);
        compressionTypes.add(CompressionType.ZSTD.id);
        compressionTypes.add(CompressionType.NONE.id);
        compressionTypes.add((byte)-1);
        Assertions.assertEquals((int)5, (int)ClientTelemetryUtils.getCompressionTypesFromAcceptedList(compressionTypes).size());
    }

    @Test
    public void testValidateClientInstanceId() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientTelemetryUtils.validateClientInstanceId(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientTelemetryUtils.validateClientInstanceId((Uuid)Uuid.ZERO_UUID));
        Uuid uuid = Uuid.randomUuid();
        Assertions.assertEquals((Object)uuid, (Object)ClientTelemetryUtils.validateClientInstanceId((Uuid)uuid));
    }

    @ParameterizedTest
    @ValueSource(ints={300000, 0x7FFFFFFE, 0x7FFFFFFF})
    public void testValidateIntervalMsValid(int pushIntervalMs) {
        Assertions.assertEquals((int)pushIntervalMs, (int)ClientTelemetryUtils.validateIntervalMs((int)pushIntervalMs));
    }

    @ParameterizedTest
    @ValueSource(ints={-1, 0})
    public void testValidateIntervalMsInvalid(int pushIntervalMs) {
        Assertions.assertEquals((int)300000, (int)ClientTelemetryUtils.validateIntervalMs((int)pushIntervalMs));
    }

    @Test
    public void testPreferredCompressionType() {
        Assertions.assertEquals((Object)CompressionType.NONE, (Object)ClientTelemetryUtils.preferredCompressionType(Collections.emptyList()));
        Assertions.assertEquals((Object)CompressionType.NONE, (Object)ClientTelemetryUtils.preferredCompressionType(null));
    }
}

