/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerInvoker;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.CounterConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.Deserializers;
import org.apache.kafka.clients.consumer.internals.Fetch;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchCollector;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventHandler;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackNeededEvent;
import org.apache.kafka.clients.consumer.internals.events.ErrorBackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.EventProcessor;
import org.apache.kafka.clients.consumer.internals.events.FetchCommittedOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.GroupMetadataUpdateEvent;
import org.apache.kafka.clients.consumer.internals.events.LeaveOnCloseApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.PollApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.SubscriptionChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AsyncKafkaConsumerTest {
    private long retryBackoffMs = 100L;
    private int defaultApiTimeoutMs = 1000;
    private boolean autoCommitEnabled = true;
    private AsyncKafkaConsumer<String, String> consumer = null;
    private final Time time = new MockTime(1L);
    private final FetchCollector<String, String> fetchCollector = (FetchCollector)Mockito.mock(FetchCollector.class);
    private final ApplicationEventHandler applicationEventHandler = (ApplicationEventHandler)Mockito.mock(ApplicationEventHandler.class);
    private final ConsumerMetadata metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
    private final LinkedBlockingQueue<BackgroundEvent> backgroundEventQueue = new LinkedBlockingQueue();

    @AfterEach
    public void resetAll() {
        this.backgroundEventQueue.clear();
        if (this.consumer != null) {
            this.consumer.close(Duration.ZERO);
        }
        this.consumer = null;
        Mockito.framework().clearInlineMocks();
    }

    private AsyncKafkaConsumer<String, String> newConsumer() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", "group-id");
        ConsumerConfig config = new ConsumerConfig(props);
        return this.newConsumer(config);
    }

    private AsyncKafkaConsumer<String, String> newConsumerWithoutGroupId() {
        Properties props = this.requiredConsumerProperties();
        ConsumerConfig config = new ConsumerConfig(props);
        return this.newConsumer(config);
    }

    private AsyncKafkaConsumer<String, String> newConsumerWithEmptyGroupId() {
        Properties props = this.requiredConsumerPropertiesAndGroupId("");
        ConsumerConfig config = new ConsumerConfig(props);
        return this.newConsumer(config);
    }

    private AsyncKafkaConsumer<String, String> newConsumer(ConsumerConfig config) {
        return new AsyncKafkaConsumer(config, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), this.time, (a, b, c, d, e, f) -> this.applicationEventHandler, (a, b, c, d, e, f, g) -> this.fetchCollector, (a, b, c, d) -> this.metadata, this.backgroundEventQueue);
    }

    private AsyncKafkaConsumer<String, String> newConsumer(FetchBuffer fetchBuffer, ConsumerInterceptors<String, String> interceptors, ConsumerRebalanceListenerInvoker rebalanceListenerInvoker, SubscriptionState subscriptions, List<ConsumerPartitionAssignor> assignors, String groupId, String clientId) {
        return new AsyncKafkaConsumer(new LogContext(), clientId, new Deserializers((Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer()), fetchBuffer, this.fetchCollector, interceptors, this.time, this.applicationEventHandler, this.backgroundEventQueue, rebalanceListenerInvoker, new Metrics(), subscriptions, this.metadata, this.retryBackoffMs, this.defaultApiTimeoutMs, assignors, groupId, this.autoCommitEnabled);
    }

    @Test
    public void testSuccessfulStartupShutdown() {
        this.consumer = this.newConsumer();
        Assertions.assertDoesNotThrow(() -> this.consumer.close());
    }

    @Test
    public void testInvalidGroupId() {
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, this::newConsumerWithEmptyGroupId);
        Assertions.assertInstanceOf(InvalidGroupIdException.class, (Object)e.getCause());
    }

    @Test
    public void testFailOnClosedConsumer() {
        this.consumer = this.newConsumer();
        this.consumer.close();
        IllegalStateException res = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.assignment());
        Assertions.assertEquals((Object)"This consumer has already been closed.", (Object)res.getMessage());
    }

    @Test
    public void testCommitAsyncWithNullCallback() {
        this.consumer = this.newConsumer();
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(t0, new OffsetAndMetadata(10L));
        offsets.put(t1, new OffsetAndMetadata(20L));
        this.consumer.commitAsync(offsets, null);
        ArgumentCaptor commitEventCaptor = ArgumentCaptor.forClass(CommitApplicationEvent.class);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)commitEventCaptor.capture());
        CommitApplicationEvent commitEvent = (CommitApplicationEvent)commitEventCaptor.getValue();
        Assertions.assertEquals(offsets, (Object)commitEvent.offsets());
        Assertions.assertDoesNotThrow(() -> commitEvent.future().complete(null));
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync((Map)offsets, null));
    }

    @Test
    public void testCommitAsyncUserSuppliedCallbackNoException() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        this.completeCommitApplicationEventExceptionally();
        MockCommitCallback callback = new MockCommitCallback();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(offsets, (OffsetCommitCallback)callback));
        this.forceCommitCallbackInvocation();
        Assertions.assertNull((Object)callback.exception);
    }

    @ParameterizedTest
    @MethodSource(value={"commitExceptionSupplier"})
    public void testCommitAsyncUserSuppliedCallbackWithException(Exception exception) {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        this.completeCommitApplicationEventExceptionally(exception);
        MockCommitCallback callback = new MockCommitCallback();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(offsets, (OffsetCommitCallback)callback));
        this.forceCommitCallbackInvocation();
        Assertions.assertSame(exception.getClass(), callback.exception.getClass());
    }

    private static Stream<Exception> commitExceptionSupplier() {
        return Stream.of(new Exception[]{new KafkaException("Test exception"), new GroupAuthorizationException("Group authorization exception")});
    }

    @Test
    public void testCommitAsyncWithFencedException() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = this.mockTopicPartitionOffset();
        MockCommitCallback callback = new MockCommitCallback();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync((Map)offsets, (OffsetCommitCallback)callback));
        ArgumentCaptor commitEventCaptor = ArgumentCaptor.forClass(CommitApplicationEvent.class);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)commitEventCaptor.capture());
        CommitApplicationEvent commitEvent = (CommitApplicationEvent)commitEventCaptor.getValue();
        commitEvent.future().completeExceptionally((Throwable)Errors.FENCED_INSTANCE_ID.exception());
        Assertions.assertThrows(Errors.FENCED_INSTANCE_ID.exception().getClass(), () -> this.consumer.commitAsync());
    }

    @Test
    public void testCommitted() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = this.mockTopicPartitionOffset();
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(topicPartitionOffsets);
        Assertions.assertEquals(topicPartitionOffsets, (Object)this.consumer.committed(topicPartitionOffsets.keySet(), Duration.ofMillis(1000L)));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any());
    }

    @Test
    public void testCommittedLeaderEpochUpdate() {
        this.consumer = this.newConsumer();
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        TopicPartition t2 = new TopicPartition("t0", 4);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L, Optional.of(2), ""));
        topicPartitionOffsets.put(t1, null);
        topicPartitionOffsets.put(t2, new OffsetAndMetadata(20L, Optional.of(3), ""));
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(topicPartitionOffsets);
        Assertions.assertDoesNotThrow(() -> this.consumer.committed(topicPartitionOffsets.keySet(), Duration.ofMillis(1000L)));
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t0, 2);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t2, 3);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any());
    }

    @Test
    public void testCommittedExceptionThrown() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = this.mockTopicPartitionOffset();
        Mockito.when((Object)this.applicationEventHandler.addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any())).thenAnswer(invocation -> {
            CompletableApplicationEvent event = (CompletableApplicationEvent)invocation.getArgument(0);
            Assertions.assertInstanceOf(FetchCommittedOffsetsApplicationEvent.class, (Object)event);
            throw new KafkaException("Test exception");
        });
        Assertions.assertThrows(KafkaException.class, () -> this.consumer.committed(offsets.keySet(), Duration.ofMillis(1000L)));
    }

    @Test
    public void testWakeupBeforeCallingPoll() {
        this.consumer = this.newConsumer();
        String topicName = "foo";
        int partition = 3;
        TopicPartition tp = new TopicPartition("foo", 3);
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        Map offsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)tp, (Object)new OffsetAndMetadata(1L))});
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(offsets);
        ((ConsumerMetadata)Mockito.doReturn((Object)Metadata.LeaderAndEpoch.noLeaderOrEpoch()).when((Object)this.metadata)).currentLeader((TopicPartition)ArgumentMatchers.any());
        this.consumer.assign(Collections.singleton(tp));
        this.consumer.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testWakeupAfterEmptyFetch() {
        this.consumer = this.newConsumer();
        String topicName = "foo";
        int partition = 3;
        TopicPartition tp = new TopicPartition("foo", 3);
        ((FetchCollector)Mockito.doAnswer(invocation -> {
            this.consumer.wakeup();
            return Fetch.empty();
        }).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        Map offsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)tp, (Object)new OffsetAndMetadata(1L))});
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(offsets);
        ((ConsumerMetadata)Mockito.doReturn((Object)Metadata.LeaderAndEpoch.noLeaderOrEpoch()).when((Object)this.metadata)).currentLeader((TopicPartition)ArgumentMatchers.any());
        this.consumer.assign(Collections.singleton(tp));
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ofMinutes(1L)));
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testWakeupAfterNonEmptyFetch() {
        this.consumer = this.newConsumer();
        String topicName = "foo";
        int partition = 3;
        TopicPartition tp = new TopicPartition("foo", 3);
        List<ConsumerRecord> records = Arrays.asList(new ConsumerRecord("foo", 3, 2L, (Object)"key1", (Object)"value1"), new ConsumerRecord("foo", 3, 3L, (Object)"key2", (Object)"value2"));
        ((FetchCollector)Mockito.doAnswer(invocation -> {
            this.consumer.wakeup();
            return Fetch.forPartition((TopicPartition)tp, (List)records, (boolean)true);
        }).when(this.fetchCollector)).collectFetch((FetchBuffer)Mockito.any(FetchBuffer.class));
        Map offsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)tp, (Object)new OffsetAndMetadata(1L))});
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(offsets);
        ((ConsumerMetadata)Mockito.doReturn((Object)Metadata.LeaderAndEpoch.noLeaderOrEpoch()).when((Object)this.metadata)).currentLeader((TopicPartition)ArgumentMatchers.any());
        this.consumer.assign(Collections.singleton(tp));
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ofMinutes(1L)));
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testClearWakeupTriggerAfterPoll() {
        this.consumer = this.newConsumer();
        String topicName = "foo";
        int partition = 3;
        TopicPartition tp = new TopicPartition("foo", 3);
        List<ConsumerRecord> records = Arrays.asList(new ConsumerRecord("foo", 3, 2L, (Object)"key1", (Object)"value1"), new ConsumerRecord("foo", 3, 3L, (Object)"key2", (Object)"value2"));
        ((FetchCollector)Mockito.doReturn((Object)Fetch.forPartition((TopicPartition)tp, records, (boolean)true)).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        Map offsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)tp, (Object)new OffsetAndMetadata(1L))});
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(offsets);
        ((ConsumerMetadata)Mockito.doReturn((Object)Metadata.LeaderAndEpoch.noLeaderOrEpoch()).when((Object)this.metadata)).currentLeader((TopicPartition)ArgumentMatchers.any());
        this.consumer.assign(Collections.singleton(tp));
        this.consumer.poll(Duration.ZERO);
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testEnsureCallbackExecutedByApplicationThread() {
        this.consumer = this.newConsumer();
        String currentThread = Thread.currentThread().getName();
        MockCommitCallback callback = new MockCommitCallback();
        this.completeCommitApplicationEventExceptionally();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(new HashMap(), (OffsetCommitCallback)callback));
        Assertions.assertEquals((int)1, (int)this.consumer.callbacks());
        this.forceCommitCallbackInvocation();
        Assertions.assertEquals((Object)currentThread, (Object)callback.completionThread);
    }

    @Test
    public void testEnsureCommitSyncExecutedCommitAsyncCallbacks() {
        this.consumer = this.newConsumer();
        KafkaException callbackException = new KafkaException("Async commit callback failed");
        OffsetCommitCallback callback = (offsets, exception) -> {
            throw callbackException;
        };
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(new HashMap(), callback));
        Assertions.assertThrows(((Object)((Object)callbackException)).getClass(), () -> this.consumer.commitSync());
    }

    @Test
    public void testPollLongThrowsException() {
        this.consumer = this.newConsumer();
        Exception e = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.consumer.poll(0L));
        Assertions.assertEquals((Object)"Consumer.poll(long) is not supported when \"group.protocol\" is \"consumer\". This method is deprecated and will be removed in the next major release.", (Object)e.getMessage());
    }

    @Test
    public void testCommitSyncLeaderEpochUpdate() {
        this.consumer = this.newConsumer();
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L, Optional.of(2), ""));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L, Optional.of(1), ""));
        this.completeCommitApplicationEventExceptionally();
        this.consumer.assign(Arrays.asList(t0, t1));
        Assertions.assertDoesNotThrow(() -> this.consumer.commitSync((Map)topicPartitionOffsets));
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t0, 2);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t1, 1);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(CommitApplicationEvent.class));
    }

    @Test
    public void testCommitAsyncLeaderEpochUpdate() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)new ConsumerInterceptors(Collections.emptyList()), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L, Optional.of(2), ""));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L, Optional.of(1), ""));
        Mockito.when((Object)this.metadata.currentLeader(t0)).thenReturn((Object)new Metadata.LeaderAndEpoch(Optional.of(new Node(1, "host", 9000)), Optional.of(1)));
        Mockito.when((Object)this.metadata.currentLeader(t1)).thenReturn((Object)new Metadata.LeaderAndEpoch(Optional.of(new Node(1, "host", 9000)), Optional.of(1)));
        this.consumer.assign(Arrays.asList(t0, t1));
        this.consumer.seek(t0, 10L);
        this.consumer.seek(t1, 20L);
        MockCommitCallback callback = new MockCommitCallback();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync((Map)topicPartitionOffsets, (OffsetCommitCallback)callback));
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t0, 2);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(t1, 1);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(CommitApplicationEvent.class));
    }

    @Test
    public void testEnsurePollExecutedCommitAsyncCallbacks() {
        this.consumer = this.newConsumer();
        MockCommitCallback callback = new MockCommitCallback();
        this.completeCommitApplicationEventExceptionally();
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(Utils.mkMap((Map.Entry[])new Map.Entry[0]));
        this.consumer.assign(Collections.singleton(new TopicPartition("foo", 0)));
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(new HashMap(), (OffsetCommitCallback)callback));
        this.assertMockCommitCallbackInvoked(() -> this.consumer.poll(Duration.ZERO), callback, null);
    }

    @Test
    public void testEnsureShutdownExecutedCommitAsyncCallbacks() {
        this.consumer = this.newConsumer();
        MockCommitCallback callback = new MockCommitCallback();
        this.completeCommitApplicationEventExceptionally();
        Assertions.assertDoesNotThrow(() -> this.consumer.commitAsync(new HashMap(), (OffsetCommitCallback)callback));
        this.assertMockCommitCallbackInvoked(() -> this.consumer.close(), callback, null);
    }

    @Test
    public void testVerifyApplicationEventOnShutdown() {
        this.consumer = this.newConsumer();
        ((ApplicationEventHandler)Mockito.doReturn(null).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        this.consumer.close();
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(LeaveOnCloseApplicationEvent.class), (Timer)ArgumentMatchers.any());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(CommitOnCloseApplicationEvent.class));
    }

    @Test
    public void testPartitionRevocationOnClose() {
        MockRebalanceListener listener = new MockRebalanceListener();
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)((ConsumerInterceptors)Mockito.mock(ConsumerInterceptors.class)), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        this.consumer.subscribe(Collections.singleton("topic"), (ConsumerRebalanceListener)listener);
        subscriptions.assignFromSubscribed(Collections.singleton(new TopicPartition("topic", 0)));
        this.consumer.close(Duration.ZERO);
        Assertions.assertTrue((boolean)subscriptions.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)1, (int)listener.revokedCount);
    }

    @Test
    public void testFailedPartitionRevocationOnClose() {
        ConsumerRebalanceListener listener = (ConsumerRebalanceListener)Mockito.mock(ConsumerRebalanceListener.class);
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)new ConsumerInterceptors(Collections.emptyList()), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        subscriptions.subscribe(Collections.singleton("topic"), Optional.of(listener));
        TopicPartition tp = new TopicPartition("topic", 0);
        subscriptions.assignFromSubscribed(Collections.singleton(tp));
        ((ConsumerRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{new KafkaException()}).when((Object)listener)).onPartitionsRevoked((Collection)ArgumentMatchers.eq(Collections.singleton(tp)));
        Assertions.assertThrows(KafkaException.class, () -> this.consumer.close(Duration.ZERO));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.never())).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(LeaveOnCloseApplicationEvent.class), (Timer)ArgumentMatchers.any());
        ((ConsumerRebalanceListener)Mockito.verify((Object)listener)).onPartitionsRevoked((Collection)ArgumentMatchers.eq(Collections.singleton(tp)));
        Assertions.assertEquals(Collections.emptySet(), (Object)subscriptions.assignedPartitions());
    }

    @Test
    public void testCompleteQuietly() {
        AtomicReference exception = new AtomicReference();
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        this.consumer = this.newConsumer();
        Assertions.assertDoesNotThrow(() -> this.consumer.completeQuietly(() -> future.get(0L, TimeUnit.MILLISECONDS), "test", exception));
        Assertions.assertNull(exception.get());
        Assertions.assertDoesNotThrow(() -> this.consumer.completeQuietly(() -> {
            throw new KafkaException("Test exception");
        }, "test", exception));
        Assertions.assertTrue((boolean)(exception.get() instanceof KafkaException));
    }

    @Test
    public void testAutoCommitSyncEnabled() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)((ConsumerInterceptors)Mockito.mock(ConsumerInterceptors.class)), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        this.consumer.subscribe(Collections.singleton("topic"), (ConsumerRebalanceListener)Mockito.mock(ConsumerRebalanceListener.class));
        subscriptions.assignFromSubscribed(Collections.singleton(new TopicPartition("topic", 0)));
        subscriptions.seek(new TopicPartition("topic", 0), 100L);
        this.consumer.maybeAutoCommitSync(true, this.time.timer(100L), null);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(CommitApplicationEvent.class));
    }

    @Test
    public void testAutoCommitSyncDisabled() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)((ConsumerInterceptors)Mockito.mock(ConsumerInterceptors.class)), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        this.consumer.subscribe(Collections.singleton("topic"), (ConsumerRebalanceListener)Mockito.mock(ConsumerRebalanceListener.class));
        subscriptions.assignFromSubscribed(Collections.singleton(new TopicPartition("topic", 0)));
        subscriptions.seek(new TopicPartition("topic", 0), 100L);
        this.consumer.maybeAutoCommitSync(false, this.time.timer(100L), null);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.never())).add((ApplicationEvent)ArgumentMatchers.any(CommitApplicationEvent.class));
    }

    private void assertMockCommitCallbackInvoked(Executable task, MockCommitCallback callback, Errors errors) {
        Assertions.assertDoesNotThrow((Executable)task);
        Assertions.assertEquals((int)1, (int)callback.invoked);
        if (errors == null) {
            Assertions.assertNull((Object)callback.exception);
        } else if (errors.exception() instanceof RetriableException) {
            Assertions.assertInstanceOf(RetriableCommitFailedException.class, (Object)callback.exception);
        }
    }

    @Test
    public void testAssign() {
        this.consumer = this.newConsumer();
        TopicPartition tp = new TopicPartition("foo", 3);
        this.consumer.assign(Collections.singleton(tp));
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().contains(tp));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(AssignmentChangeApplicationEvent.class));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(NewTopicsMetadataUpdateRequestEvent.class));
    }

    @Test
    public void testAssignOnNullTopicPartition() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(null));
    }

    @Test
    public void testAssignOnEmptyTopicPartition() {
        this.consumer = this.newConsumer();
        this.completeUnsubscribeApplicationEventSuccessfully();
        this.consumer.assign(Collections.emptyList());
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
    }

    @Test
    public void testAssignOnNullTopicInPartition() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition(null, 0))));
    }

    @Test
    public void testAssignOnEmptyTopicInPartition() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition("  ", 0))));
    }

    @Test
    public void testBeginningOffsetsFailsIfNullPartitions() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(NullPointerException.class, () -> this.consumer.beginningOffsets(null, Duration.ofMillis(1L)));
    }

    @Test
    public void testBeginningOffsets() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndTimestamp> expectedOffsetsAndTimestamp = this.mockOffsetAndTimestamp();
        Set partitions = expectedOffsetsAndTimestamp.keySet();
        ((ApplicationEventHandler)Mockito.doReturn(expectedOffsetsAndTimestamp).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Map result = (Map)Assertions.assertDoesNotThrow(() -> this.consumer.beginningOffsets((Collection)partitions, Duration.ofMillis(1L)));
        Map<TopicPartition, Long> expectedOffsets = expectedOffsetsAndTimestamp.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((OffsetAndTimestamp)e.getValue()).offset()));
        Assertions.assertEquals(expectedOffsets, (Object)result);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testBeginningOffsetsThrowsKafkaExceptionForUnderlyingExecutionFailure() {
        this.consumer = this.newConsumer();
        Set<TopicPartition> partitions = this.mockTopicPartitionOffset().keySet();
        KafkaException eventProcessingFailure = new KafkaException("Unexpected failure processing List Offsets event");
        ((ApplicationEventHandler)Mockito.doThrow((Throwable[])new Throwable[]{eventProcessingFailure}).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any());
        Throwable consumerError = Assertions.assertThrows(KafkaException.class, () -> this.consumer.beginningOffsets((Collection)partitions, Duration.ofMillis(1L)));
        Assertions.assertEquals((Object)((Object)eventProcessingFailure), (Object)consumerError);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testBeginningOffsetsTimeoutOnEventProcessingTimeout() {
        this.consumer = this.newConsumer();
        ((ApplicationEventHandler)Mockito.doThrow((Throwable[])new Throwable[]{new org.apache.kafka.common.errors.TimeoutException()}).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> this.consumer.beginningOffsets(Collections.singletonList(new TopicPartition("t1", 0)), Duration.ofMillis(1L)));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testOffsetsForTimesOnNullPartitions() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(NullPointerException.class, () -> this.consumer.offsetsForTimes(null, Duration.ofMillis(1L)));
    }

    @Test
    public void testOffsetsForTimesFailsOnNegativeTargetTimes() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition("topic1", 1), -2L), Duration.ofMillis(1L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition("topic1", 1), -1L), Duration.ofMillis(1L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition("topic1", 1), -3L), Duration.ofMillis(1L)));
    }

    @Test
    public void testOffsetsForTimes() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndTimestamp> expectedResult = this.mockOffsetAndTimestamp();
        HashMap<TopicPartition, Long> timestampToSearch = this.mockTimestampToSearch();
        ((ApplicationEventHandler)Mockito.doReturn(expectedResult).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Map result = (Map)Assertions.assertDoesNotThrow(() -> this.consumer.offsetsForTimes(timestampToSearch, Duration.ofMillis(1L)));
        Assertions.assertEquals(expectedResult, (Object)result);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testOffsetsForTimesWithZeroTimeout() {
        this.consumer = this.newConsumer();
        TopicPartition tp = new TopicPartition("topic1", 0);
        Map<TopicPartition, Object> expectedResult = Collections.singletonMap(tp, null);
        Map<TopicPartition, Long> timestampToSearch = Collections.singletonMap(tp, 5L);
        Map result = (Map)Assertions.assertDoesNotThrow(() -> this.consumer.offsetsForTimes(timestampToSearch, Duration.ZERO));
        Assertions.assertEquals(expectedResult, (Object)result);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.never())).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testWakeupCommitted() {
        this.consumer = this.newConsumer();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = this.mockTopicPartitionOffset();
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            CompletableApplicationEvent event = (CompletableApplicationEvent)invocation.getArgument(0);
            Timer timer = (Timer)invocation.getArgument(1);
            Assertions.assertInstanceOf(FetchCommittedOffsetsApplicationEvent.class, (Object)event);
            Assertions.assertTrue((boolean)event.future().isCompletedExceptionally());
            return ConsumerUtils.getResult((Future)event.future(), (Timer)timer);
        }).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any(Timer.class));
        this.consumer.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.committed(offsets.keySet()));
        Assertions.assertNull((Object)this.consumer.wakeupTrigger().getPendingTask());
    }

    @Test
    public void testRefreshCommittedOffsetsSuccess() {
        this.consumer = this.newConsumer();
        TopicPartition partition = new TopicPartition("t1", 1);
        Set<TopicPartition> partitions = Collections.singleton(partition);
        Map<TopicPartition, OffsetAndMetadata> committedOffsets = Collections.singletonMap(partition, new OffsetAndMetadata(10L));
        this.testRefreshCommittedOffsetsSuccess(partitions, committedOffsets);
    }

    @Test
    public void testRefreshCommittedOffsetsSuccessButNoCommittedOffsetsFound() {
        this.consumer = this.newConsumer();
        TopicPartition partition = new TopicPartition("t1", 1);
        Set<TopicPartition> partitions = Collections.singleton(partition);
        Map<TopicPartition, OffsetAndMetadata> committedOffsets = Collections.emptyMap();
        this.testRefreshCommittedOffsetsSuccess(partitions, committedOffsets);
    }

    @Test
    public void testRefreshCommittedOffsetsShouldNotResetIfFailedWithTimeout() {
        this.consumer = this.newConsumer();
        this.testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(true);
    }

    @Test
    public void testRefreshCommittedOffsetsNotCalledIfNoGroupId() {
        this.consumer = this.newConsumerWithoutGroupId();
        this.testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(false);
    }

    @Test
    public void testSubscribeGeneratesEvent() {
        this.consumer = this.newConsumer();
        String topic = "topic1";
        this.consumer.subscribe(Collections.singletonList(topic));
        Assertions.assertEquals(Collections.singleton(topic), (Object)this.consumer.subscription());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(SubscriptionChangeApplicationEvent.class));
    }

    @Test
    public void testUnsubscribeGeneratesUnsubscribeEvent() {
        this.consumer = this.newConsumer();
        this.completeUnsubscribeApplicationEventSuccessfully();
        this.consumer.unsubscribe();
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(UnsubscribeApplicationEvent.class));
    }

    @Test
    public void testSubscribeToEmptyListActsAsUnsubscribe() {
        this.consumer = this.newConsumer();
        this.completeUnsubscribeApplicationEventSuccessfully();
        this.consumer.subscribe(Collections.emptyList());
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(UnsubscribeApplicationEvent.class));
    }

    @Test
    public void testSubscribeToNullTopicCollection() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe((Collection)null));
    }

    @Test
    public void testSubscriptionOnNullTopic() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(null)));
    }

    @Test
    public void testSubscriptionOnEmptyTopic() {
        this.consumer = this.newConsumer();
        String emptyTopic = "  ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(emptyTopic)));
    }

    @Test
    public void testGroupMetadataAfterCreationWithGroupIdIsNull() {
        Properties props = this.requiredConsumerProperties();
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertFalse((boolean)config.unused().contains("auto.commit.interval.ms"));
        Assertions.assertFalse((boolean)config.unused().contains("internal.throw.on.fetch.stable.offset.unsupported"));
        Throwable exception = Assertions.assertThrows(InvalidGroupIdException.class, () -> this.consumer.groupMetadata());
        Assertions.assertEquals((Object)"To use the group management or offset commit APIs, you must provide a valid group.id in the consumer configuration.", (Object)exception.getMessage());
    }

    @Test
    public void testGroupMetadataAfterCreationWithGroupIdIsNotNull() {
        String groupId = "consumerGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("consumerGroupA"));
        this.consumer = this.newConsumer(config);
        ConsumerGroupMetadata groupMetadata = this.consumer.groupMetadata();
        Assertions.assertEquals((Object)"consumerGroupA", (Object)groupMetadata.groupId());
        Assertions.assertEquals(Optional.empty(), (Object)groupMetadata.groupInstanceId());
        Assertions.assertEquals((int)-1, (int)groupMetadata.generationId());
        Assertions.assertEquals((Object)"", (Object)groupMetadata.memberId());
    }

    @Test
    public void testGroupMetadataAfterCreationWithGroupIdIsNotNullAndGroupInstanceIdSet() {
        String groupId = "consumerGroupA";
        String groupInstanceId = "groupInstanceId1";
        Properties props = this.requiredConsumerPropertiesAndGroupId("consumerGroupA");
        props.put("group.instance.id", "groupInstanceId1");
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        ConsumerGroupMetadata groupMetadata = this.consumer.groupMetadata();
        Assertions.assertEquals((Object)"consumerGroupA", (Object)groupMetadata.groupId());
        Assertions.assertEquals(Optional.of("groupInstanceId1"), (Object)groupMetadata.groupInstanceId());
        Assertions.assertEquals((int)-1, (int)groupMetadata.generationId());
        Assertions.assertEquals((Object)"", (Object)groupMetadata.memberId());
    }

    @Test
    public void testGroupMetadataUpdateSingleCall() {
        String groupId = "consumerGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("consumerGroupA"));
        this.consumer = this.newConsumer(config);
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(Utils.mkMap((Map.Entry[])new Map.Entry[0]));
        boolean generation = true;
        String memberId = "newMemberId";
        ConsumerGroupMetadata expectedGroupMetadata = new ConsumerGroupMetadata("consumerGroupA", 1, "newMemberId", Optional.empty());
        GroupMetadataUpdateEvent groupMetadataUpdateEvent = new GroupMetadataUpdateEvent(1, "newMemberId");
        this.backgroundEventQueue.add((BackgroundEvent)groupMetadataUpdateEvent);
        this.consumer.assign(Collections.singletonList(new TopicPartition("topic", 0)));
        this.consumer.poll(Duration.ZERO);
        ConsumerGroupMetadata actualGroupMetadata = this.consumer.groupMetadata();
        Assertions.assertEquals((Object)expectedGroupMetadata, (Object)actualGroupMetadata);
        ConsumerGroupMetadata secondActualGroupMetadataWithoutUpdate = this.consumer.groupMetadata();
        Assertions.assertEquals((Object)expectedGroupMetadata, (Object)secondActualGroupMetadataWithoutUpdate);
    }

    @ParameterizedTest
    @MethodSource(value={"listenerCallbacksInvokeSource"})
    public void testListenerCallbacksInvoke(List<ConsumerRebalanceListenerMethodName> methodNames, Optional<RuntimeException> revokedError, Optional<RuntimeException> assignedError, Optional<RuntimeException> lostError, int expectedRevokedCount, int expectedAssignedCount, int expectedLostCount) {
        this.consumer = this.newConsumer();
        CounterConsumerRebalanceListener consumerRebalanceListener = new CounterConsumerRebalanceListener(revokedError, assignedError, lostError);
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        this.consumer.subscribe(Collections.singletonList("topic"), (ConsumerRebalanceListener)consumerRebalanceListener);
        SortedSet partitions = Collections.emptySortedSet();
        for (ConsumerRebalanceListenerMethodName methodName : methodNames) {
            ConsumerRebalanceListenerCallbackNeededEvent e = new ConsumerRebalanceListenerCallbackNeededEvent(methodName, partitions);
            this.backgroundEventQueue.add((BackgroundEvent)e);
            this.consumer.poll(Duration.ZERO);
        }
        Assertions.assertEquals((int)expectedRevokedCount, (int)consumerRebalanceListener.revokedCount());
        Assertions.assertEquals((int)expectedAssignedCount, (int)consumerRebalanceListener.assignedCount());
        Assertions.assertEquals((int)expectedLostCount, (int)consumerRebalanceListener.lostCount());
    }

    private static Stream<Arguments> listenerCallbacksInvokeSource() {
        Optional empty = Optional.empty();
        Optional<RuntimeException> error = Optional.of(new RuntimeException("Intentional error"));
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.emptyList(), empty, empty, empty, 0, 0, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED), empty, empty, empty, 1, 0, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED), empty, empty, empty, 0, 1, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST), empty, empty, empty, 0, 0, 1}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED), error, empty, empty, 1, 0, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED), empty, error, empty, 0, 1, 0}), Arguments.of((Object[])new Object[]{Collections.singletonList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST), empty, empty, error, 0, 0, 1}), Arguments.of((Object[])new Object[]{Arrays.asList(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED), error, empty, empty, 1, 1, 0}));
    }

    @Test
    public void testBackgroundError() {
        String groupId = "consumerGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("consumerGroupA"));
        this.consumer = this.newConsumer(config);
        KafkaException expectedException = new KafkaException("Nobody expects the Spanish Inquisition");
        ErrorBackgroundEvent errorBackgroundEvent = new ErrorBackgroundEvent((Throwable)expectedException);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent);
        this.consumer.assign(Collections.singletonList(new TopicPartition("topic", 0)));
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((Object)expectedException.getMessage(), (Object)exception.getMessage());
    }

    @Test
    public void testMultipleBackgroundErrors() {
        String groupId = "consumerGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("consumerGroupA"));
        this.consumer = this.newConsumer(config);
        KafkaException expectedException1 = new KafkaException("Nobody expects the Spanish Inquisition");
        ErrorBackgroundEvent errorBackgroundEvent1 = new ErrorBackgroundEvent((Throwable)expectedException1);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent1);
        KafkaException expectedException2 = new KafkaException("Spam, Spam, Spam");
        ErrorBackgroundEvent errorBackgroundEvent2 = new ErrorBackgroundEvent((Throwable)expectedException2);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent2);
        this.consumer.assign(Collections.singletonList(new TopicPartition("topic", 0)));
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((Object)expectedException1.getMessage(), (Object)exception.getMessage());
        Assertions.assertTrue((boolean)this.backgroundEventQueue.isEmpty());
    }

    @Test
    public void testGroupRemoteAssignorUnusedIfGroupIdUndefined() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.remote.assignor", "someAssignor");
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertTrue((boolean)config.unused().contains("group.remote.assignor"));
    }

    @Test
    public void testGroupRemoteAssignorUnusedInGenericProtocol() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", "consumerGroupA");
        props.put("group.protocol", GroupProtocol.CLASSIC.name().toLowerCase(Locale.ROOT));
        props.put("group.remote.assignor", "someAssignor");
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertTrue((boolean)config.unused().contains("group.remote.assignor"));
    }

    @Test
    public void testGroupRemoteAssignorUsedInConsumerProtocol() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", "consumerGroupA");
        props.put("group.protocol", GroupProtocol.CONSUMER.name().toLowerCase(Locale.ROOT));
        props.put("group.remote.assignor", "someAssignor");
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertFalse((boolean)config.unused().contains("group.remote.assignor"));
    }

    @Test
    public void testGroupIdNull() {
        Properties props = this.requiredConsumerProperties();
        props.put("auto.commit.interval.ms", (Object)10000);
        props.put("internal.throw.on.fetch.stable.offset.unsupported", (Object)true);
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertFalse((boolean)config.unused().contains("auto.commit.interval.ms"));
        Assertions.assertFalse((boolean)config.unused().contains("internal.throw.on.fetch.stable.offset.unsupported"));
    }

    @Test
    public void testGroupIdNotNullAndValid() {
        Properties props = this.requiredConsumerPropertiesAndGroupId("consumerGroupA");
        props.put("auto.commit.interval.ms", (Object)10000);
        props.put("internal.throw.on.fetch.stable.offset.unsupported", (Object)true);
        ConsumerConfig config = new ConsumerConfig(props);
        this.consumer = this.newConsumer(config);
        Assertions.assertTrue((boolean)config.unused().contains("auto.commit.interval.ms"));
        Assertions.assertTrue((boolean)config.unused().contains("internal.throw.on.fetch.stable.offset.unsupported"));
    }

    @Test
    public void testGroupIdEmpty() {
        this.testInvalidGroupId("");
    }

    @Test
    public void testGroupIdOnlyWhitespaces() {
        this.testInvalidGroupId("       ");
    }

    @Test
    public void testEnsurePollEventSentOnConsumerPoll() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.consumer = this.newConsumer((FetchBuffer)Mockito.mock(FetchBuffer.class), (ConsumerInterceptors<String, String>)new ConsumerInterceptors(Collections.emptyList()), (ConsumerRebalanceListenerInvoker)Mockito.mock(ConsumerRebalanceListenerInvoker.class), subscriptions, Collections.singletonList(new RoundRobinAssignor()), "group-id", "client-id");
        TopicPartition tp = new TopicPartition("topic", 0);
        List<ConsumerRecord> records = Collections.singletonList(new ConsumerRecord("topic", 0, 2L, (Object)"key1", (Object)"value1"));
        ((FetchCollector)Mockito.doAnswer(invocation -> Fetch.forPartition((TopicPartition)tp, (List)records, (boolean)true)).when(this.fetchCollector)).collectFetch((FetchBuffer)Mockito.any(FetchBuffer.class));
        this.consumer.subscribe(Collections.singletonList("topic1"));
        this.consumer.poll(Duration.ofMillis(100L));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(PollApplicationEvent.class));
    }

    private void testInvalidGroupId(String groupId) {
        Properties props = this.requiredConsumerPropertiesAndGroupId(groupId);
        ConsumerConfig config = new ConsumerConfig(props);
        Exception exception = (Exception)Assertions.assertThrows(KafkaException.class, () -> {
            this.consumer = this.newConsumer(config);
        });
        Assertions.assertEquals((Object)"Failed to construct kafka consumer", (Object)exception.getMessage());
    }

    private Properties requiredConsumerPropertiesAndGroupId(String groupId) {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", groupId);
        return props;
    }

    private Properties requiredConsumerProperties() {
        Properties props = new Properties();
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("bootstrap.servers", "localhost:9091");
        return props;
    }

    private void testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(boolean committedOffsetsEnabled) {
        this.completeFetchedCommittedOffsetApplicationEventExceptionally((Exception)((Object)new org.apache.kafka.common.errors.TimeoutException()));
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        this.consumer.assign(Collections.singleton(new TopicPartition("t1", 1)));
        this.consumer.poll(Duration.ZERO);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ValidatePositionsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
        if (committedOffsetsEnabled) {
            ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
            ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.never())).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
        } else {
            ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.never())).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
            ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
        }
    }

    private void testRefreshCommittedOffsetsSuccess(Set<TopicPartition> partitions, Map<TopicPartition, OffsetAndMetadata> committedOffsets) {
        this.completeFetchedCommittedOffsetApplicationEventSuccessfully(committedOffsets);
        ((FetchCollector)Mockito.doReturn((Object)Fetch.empty()).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        ((ConsumerMetadata)Mockito.doReturn((Object)Metadata.LeaderAndEpoch.noLeaderOrEpoch()).when((Object)this.metadata)).currentLeader((TopicPartition)ArgumentMatchers.any());
        this.consumer.assign(partitions);
        this.consumer.poll(Duration.ZERO);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ValidatePositionsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.atLeast((int)1))).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testLongPollWaitIsLimited() {
        this.consumer = this.newConsumer();
        String topicName = "topic1";
        this.consumer.subscribe(Collections.singletonList(topicName));
        Assertions.assertEquals(Collections.singleton(topicName), (Object)this.consumer.subscription());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        int partition = 3;
        TopicPartition tp = new TopicPartition(topicName, 3);
        List<ConsumerRecord> records = Arrays.asList(new ConsumerRecord(topicName, 3, 2L, (Object)"key1", (Object)"value1"), new ConsumerRecord(topicName, 3, 3L, (Object)"key2", (Object)"value2"));
        ((FetchCollector)Mockito.doAnswer(invocation -> {
            this.consumer.subscriptions().assignFromSubscribed(Collections.singleton(tp));
            return Fetch.empty();
        }).doAnswer(invocation -> Fetch.forPartition((TopicPartition)tp, (List)records, (boolean)true)).when(this.fetchCollector)).collectFetch((FetchBuffer)ArgumentMatchers.any(FetchBuffer.class));
        ConsumerRecords returnedRecords = this.consumer.poll(Duration.ofMillis(10000L));
        Assertions.assertEquals((int)2, (int)returnedRecords.count());
        Assertions.assertEquals(Collections.singleton(topicName), (Object)this.consumer.subscription());
        Assertions.assertEquals(Collections.singleton(tp), (Object)this.consumer.assignment());
    }

    @Test
    public void testProcessBackgroundEventsWithInitialDelay() throws Exception {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CountDownLatch latch = new CountDownLatch(3);
        ((CompletableFuture)Mockito.doAnswer(invocation -> {
            latch.countDown();
            if (latch.getCount() > 0L) {
                long timeout = (Long)invocation.getArgument(0, Long.class);
                timer.sleep(timeout);
                throw new TimeoutException("Intentional timeout");
            }
            future.complete(null);
            return null;
        }).when((Object)future)).get((Long)ArgumentMatchers.any(Long.class), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        try (EventProcessor processor = (EventProcessor)Mockito.mock(EventProcessor.class);){
            this.consumer.processBackgroundEvents(processor, (Future)future, timer);
            Assertions.assertEquals((long)800L, (long)timer.remainingMs());
        }
    }

    @Test
    public void testProcessBackgroundEventsWithoutDelay() {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        try (EventProcessor processor = (EventProcessor)Mockito.mock(EventProcessor.class);){
            this.consumer.processBackgroundEvents(processor, future, timer);
            Assertions.assertEquals((long)1000L, (long)timer.remainingMs());
        }
    }

    @Test
    public void testProcessBackgroundEventsTimesOut() throws Exception {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        ((CompletableFuture)Mockito.doAnswer(invocation -> {
            long timeout = (Long)invocation.getArgument(0, Long.class);
            timer.sleep(timeout);
            throw new TimeoutException("Intentional timeout");
        }).when((Object)future)).get((Long)ArgumentMatchers.any(Long.class), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        try (EventProcessor processor = (EventProcessor)Mockito.mock(EventProcessor.class);){
            Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> this.consumer.processBackgroundEvents(processor, (Future)future, timer));
            Assertions.assertEquals((long)0L, (long)timer.remainingMs());
        }
    }

    private HashMap<TopicPartition, OffsetAndMetadata> mockTopicPartitionOffset() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L));
        return topicPartitionOffsets;
    }

    private HashMap<TopicPartition, OffsetAndTimestamp> mockOffsetAndTimestamp() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndTimestamp> offsetAndTimestamp = new HashMap<TopicPartition, OffsetAndTimestamp>();
        offsetAndTimestamp.put(t0, new OffsetAndTimestamp(5L, 1L));
        offsetAndTimestamp.put(t1, new OffsetAndTimestamp(6L, 3L));
        return offsetAndTimestamp;
    }

    private HashMap<TopicPartition, Long> mockTimestampToSearch() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, Long> timestampToSearch = new HashMap<TopicPartition, Long>();
        timestampToSearch.put(t0, 1L);
        timestampToSearch.put(t1, 2L);
        return timestampToSearch;
    }

    private void completeCommitApplicationEventExceptionally(Exception ex) {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            CommitApplicationEvent event = (CommitApplicationEvent)invocation.getArgument(0);
            event.future().completeExceptionally(ex);
            return null;
        }).when((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(CommitApplicationEvent.class));
    }

    private void completeCommitApplicationEventExceptionally() {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            CommitApplicationEvent event = (CommitApplicationEvent)invocation.getArgument(0);
            event.future().complete(null);
            return null;
        }).when((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(CommitApplicationEvent.class));
    }

    private void completeFetchedCommittedOffsetApplicationEventSuccessfully(Map<TopicPartition, OffsetAndMetadata> committedOffsets) {
        ((ApplicationEventHandler)Mockito.doReturn(committedOffsets).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any(Timer.class));
    }

    private void completeFetchedCommittedOffsetApplicationEventExceptionally(Exception ex) {
        ((ApplicationEventHandler)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(FetchCommittedOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.any(Timer.class));
    }

    private void completeUnsubscribeApplicationEventSuccessfully() {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            UnsubscribeApplicationEvent event = (UnsubscribeApplicationEvent)invocation.getArgument(0);
            event.future().complete(null);
            return null;
        }).when((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(UnsubscribeApplicationEvent.class));
    }

    private void forceCommitCallbackInvocation() {
        this.consumer.commitAsync();
    }

    private static class MockCommitCallback
    implements OffsetCommitCallback {
        public int invoked = 0;
        public Exception exception = null;
        public String completionThread;

        private MockCommitCallback() {
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            ++this.invoked;
            this.completionThread = Thread.currentThread().getName();
            this.exception = exception;
        }
    }
}

