/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetFetchRequestTest {
    private final String topicOne = "topic1";
    private final int partitionOne = 1;
    private final String topicTwo = "topic2";
    private final int partitionTwo = 2;
    private final String topicThree = "topic3";
    private final String group1 = "group1";
    private final String group2 = "group2";
    private final String group3 = "group3";
    private final String group4 = "group4";
    private final String group5 = "group5";
    private List<String> groups = Arrays.asList("group1", "group2", "group3", "group4", "group5");
    private final List<Integer> listOfVersionsNonBatchOffsetFetch = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
    private OffsetFetchRequest.Builder builder;

    @Test
    public void testConstructor() {
        List<TopicPartition> partitions = Arrays.asList(new TopicPartition("topic1", 1), new TopicPartition("topic2", 2));
        int throttleTimeMs = 10;
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> expectedData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (TopicPartition partition : partitions) {
            expectedData.put(partition, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
        }
        Iterator<Object> iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            OffsetFetchRequest request;
            short version = (Short)iterator.next();
            if (version < 8) {
                this.builder = new OffsetFetchRequest.Builder("group1", false, partitions, false);
                request = this.builder.build(version);
                Assertions.assertFalse((boolean)request.isAllPartitions());
                Assertions.assertEquals((Object)"group1", (Object)request.groupId());
                Assertions.assertEquals(partitions, (Object)request.partitions());
                OffsetFetchResponse response = request.getErrorResponse(throttleTimeMs, Errors.NONE);
                Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
                Assertions.assertFalse((boolean)response.hasError());
                Assertions.assertEquals(Collections.singletonMap(Errors.NONE, version <= 1 ? 3 : 1), (Object)response.errorCounts(), (String)("Incorrect error count for version " + version));
                if (version <= 1) {
                    Assertions.assertEquals(expectedData, (Object)response.responseDataV0ToV7());
                }
                if (version >= 3) {
                    Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
                    continue;
                }
                Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
                continue;
            }
            this.builder = new OffsetFetchRequest.Builder(Collections.singletonMap("group1", partitions), false, false);
            request = this.builder.build(version);
            Map groupToPartitionMap = request.groupIdsToPartitions();
            Map groupToTopicMap = request.groupIdsToTopics();
            Assertions.assertFalse((boolean)request.isAllPartitionsForGroup("group1"));
            Assertions.assertTrue((groupToPartitionMap.containsKey("group1") && groupToTopicMap.containsKey("group1") ? 1 : 0) != 0);
            Assertions.assertEquals(partitions, groupToPartitionMap.get("group1"));
            OffsetFetchResponse response = request.getErrorResponse(throttleTimeMs, Errors.NONE);
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.groupLevelError("group1"));
            Assertions.assertFalse((boolean)response.groupHasError("group1"));
            Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts(), (String)("Incorrect error count for version " + version));
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }

    @Test
    public void testConstructorWithMultipleGroups() {
        List<TopicPartition> topic1Partitions = Arrays.asList(new TopicPartition("topic1", 1), new TopicPartition("topic1", 2));
        List<TopicPartition> topic2Partitions = Arrays.asList(new TopicPartition("topic2", 1), new TopicPartition("topic2", 2));
        List<TopicPartition> topic3Partitions = Arrays.asList(new TopicPartition("topic3", 1), new TopicPartition("topic3", 2));
        HashMap<String, List<TopicPartition>> groupToTp = new HashMap<String, List<TopicPartition>>();
        groupToTp.put("group1", topic1Partitions);
        groupToTp.put("group2", topic2Partitions);
        groupToTp.put("group3", topic3Partitions);
        groupToTp.put("group4", null);
        groupToTp.put("group5", null);
        int throttleTimeMs = 10;
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            this.builder = new OffsetFetchRequest.Builder(groupToTp, false, false);
            OffsetFetchRequest request = this.builder.build(version);
            Map groupToPartitionMap = request.groupIdsToPartitions();
            Map groupToTopicMap = request.groupIdsToTopics();
            Assertions.assertEquals(groupToTp.keySet(), groupToTopicMap.keySet());
            Assertions.assertEquals(groupToTp.keySet(), groupToPartitionMap.keySet());
            Assertions.assertFalse((boolean)request.isAllPartitionsForGroup("group1"));
            Assertions.assertFalse((boolean)request.isAllPartitionsForGroup("group2"));
            Assertions.assertFalse((boolean)request.isAllPartitionsForGroup("group3"));
            Assertions.assertTrue((boolean)request.isAllPartitionsForGroup("group4"));
            Assertions.assertTrue((boolean)request.isAllPartitionsForGroup("group5"));
            OffsetFetchResponse response = request.getErrorResponse(throttleTimeMs, Errors.NONE);
            for (String group : this.groups) {
                Assertions.assertEquals((Object)Errors.NONE, (Object)response.groupLevelError(group));
                Assertions.assertFalse((boolean)response.groupHasError(group));
            }
            Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 5), (Object)response.errorCounts(), (String)("Incorrect error count for version " + version));
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }

    @Test
    public void testBuildThrowForUnsupportedBatchRequest() {
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            HashMap<String, Object> groupPartitionMap = new HashMap<String, Object>();
            groupPartitionMap.put("group1", null);
            groupPartitionMap.put("group2", null);
            this.builder = new OffsetFetchRequest.Builder(groupPartitionMap, true, false);
            short finalVersion = (short)version;
            Assertions.assertThrows(OffsetFetchRequest.NoBatchedOffsetFetchRequestException.class, () -> this.builder.build(finalVersion));
        }
    }

    @Test
    public void testConstructorFailForUnsupportedRequireStable() {
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) {
                this.builder = new OffsetFetchRequest.Builder("group1", true, null, false);
                short finalVersion = version;
                if (version < 2) {
                    Assertions.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                    continue;
                }
                OffsetFetchRequest request = this.builder.build(finalVersion);
                Assertions.assertEquals((Object)"group1", (Object)request.groupId());
                Assertions.assertNull((Object)request.partitions());
                Assertions.assertTrue((boolean)request.isAllPartitions());
                if (version < 7) {
                    Assertions.assertFalse((boolean)request.requireStable());
                    continue;
                }
                Assertions.assertTrue((boolean)request.requireStable());
                continue;
            }
            this.builder = new OffsetFetchRequest.Builder(Collections.singletonMap("group1", null), true, false);
            OffsetFetchRequest request = this.builder.build(version);
            Map groupToPartitionMap = request.groupIdsToPartitions();
            Map groupToTopicMap = request.groupIdsToTopics();
            Assertions.assertTrue((groupToPartitionMap.containsKey("group1") && groupToTopicMap.containsKey("group1") ? 1 : 0) != 0);
            Assertions.assertNull(groupToPartitionMap.get("group1"));
            Assertions.assertTrue((boolean)request.isAllPartitionsForGroup("group1"));
            Assertions.assertTrue((boolean)request.requireStable());
        }
    }

    @Test
    public void testBuildThrowForUnsupportedRequireStable() {
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            this.builder = new OffsetFetchRequest.Builder("group1", true, null, true);
            if (version < 7) {
                short finalVersion = (short)version;
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                continue;
            }
            OffsetFetchRequest request = this.builder.build((short)version);
            Assertions.assertTrue((boolean)request.requireStable());
        }
    }
}

