/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubscriptionStateTest {
    private SubscriptionState state = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
    private final String topic = "test";
    private final String topic1 = "test1";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final TopicPartition t1p0 = new TopicPartition("test1", 0);
    private final MockRebalanceListener rebalanceListener = new MockRebalanceListener();
    private final Metadata.LeaderAndEpoch leaderAndEpoch = Metadata.LeaderAndEpoch.noLeaderOrEpoch();

    @Test
    public void partitionAssignment() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        Assertions.assertFalse((boolean)this.state.hasAllFetchPositions());
        this.state.seek(this.tp0, 1L);
        Assertions.assertTrue((boolean)this.state.isFetchable(this.tp0));
        Assertions.assertEquals((long)1L, (long)this.state.position((TopicPartition)this.tp0).offset);
        this.state.assignFromUser(Collections.emptySet());
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        Assertions.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assertions.assertFalse((boolean)this.state.isFetchable(this.tp0));
    }

    @Test
    public void partitionAssignmentChangeOnTopicSubscription() {
        this.state.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        Assertions.assertEquals((int)2, (int)this.state.assignedPartitions().size());
        Assertions.assertEquals((int)2, (int)this.state.numAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.assignedPartitions().contains(this.tp0));
        Assertions.assertTrue((boolean)this.state.assignedPartitions().contains(this.tp1));
        this.state.unsubscribe();
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        this.state.subscribe(Collections.singleton("test1"), Optional.of(this.rebalanceListener));
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.t1p0)));
        this.state.assignFromSubscribed(Collections.singleton(this.t1p0));
        Assertions.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        this.state.unsubscribe();
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
    }

    @Test
    public void testGroupSubscribe() {
        this.state.subscribe(Collections.singleton("test1"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals(Collections.singleton("test1"), (Object)this.state.metadataTopics());
        Assertions.assertFalse((boolean)this.state.groupSubscribe(Collections.singleton("test1")));
        Assertions.assertEquals(Collections.singleton("test1"), (Object)this.state.metadataTopics());
        Assertions.assertTrue((boolean)this.state.groupSubscribe((Collection)Utils.mkSet((Object[])new String[]{"test", "test1"})));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test1"}), (Object)this.state.metadataTopics());
        Assertions.assertFalse((boolean)this.state.groupSubscribe(Collections.singleton("test1")));
        Assertions.assertEquals(Collections.singleton("test1"), (Object)this.state.metadataTopics());
        this.state.subscribe(Collections.singleton("anotherTopic"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test1", "anotherTopic"}), (Object)this.state.metadataTopics());
        Assertions.assertFalse((boolean)this.state.groupSubscribe(Collections.singleton("anotherTopic")));
        Assertions.assertEquals(Collections.singleton("anotherTopic"), (Object)this.state.metadataTopics());
    }

    @Test
    public void partitionAssignmentChangeOnPatternSubscription() {
        this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener));
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        this.state.subscribeFromPattern(Collections.singleton("test"));
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp1)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assertions.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.t1p0)));
        this.state.assignFromSubscribed(Collections.singleton(this.t1p0));
        Assertions.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        this.state.subscribe(Pattern.compile(".*t"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        this.state.subscribeFromPattern(Collections.singleton("test"));
        Assertions.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp0)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        this.state.unsubscribe();
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
    }

    @Test
    public void verifyAssignmentId() {
        Assertions.assertEquals((int)0, (int)this.state.assignmentId());
        Set userAssignment = Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1});
        this.state.assignFromUser(userAssignment);
        Assertions.assertEquals((int)1, (int)this.state.assignmentId());
        Assertions.assertEquals((Object)userAssignment, (Object)this.state.assignedPartitions());
        this.state.unsubscribe();
        Assertions.assertEquals((int)2, (int)this.state.assignmentId());
        Assertions.assertEquals(Collections.emptySet(), (Object)this.state.assignedPartitions());
        Set autoAssignment = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0});
        this.state.subscribe(Collections.singleton("test1"), Optional.of(this.rebalanceListener));
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription((Collection)autoAssignment));
        this.state.assignFromSubscribed((Collection)autoAssignment);
        Assertions.assertEquals((int)3, (int)this.state.assignmentId());
        Assertions.assertEquals((Object)autoAssignment, (Object)this.state.assignedPartitions());
    }

    @Test
    public void partitionReset() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 5L);
        Assertions.assertEquals((long)5L, (long)this.state.position((TopicPartition)this.tp0).offset);
        this.state.requestOffsetReset(this.tp0);
        Assertions.assertFalse((boolean)this.state.isFetchable(this.tp0));
        Assertions.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assertions.assertNull((Object)this.state.position(this.tp0));
        this.state.seek(this.tp0, 0L);
        Assertions.assertTrue((boolean)this.state.isFetchable(this.tp0));
        Assertions.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
    }

    @Test
    public void topicSubscription() {
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals((int)1, (int)this.state.subscription().size());
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.hasAutoAssignedPartitions());
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp0)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 1L);
        Assertions.assertEquals((long)1L, (long)this.state.position((TopicPartition)this.tp0).offset);
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp1)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assertions.assertTrue((boolean)this.state.isAssigned(this.tp1));
        Assertions.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assertions.assertFalse((boolean)this.state.isFetchable(this.tp1));
        Assertions.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
    }

    @Test
    public void partitionPause() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 100L);
        Assertions.assertTrue((boolean)this.state.isFetchable(this.tp0));
        this.state.pause(this.tp0);
        Assertions.assertFalse((boolean)this.state.isFetchable(this.tp0));
        this.state.resume(this.tp0);
        Assertions.assertTrue((boolean)this.state.isFetchable(this.tp0));
    }

    @Test
    public void testMarkingPartitionPending() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 100L);
        Assertions.assertTrue((boolean)this.state.isFetchable(this.tp0));
        this.state.markPendingRevocation(Collections.singleton(this.tp0));
        Assertions.assertFalse((boolean)this.state.isFetchable(this.tp0));
        Assertions.assertFalse((boolean)this.state.isPaused(this.tp0));
    }

    @Test
    public void invalidPositionUpdate() {
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp0)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp0));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.position(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.empty(), this.leaderAndEpoch)));
    }

    @Test
    public void cantAssignPartitionForUnsubscribedTopics() {
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertFalse((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singletonList(this.t1p0)));
    }

    @Test
    public void cantAssignPartitionForUnmatchedPattern() {
        this.state.subscribe(Pattern.compile(".*t"), Optional.of(this.rebalanceListener));
        this.state.subscribeFromPattern(Collections.singleton("test"));
        Assertions.assertFalse((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singletonList(this.t1p0)));
    }

    @Test
    public void cantChangePositionForNonAssignedPartition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.position(this.tp0, new SubscriptionState.FetchPosition(1L, Optional.empty(), this.leaderAndEpoch)));
    }

    @Test
    public void cantSubscribeTopicAndPattern() {
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener)));
    }

    @Test
    public void cantSubscribePartitionAndPattern() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener)));
    }

    @Test
    public void cantSubscribePatternAndTopic() {
        this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener)));
    }

    @Test
    public void cantSubscribePatternAndPartition() {
        this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state.assignFromUser(Collections.singleton(this.tp0)));
    }

    @Test
    public void patternSubscription() {
        this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener));
        this.state.subscribeFromPattern(new HashSet<String>(Arrays.asList("test", "test1")));
        Assertions.assertEquals((int)2, (int)this.state.subscription().size(), (String)"Expected subscribed topics count is incorrect");
    }

    @Test
    public void unsubscribeUserAssignment() {
        this.state.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        this.state.unsubscribe();
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
    }

    @Test
    public void unsubscribeUserSubscribe() {
        this.state.subscribe(Collections.singleton("test"), Optional.of(this.rebalanceListener));
        this.state.unsubscribe();
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
    }

    @Test
    public void unsubscription() {
        this.state.subscribe(Pattern.compile(".*"), Optional.of(this.rebalanceListener));
        this.state.subscribeFromPattern(new HashSet<String>(Arrays.asList("test", "test1")));
        Assertions.assertTrue((boolean)this.state.checkAssignmentMatchedSubscription(Collections.singleton(this.tp1)));
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assertions.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        this.state.unsubscribe();
        Assertions.assertEquals((int)0, (int)this.state.subscription().size());
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assertions.assertEquals((int)1, (int)this.state.numAssignedPartitions());
        this.state.unsubscribe();
        Assertions.assertEquals((int)0, (int)this.state.subscription().size());
        Assertions.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assertions.assertEquals((int)0, (int)this.state.numAssignedPartitions());
    }

    @Test
    public void testPreferredReadReplicaLease() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 0L).isPresent());
        this.state.updatePreferredReadReplica(this.tp0, 42, () -> 10L);
        TestUtils.assertOptional(this.state.preferredReadReplica(this.tp0, 9L), value -> Assertions.assertEquals((int)value, (int)42));
        TestUtils.assertOptional(this.state.preferredReadReplica(this.tp0, 10L), value -> Assertions.assertEquals((int)value, (int)42));
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 11L).isPresent());
        this.state.clearPreferredReadReplica(this.tp0);
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 9L).isPresent());
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 11L).isPresent());
        this.state.updatePreferredReadReplica(this.tp0, 43, () -> 20L);
        TestUtils.assertOptional(this.state.preferredReadReplica(this.tp0, 11L), value -> Assertions.assertEquals((int)value, (int)43));
        TestUtils.assertOptional(this.state.preferredReadReplica(this.tp0, 20L), value -> Assertions.assertEquals((int)value, (int)43));
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 21L).isPresent());
        this.state.updatePreferredReadReplica(this.tp0, 44, () -> 30L);
        TestUtils.assertOptional(this.state.preferredReadReplica(this.tp0, 30L), value -> Assertions.assertEquals((int)value, (int)44));
        Assertions.assertFalse((boolean)this.state.preferredReadReplica(this.tp0, 31L).isPresent());
    }

    @Test
    public void testSeekUnvalidatedWithNoOffsetEpoch() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.empty(), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(5))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        ApiVersions apiVersions = new ApiVersions();
        apiVersions.update(broker1.idString(), NodeApiVersions.create());
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.empty())));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
    }

    @Test
    public void testSeekUnvalidatedWithNoEpochClearsAwaitingValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(2), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(5))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.empty(), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(5))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
    }

    @Test
    public void testSeekUnvalidatedWithOffsetEpoch() {
        Node broker1 = new Node(1, "localhost", 9092);
        ApiVersions apiVersions = new ApiVersions();
        apiVersions.update(broker1.idString(), NodeApiVersions.create());
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(2), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(5))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(5))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(15))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.empty())));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
    }

    @Test
    public void testSeekValidatedShouldClearAwaitingValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(5), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((long)10L, (long)this.state.position((TopicPartition)this.tp0).offset);
        this.state.seekValidated(this.tp0, new SubscriptionState.FetchPosition(8L, Optional.of(4), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((long)8L, (long)this.state.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testCompleteValidationShouldClearAwaitingValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(5), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((long)10L, (long)this.state.position((TopicPartition)this.tp0).offset);
        this.state.completeValidation(this.tp0);
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((long)10L, (long)this.state.position((TopicPartition)this.tp0).offset);
    }

    @Test
    public void testOffsetResetWhileAwaitingValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(5), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        this.state.requestOffsetReset(this.tp0, OffsetResetStrategy.EARLIEST);
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
    }

    @Test
    public void testMaybeCompleteValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(initialOffsetEpoch).setEndOffset(initialOffset + 5L));
        Assertions.assertEquals(Optional.empty(), (Object)truncationOpt);
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((Object)initialPosition, (Object)this.state.position(this.tp0));
    }

    @Test
    public void testMaybeValidatePositionForCurrentLeader() {
        NodeApiVersions oldApis = NodeApiVersions.create((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.id, (short)0, (short)2);
        ApiVersions apiVersions = new ApiVersions();
        apiVersions.update("1", oldApis);
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(5), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        apiVersions.update("1", NodeApiVersions.create());
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(5), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertTrue((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(apiVersions, this.tp1, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(10))));
        Assertions.assertFalse((boolean)this.state.assignedPartitions().contains(this.tp1));
    }

    @Test
    public void testMaybeCompleteValidationAfterPositionChange() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        long updateOffset = 20L;
        int updateOffsetEpoch = 8;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        SubscriptionState.FetchPosition updatePosition = new SubscriptionState.FetchPosition(updateOffset, Optional.of(updateOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, updatePosition);
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(initialOffsetEpoch).setEndOffset(initialOffset + 5L));
        Assertions.assertEquals(Optional.empty(), (Object)truncationOpt);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertEquals((Object)updatePosition, (Object)this.state.position(this.tp0));
    }

    @Test
    public void testMaybeCompleteValidationAfterOffsetReset() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        this.state.requestOffsetReset(this.tp0);
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(initialOffsetEpoch).setEndOffset(initialOffset + 5L));
        Assertions.assertEquals(Optional.empty(), (Object)truncationOpt);
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assertions.assertNull((Object)this.state.position(this.tp0));
    }

    @Test
    public void testTruncationDetectionWithResetPolicy() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        long divergentOffset = 5L;
        int divergentOffsetEpoch = 7;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(divergentOffsetEpoch).setEndOffset(divergentOffset));
        Assertions.assertEquals(Optional.empty(), (Object)truncationOpt);
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        SubscriptionState.FetchPosition updatedPosition = new SubscriptionState.FetchPosition(divergentOffset, Optional.of(divergentOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        Assertions.assertEquals((Object)updatedPosition, (Object)this.state.position(this.tp0));
    }

    @Test
    public void testTruncationDetectionWithoutResetPolicy() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        long divergentOffset = 5L;
        int divergentOffsetEpoch = 7;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(divergentOffsetEpoch).setEndOffset(divergentOffset));
        Assertions.assertTrue((boolean)truncationOpt.isPresent());
        SubscriptionState.LogTruncation truncation = (SubscriptionState.LogTruncation)truncationOpt.get();
        Assertions.assertEquals(Optional.of(new OffsetAndMetadata(divergentOffset, Optional.of(divergentOffsetEpoch), "")), (Object)truncation.divergentOffsetOpt);
        Assertions.assertEquals((Object)initialPosition, (Object)truncation.fetchPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
    }

    @Test
    public void testTruncationDetectionUnknownDivergentOffsetWithResetPolicy() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(-1).setEndOffset(-1L));
        Assertions.assertEquals(Optional.empty(), (Object)truncationOpt);
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assertions.assertEquals((Object)OffsetResetStrategy.EARLIEST, (Object)this.state.resetStrategy(this.tp0));
    }

    @Test
    public void testTruncationDetectionUnknownDivergentOffsetWithoutResetPolicy() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        int currentEpoch = 10;
        long initialOffset = 10L;
        int initialOffsetEpoch = 5;
        SubscriptionState.FetchPosition initialPosition = new SubscriptionState.FetchPosition(initialOffset, Optional.of(initialOffsetEpoch), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(currentEpoch)));
        this.state.seekUnvalidated(this.tp0, initialPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Optional truncationOpt = this.state.maybeCompleteValidation(this.tp0, initialPosition, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(-1).setEndOffset(-1L));
        Assertions.assertTrue((boolean)truncationOpt.isPresent());
        SubscriptionState.LogTruncation truncation = (SubscriptionState.LogTruncation)truncationOpt.get();
        Assertions.assertEquals(Optional.empty(), (Object)truncation.divergentOffsetOpt);
        Assertions.assertEquals((Object)initialPosition, (Object)truncation.fetchPosition);
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
    }

    @Test
    public void resetOffsetNoValidation() {
        Node broker1 = new Node(1, "localhost", 9092);
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.requestOffsetReset(this.tp0, OffsetResetStrategy.EARLIEST);
        ApiVersions oldApis = new ApiVersions();
        oldApis.update("1", NodeApiVersions.create((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.id, (short)0, (short)2));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(oldApis, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.empty())));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(oldApis, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.empty())));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
        this.state.requestOffsetReset(this.tp0, OffsetResetStrategy.EARLIEST);
        this.state.seekUnvalidated(this.tp0, new SubscriptionState.FetchPosition(10L, Optional.of(10), new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(2))));
        Assertions.assertFalse((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertTrue((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assertions.assertFalse((boolean)this.state.maybeValidatePositionForCurrentLeader(oldApis, this.tp0, new Metadata.LeaderAndEpoch(Optional.of(broker1), Optional.of(2))));
        Assertions.assertTrue((boolean)this.state.hasValidPosition(this.tp0));
        Assertions.assertFalse((boolean)this.state.awaitingValidation(this.tp0));
        Assertions.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
    }

    @Test
    public void nullPositionLagOnNoPosition() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertNull((Object)this.state.partitionLag(this.tp0, IsolationLevel.READ_UNCOMMITTED));
        Assertions.assertNull((Object)this.state.partitionLag(this.tp0, IsolationLevel.READ_COMMITTED));
        this.state.updateHighWatermark(this.tp0, 1L);
        this.state.updateLastStableOffset(this.tp0, 1L);
        Assertions.assertNull((Object)this.state.partitionLag(this.tp0, IsolationLevel.READ_UNCOMMITTED));
        Assertions.assertNull((Object)this.state.partitionLag(this.tp0, IsolationLevel.READ_COMMITTED));
    }

    private static class MockRebalanceListener
    implements ConsumerRebalanceListener {
        Collection<TopicPartition> revoked;
        public Collection<TopicPartition> assigned;
        int revokedCount = 0;
        int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.assigned = partitions;
            ++this.assignedCount;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.revoked = partitions;
            ++this.revokedCount;
        }
    }
}

