/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;

class AlterPartitionRequestTest {
    String topic = "test-topic";
    Uuid topicId = Uuid.randomUuid();

    AlterPartitionRequestTest() {
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.ALTER_PARTITION)
    public void testBuildAlterPartitionRequest(short version) {
        AlterPartitionRequestData request = new AlterPartitionRequestData().setBrokerId(1).setBrokerEpoch(1L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicId(this.topicId).setTopicName(this.topic);
        LinkedList<AlterPartitionRequestData.BrokerState> newIsrWithBrokerEpoch = new LinkedList<AlterPartitionRequestData.BrokerState>();
        newIsrWithBrokerEpoch.add(new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(1001L));
        newIsrWithBrokerEpoch.add(new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(1002L));
        newIsrWithBrokerEpoch.add(new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(1003L));
        topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs(newIsrWithBrokerEpoch));
        request.topics().add(topicData);
        AlterPartitionRequest.Builder builder = new AlterPartitionRequest.Builder(request, version > 1);
        AlterPartitionRequest alterPartitionRequest = builder.build(version);
        Assertions.assertEquals((int)1, (int)alterPartitionRequest.data().topics().size());
        Assertions.assertEquals((int)1, (int)((AlterPartitionRequestData.TopicData)alterPartitionRequest.data().topics().get(0)).partitions().size());
        AlterPartitionRequestData.PartitionData partitionData = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)alterPartitionRequest.data().topics().get(0)).partitions().get(0);
        if (version < 3) {
            Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)partitionData.newIsr());
            Assertions.assertTrue((boolean)partitionData.newIsrWithEpochs().isEmpty());
        } else {
            Assertions.assertEquals(newIsrWithBrokerEpoch, (Object)partitionData.newIsrWithEpochs());
            Assertions.assertTrue((boolean)partitionData.newIsr().isEmpty());
        }
    }
}

