/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.compress.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.compress.KafkaLZ4BlockOutputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompressionTypeTest {
    @Test
    public void testLZ4FramingMagicV0() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        KafkaLZ4BlockOutputStream out = (KafkaLZ4BlockOutputStream)CompressionType.LZ4.wrapForOutput(new ByteBufferOutputStream(buffer), (byte)0);
        Assertions.assertTrue((boolean)out.useBrokenFlagDescriptorChecksum());
        buffer.rewind();
        KafkaLZ4BlockInputStream in = (KafkaLZ4BlockInputStream)CompressionType.LZ4.wrapForInput(buffer, (byte)0, BufferSupplier.NO_CACHING);
        Assertions.assertTrue((boolean)in.ignoreFlagDescriptorChecksum());
    }

    @Test
    public void testLZ4FramingMagicV1() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        KafkaLZ4BlockOutputStream out = (KafkaLZ4BlockOutputStream)CompressionType.LZ4.wrapForOutput(new ByteBufferOutputStream(buffer), (byte)1);
        Assertions.assertFalse((boolean)out.useBrokenFlagDescriptorChecksum());
        buffer.rewind();
        KafkaLZ4BlockInputStream in = (KafkaLZ4BlockInputStream)CompressionType.LZ4.wrapForInput(buffer, (byte)1, BufferSupplier.create());
        Assertions.assertFalse((boolean)in.ignoreFlagDescriptorChecksum());
    }
}

