/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndTxnRequestTest {
    @Test
    public void testConstructor() {
        short producerEpoch = 0;
        int producerId = 1;
        String transactionId = "txn_id";
        int throttleTimeMs = 10;
        EndTxnRequest.Builder builder = new EndTxnRequest.Builder(new EndTxnRequestData().setCommitted(true).setProducerEpoch(producerEpoch).setProducerId(producerId).setTransactionalId(transactionId));
        Iterator iterator = ApiKeys.END_TXN.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            EndTxnRequest request = builder.build(version);
            EndTxnResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assertions.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 1), (Object)response.errorCounts());
            Assertions.assertEquals((Object)TransactionResult.COMMIT, (Object)request.result());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }
}

