/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddPartitionsToTxnRequestData
implements ApiMessage {
    String transactionalId;
    long producerId;
    short producerEpoch;
    AddPartitionsToTxnTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public AddPartitionsToTxnRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddPartitionsToTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.topics = new AddPartitionsToTxnTopicCollection(0);
    }

    public short apiKey() {
        return 24;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version) {
        int i;
        AddPartitionsToTxnTopicCollection newCollection;
        int arrayLength;
        int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field transactionalId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field transactionalId had invalid length " + length);
        }
        this.transactionalId = _readable.readString(length);
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AddPartitionsToTxnTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AddPartitionsToTxnTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue((Object)this.transactionalId);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                AddPartitionsToTxnTopic topicsElement = (AddPartitionsToTxnTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                AddPartitionsToTxnTopic topicsElement = (AddPartitionsToTxnTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'transactionalId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.transactionalId, _stringBytes);
        if (_version >= 3) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(8);
        _size.addBytes(2);
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        Iterator<RawTaggedField> iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopic topicsElement = (AddPartitionsToTxnTopic)iterator.next();
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnRequestData)) {
            return false;
        }
        AddPartitionsToTxnRequestData other = (AddPartitionsToTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public AddPartitionsToTxnRequestData duplicate() {
        AddPartitionsToTxnRequestData _duplicate = new AddPartitionsToTxnRequestData();
        _duplicate.transactionalId = this.transactionalId;
        _duplicate.producerId = this.producerId;
        _duplicate.producerEpoch = this.producerEpoch;
        AddPartitionsToTxnTopicCollection newTopics = new AddPartitionsToTxnTopicCollection(this.topics.size());
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopic _element = (AddPartitionsToTxnTopic)iterator.next();
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AddPartitionsToTxnRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public AddPartitionsToTxnTopicCollection topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddPartitionsToTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setTopics(AddPartitionsToTxnTopicCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", (Type)Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", (Type)Type.INT16, "Current epoch associated with the producer id."), new Field("topics", (Type)new ArrayOf((Type)AddPartitionsToTxnTopic.SCHEMA_0), "The partitions to add to the transaction.")}));
        SCHEMA_3 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.COMPACT_STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", (Type)Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", (Type)Type.INT16, "Current epoch associated with the producer id."), new Field("topics", (Type)new CompactArrayOf((Type)AddPartitionsToTxnTopic.SCHEMA_3), "The partitions to add to the transaction."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class AddPartitionsToTxnTopicCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTopic> {
        public AddPartitionsToTxnTopicCollection() {
        }

        public AddPartitionsToTxnTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicCollection(Iterator<AddPartitionsToTxnTopic> iterator) {
            super(iterator);
        }

        public AddPartitionsToTxnTopic find(String name) {
            AddPartitionsToTxnTopic _key = new AddPartitionsToTxnTopic();
            _key.setName(name);
            return (AddPartitionsToTxnTopic)this.find(_key);
        }

        public List<AddPartitionsToTxnTopic> findAll(String name) {
            AddPartitionsToTxnTopic _key = new AddPartitionsToTxnTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnTopicCollection duplicate() {
            AddPartitionsToTxnTopicCollection _duplicate = new AddPartitionsToTxnTopicCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AddPartitionsToTxnTopic _element = (AddPartitionsToTxnTopic)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AddPartitionsToTxnTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AddPartitionsToTxnTopic");
            }
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
            } else {
                _writable.writeInt(this.partitions.size());
            }
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AddPartitionsToTxnTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopic)) {
                return false;
            }
            AddPartitionsToTxnTopic other = (AddPartitionsToTxnTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopic)) {
                return false;
            }
            AddPartitionsToTxnTopic other = (AddPartitionsToTxnTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public AddPartitionsToTxnTopic duplicate() {
            AddPartitionsToTxnTopic _duplicate = new AddPartitionsToTxnTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The name of the topic."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes to add to the transaction")}));
            SCHEMA_3 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the topic."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partition indexes to add to the transaction"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

