/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.kafka.common.security.oauthbearer.secured.BasicOAuthBearerToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BasicOAuthBearerTokenTest {
    @Test
    public void basic() {
        BasicOAuthBearerToken token = new BasicOAuthBearerToken("not.valid.token", Collections.emptySet(), 0L, "jdoe", Long.valueOf(0L));
        Assertions.assertEquals((Object)"not.valid.token", (Object)token.value());
        Assertions.assertTrue((boolean)token.scope().isEmpty());
        Assertions.assertEquals((long)0L, (long)token.lifetimeMs());
        Assertions.assertEquals((Object)"jdoe", (Object)token.principalName());
        Assertions.assertEquals((long)0L, (Long)token.startTimeMs());
    }

    @Test
    public void negativeLifetime() {
        BasicOAuthBearerToken token = new BasicOAuthBearerToken("not.valid.token", Collections.emptySet(), -1L, "jdoe", Long.valueOf(0L));
        Assertions.assertEquals((Object)"not.valid.token", (Object)token.value());
        Assertions.assertTrue((boolean)token.scope().isEmpty());
        Assertions.assertEquals((long)-1L, (long)token.lifetimeMs());
        Assertions.assertEquals((Object)"jdoe", (Object)token.principalName());
        Assertions.assertEquals((long)0L, (Long)token.startTimeMs());
    }

    @Test
    public void noErrorIfModifyScope() {
        TreeSet<String> callerSet = new TreeSet<String>(Arrays.asList("a", "b", "c"));
        BasicOAuthBearerToken token = new BasicOAuthBearerToken("not.valid.token", callerSet, 0L, "jdoe", Long.valueOf(0L));
        Assertions.assertNotNull((Object)token.scope());
        Assertions.assertEquals((int)3, (int)token.scope().size());
        callerSet.add("d");
        Assertions.assertTrue((boolean)token.scope().contains("d"));
        callerSet.remove("c");
        Assertions.assertFalse((boolean)token.scope().contains("c"));
        token.scope().clear();
    }
}

