/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ElectLeadersRequestData
implements ApiMessage {
    byte electionType;
    TopicPartitionsCollection topicPartitions;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_partitions", (Type)ArrayOf.nullable((Type)TopicPartitions.SCHEMA_0), "The topic partitions to elect leaders."), new Field("timeout_ms", (Type)Type.INT32, "The time in ms to wait for the election to complete.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("election_type", (Type)Type.INT8, "Type of elections to conduct for the partition. A value of '0' elects the preferred replica. A value of '1' elects the first live replica if there are no in-sync replica."), new Field("topic_partitions", (Type)ArrayOf.nullable((Type)TopicPartitions.SCHEMA_0), "The topic partitions to elect leaders."), new Field("timeout_ms", (Type)Type.INT32, "The time in ms to wait for the election to complete.")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("election_type", (Type)Type.INT8, "Type of elections to conduct for the partition. A value of '0' elects the preferred replica. A value of '1' elects the first live replica if there are no in-sync replica."), new Field("topic_partitions", (Type)CompactArrayOf.nullable((Type)TopicPartitions.SCHEMA_2), "The topic partitions to elect leaders."), new Field("timeout_ms", (Type)Type.INT32, "The time in ms to wait for the election to complete."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public ElectLeadersRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ElectLeadersRequestData() {
        this.electionType = 0;
        this.topicPartitions = new TopicPartitionsCollection(0);
        this.timeoutMs = 60000;
    }

    public short apiKey() {
        return 43;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int i;
        TopicPartitionsCollection newCollection;
        int arrayLength;
        this.electionType = _version >= 1 ? _readable.readByte() : (byte)0;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topicPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new TopicPartitionsCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TopicPartitions(_readable, _version));
                }
                this.topicPartitions = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.topicPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new TopicPartitionsCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TopicPartitions(_readable, _version));
                }
                this.topicPartitions = newCollection;
            }
        }
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeByte(this.electionType);
        } else if (this.electionType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default electionType at version " + _version);
        }
        if (_version >= 2) {
            if (this.topicPartitions == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topicPartitions.size() + 1);
                iterator = this.topicPartitions.iterator();
                while (iterator.hasNext()) {
                    TopicPartitions topicPartitionsElement = (TopicPartitions)iterator.next();
                    topicPartitionsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topicPartitions == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topicPartitions.size());
            iterator = this.topicPartitions.iterator();
            while (iterator.hasNext()) {
                TopicPartitions topicPartitionsElement = (TopicPartitions)iterator.next();
                topicPartitionsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (this.topicPartitions == null) {
            if (_version >= 2) {
                _size.addBytes(1);
            } else {
                _size.addBytes(4);
            }
        } else {
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topicPartitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            Iterator<RawTaggedField> iterator = this.topicPartitions.iterator();
            while (iterator.hasNext()) {
                TopicPartitions topicPartitionsElement = (TopicPartitions)iterator.next();
                topicPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectLeadersRequestData)) {
            return false;
        }
        ElectLeadersRequestData other = (ElectLeadersRequestData)obj;
        if (this.electionType != other.electionType) {
            return false;
        }
        if (this.topicPartitions == null ? other.topicPartitions != null : !this.topicPartitions.equals((Object)other.topicPartitions)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.electionType;
        hashCode = 31 * hashCode + (this.topicPartitions == null ? 0 : this.topicPartitions.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    public ElectLeadersRequestData duplicate() {
        ElectLeadersRequestData _duplicate = new ElectLeadersRequestData();
        _duplicate.electionType = this.electionType;
        if (this.topicPartitions == null) {
            _duplicate.topicPartitions = null;
        } else {
            TopicPartitionsCollection newTopicPartitions = new TopicPartitionsCollection(this.topicPartitions.size());
            Iterator iterator = this.topicPartitions.iterator();
            while (iterator.hasNext()) {
                TopicPartitions _element = (TopicPartitions)iterator.next();
                newTopicPartitions.add(_element.duplicate());
            }
            _duplicate.topicPartitions = newTopicPartitions;
        }
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "ElectLeadersRequestData(electionType=" + this.electionType + ", topicPartitions=" + (this.topicPartitions == null ? "null" : MessageUtil.deepToString((Iterator)this.topicPartitions.iterator())) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public byte electionType() {
        return this.electionType;
    }

    public TopicPartitionsCollection topicPartitions() {
        return this.topicPartitions;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ElectLeadersRequestData setElectionType(byte v) {
        this.electionType = v;
        return this;
    }

    public ElectLeadersRequestData setTopicPartitions(TopicPartitionsCollection v) {
        this.topicPartitions = v;
        return this;
    }

    public ElectLeadersRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class TopicPartitionsCollection
    extends ImplicitLinkedHashMultiCollection<TopicPartitions> {
        public TopicPartitionsCollection() {
        }

        public TopicPartitionsCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicPartitionsCollection(Iterator<TopicPartitions> iterator) {
            super(iterator);
        }

        public TopicPartitions find(String topic) {
            TopicPartitions _key = new TopicPartitions();
            _key.setTopic(topic);
            return (TopicPartitions)this.find(_key);
        }

        public List<TopicPartitions> findAll(String topic) {
            TopicPartitions _key = new TopicPartitions();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public TopicPartitionsCollection duplicate() {
            TopicPartitionsCollection _duplicate = new TopicPartitionsCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TopicPartitions _element = (TopicPartitions)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TopicPartitions
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public TopicPartitions() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartitions");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topic);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
            } else {
                _writable.writeInt(this.partitions.size());
            }
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartitions");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The name of a topic."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partitions of this topic whose leader should be elected.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "The name of a topic."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partitions of this topic whose leader should be elected."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

