/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Map;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UpdateFeaturesResponseTest {
    @Test
    public void testErrorCounts() {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        results.add(new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("foo").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()));
        results.add(new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("bar").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()));
        results.add(new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("baz").setErrorCode(Errors.FEATURE_UPDATE_FAILED.code()));
        UpdateFeaturesResponse response = new UpdateFeaturesResponse(new UpdateFeaturesResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setResults(results));
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)3, (int)errorCounts.size());
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.INVALID_REQUEST)));
        Assertions.assertEquals((int)2, (int)((Integer)errorCounts.get(Errors.UNKNOWN_SERVER_ERROR)));
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.FEATURE_UPDATE_FAILED)));
    }
}

