/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PartitionLeaderStrategyTest {
    private PartitionLeaderStrategy newStrategy() {
        return new PartitionLeaderStrategy(new LogContext());
    }

    @Test
    public void testBuildLookupRequest() {
        Set topicPartitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0), new TopicPartition("foo", 1), new TopicPartition("baz", 0)});
        PartitionLeaderStrategy strategy = this.newStrategy();
        MetadataRequest allRequest = (MetadataRequest)strategy.buildRequest(topicPartitions).build();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar", "baz"}), new HashSet(allRequest.topics()));
        Assertions.assertFalse((boolean)allRequest.allowAutoTopicCreation());
        MetadataRequest partialRequest = (MetadataRequest)strategy.buildRequest(topicPartitions.stream().filter(tp -> tp.topic().equals("foo")).collect(Collectors.toSet())).build();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), new HashSet(partialRequest.topics()));
        Assertions.assertFalse((boolean)partialRequest.allowAutoTopicCreation());
    }

    @Test
    public void testTopicAuthorizationFailure() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Throwable exception = this.assertFatalTopicError(topicPartition, Errors.TOPIC_AUTHORIZATION_FAILED);
        Assertions.assertTrue((boolean)(exception instanceof TopicAuthorizationException));
        TopicAuthorizationException authException = (TopicAuthorizationException)exception;
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), (Object)authException.unauthorizedTopics());
    }

    @Test
    public void testInvalidTopicError() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Throwable exception = this.assertFatalTopicError(topicPartition, Errors.INVALID_TOPIC_EXCEPTION);
        Assertions.assertTrue((boolean)(exception instanceof InvalidTopicException));
        InvalidTopicException invalidTopicException = (InvalidTopicException)exception;
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), (Object)invalidTopicException.invalidTopics());
    }

    @Test
    public void testUnexpectedTopicErrror() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Throwable exception = this.assertFatalTopicError(topicPartition, Errors.UNKNOWN_SERVER_ERROR);
        Assertions.assertTrue((boolean)(exception instanceof UnknownServerException));
    }

    @Test
    public void testRetriableTopicErrors() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.assertRetriableTopicError(topicPartition, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.assertRetriableTopicError(topicPartition, Errors.LEADER_NOT_AVAILABLE);
        this.assertRetriableTopicError(topicPartition, Errors.BROKER_NOT_AVAILABLE);
    }

    @Test
    public void testRetriablePartitionErrors() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        this.assertRetriablePartitionError(topicPartition, Errors.NOT_LEADER_OR_FOLLOWER);
        this.assertRetriablePartitionError(topicPartition, Errors.REPLICA_NOT_AVAILABLE);
        this.assertRetriablePartitionError(topicPartition, Errors.LEADER_NOT_AVAILABLE);
        this.assertRetriablePartitionError(topicPartition, Errors.BROKER_NOT_AVAILABLE);
        this.assertRetriablePartitionError(topicPartition, Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void testUnexpectedPartitionError() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Throwable exception = this.assertFatalPartitionError(topicPartition, Errors.UNKNOWN_SERVER_ERROR);
        Assertions.assertTrue((boolean)(exception instanceof UnknownServerException));
    }

    @Test
    public void testPartitionSuccessfullyMapped() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("bar", 1);
        HashMap<TopicPartition, MetadataResponseData.MetadataResponsePartition> responsePartitions = new HashMap<TopicPartition, MetadataResponseData.MetadataResponsePartition>(2);
        responsePartitions.put(topicPartition1, this.partitionResponseDataWithLeader(topicPartition1, 5, Arrays.asList(5, 6, 7)));
        responsePartitions.put(topicPartition2, this.partitionResponseDataWithLeader(topicPartition2, 1, Arrays.asList(2, 1, 3)));
        AdminApiLookupStrategy.LookupResult<TopicPartition> result = this.handleLookupResponse(Utils.mkSet((Object[])new TopicPartition[]{topicPartition1, topicPartition2}), this.responseWithPartitionData(responsePartitions));
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{topicPartition1, topicPartition2}), result.mappedKeys.keySet());
        Assertions.assertEquals((int)5, (Integer)((Integer)result.mappedKeys.get(topicPartition1)));
        Assertions.assertEquals((int)1, (Integer)((Integer)result.mappedKeys.get(topicPartition2)));
    }

    @Test
    public void testIgnoreUnrequestedPartitions() {
        TopicPartition requestedTopicPartition = new TopicPartition("foo", 0);
        TopicPartition unrequestedTopicPartition = new TopicPartition("foo", 1);
        HashMap<TopicPartition, MetadataResponseData.MetadataResponsePartition> responsePartitions = new HashMap<TopicPartition, MetadataResponseData.MetadataResponsePartition>(2);
        responsePartitions.put(requestedTopicPartition, this.partitionResponseDataWithLeader(requestedTopicPartition, 5, Arrays.asList(5, 6, 7)));
        responsePartitions.put(unrequestedTopicPartition, this.partitionResponseDataWithError(unrequestedTopicPartition, Errors.UNKNOWN_SERVER_ERROR));
        AdminApiLookupStrategy.LookupResult<TopicPartition> result = this.handleLookupResponse(Utils.mkSet((Object[])new TopicPartition[]{requestedTopicPartition}), this.responseWithPartitionData(responsePartitions));
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{requestedTopicPartition}), result.mappedKeys.keySet());
        Assertions.assertEquals((int)5, (Integer)((Integer)result.mappedKeys.get(requestedTopicPartition)));
    }

    @Test
    public void testRetryIfLeaderUnknown() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Map<TopicPartition, MetadataResponseData.MetadataResponsePartition> responsePartitions = Collections.singletonMap(topicPartition, this.partitionResponseDataWithLeader(topicPartition, -1, Arrays.asList(5, 6, 7)));
        AdminApiLookupStrategy.LookupResult<TopicPartition> result = this.handleLookupResponse(Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), this.responseWithPartitionData(responsePartitions));
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.mappedKeys);
    }

    private void assertRetriableTopicError(TopicPartition topicPartition, Errors error) {
        this.assertRetriableError(topicPartition, this.responseWithTopicError(topicPartition.topic(), error));
    }

    private void assertRetriablePartitionError(TopicPartition topicPartition, Errors error) {
        MetadataResponse response = this.responseWithPartitionData(Collections.singletonMap(topicPartition, this.partitionResponseDataWithError(topicPartition, error)));
        this.assertRetriableError(topicPartition, response);
    }

    private Throwable assertFatalTopicError(TopicPartition topicPartition, Errors error) {
        return this.assertFatalError(topicPartition, this.responseWithTopicError(topicPartition.topic(), error));
    }

    private Throwable assertFatalPartitionError(TopicPartition topicPartition, Errors error) {
        MetadataResponse response = this.responseWithPartitionData(Collections.singletonMap(topicPartition, this.partitionResponseDataWithError(topicPartition, error)));
        return this.assertFatalError(topicPartition, response);
    }

    private void assertRetriableError(TopicPartition topicPartition, MetadataResponse response) {
        AdminApiLookupStrategy.LookupResult<TopicPartition> result = this.handleLookupResponse(Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), response);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.mappedKeys);
    }

    private Throwable assertFatalError(TopicPartition topicPartition, MetadataResponse response) {
        AdminApiLookupStrategy.LookupResult<TopicPartition> result = this.handleLookupResponse(Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), response);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), result.failedKeys.keySet());
        return (Throwable)result.failedKeys.get(topicPartition);
    }

    private AdminApiLookupStrategy.LookupResult<TopicPartition> handleLookupResponse(Set<TopicPartition> topicPartitions, MetadataResponse response) {
        PartitionLeaderStrategy strategy = this.newStrategy();
        return strategy.handleResponse(topicPartitions, (AbstractResponse)response);
    }

    private MetadataResponse responseWithTopicError(String topic, Errors error) {
        MetadataResponseData.MetadataResponseTopic responseTopic = new MetadataResponseData.MetadataResponseTopic().setName(topic).setErrorCode(error.code());
        MetadataResponseData responseData = new MetadataResponseData();
        responseData.topics().add(responseTopic);
        return new MetadataResponse(responseData, ApiKeys.METADATA.latestVersion());
    }

    private MetadataResponseData.MetadataResponsePartition partitionResponseDataWithError(TopicPartition topicPartition, Errors error) {
        return new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code());
    }

    private MetadataResponseData.MetadataResponsePartition partitionResponseDataWithLeader(TopicPartition topicPartition, Integer leaderId, List<Integer> replicas) {
        return new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderId(leaderId).setReplicaNodes(replicas).setIsrNodes(replicas);
    }

    private MetadataResponse responseWithPartitionData(Map<TopicPartition, MetadataResponseData.MetadataResponsePartition> responsePartitions) {
        MetadataResponseData responseData = new MetadataResponseData();
        for (Map.Entry<TopicPartition, MetadataResponseData.MetadataResponsePartition> entry : responsePartitions.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            MetadataResponseData.MetadataResponseTopic responseTopic = responseData.topics().find(topicPartition.topic());
            if (responseTopic == null) {
                responseTopic = new MetadataResponseData.MetadataResponseTopic().setName(topicPartition.topic()).setErrorCode(Errors.NONE.code());
                responseData.topics().add(responseTopic);
            }
            responseTopic.partitions().add(entry.getValue());
        }
        return new MetadataResponse(responseData, ApiKeys.METADATA.latestVersion());
    }
}

