/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetrieverFactory;
import org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccessTokenRetrieverFactoryTest
extends OAuthBearerTest {
    @Test
    public void testConfigureRefreshingFileAccessTokenRetriever() throws Exception {
        String expected = "{}";
        File tmpDir = this.createTempDir("access-token");
        File accessTokenFile = this.createTempFile(tmpDir, "access-token-", ".json", expected);
        Map<String, String> configs = Collections.singletonMap("sasl.oauthbearer.token.endpoint.url", accessTokenFile.toURI().toString());
        Map jaasConfig = Collections.emptyMap();
        try (AccessTokenRetriever accessTokenRetriever = AccessTokenRetrieverFactory.create(configs, jaasConfig);){
            accessTokenRetriever.init();
            Assertions.assertEquals((Object)expected, (Object)accessTokenRetriever.retrieve());
        }
    }

    @Test
    public void testConfigureRefreshingFileAccessTokenRetrieverWithInvalidDirectory() {
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", new File("/tmp/this-directory-does-not-exist/foo.json").toURI().toString());
        Map jaasConfig = Collections.emptyMap();
        this.assertThrowsWithMessage(ConfigException.class, () -> AccessTokenRetrieverFactory.create((Map)configs, (Map)jaasConfig), "that doesn't exist");
    }

    @Test
    public void testConfigureRefreshingFileAccessTokenRetrieverWithInvalidFile() throws Exception {
        File tmpDir = this.createTempDir("this-directory-does-exist");
        File accessTokenFile = new File(tmpDir, "this-file-does-not-exist.json");
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", accessTokenFile.toURI().toString());
        Map jaasConfig = Collections.emptyMap();
        this.assertThrowsWithMessage(ConfigException.class, () -> AccessTokenRetrieverFactory.create((Map)configs, (Map)jaasConfig), "that doesn't exist");
    }
}

