/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.security.Key;
import java.util.Collection;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class AccessTokenBuilder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String audience;
    private String subject = "jdoe";
    private String subjectClaimName = "sub";
    private Object scope = "engineering";
    private String scopeClaimName = "scope";
    private Long issuedAtSeconds;
    private Long expirationSeconds;
    private RsaJsonWebKey jwk;

    public AccessTokenBuilder() throws JoseException {
        this(new MockTime());
    }

    public AccessTokenBuilder(Time time) throws JoseException {
        this.issuedAtSeconds = time.milliseconds() / 1000L;
        this.expirationSeconds = this.issuedAtSeconds + 60L;
        this.jwk = AccessTokenBuilder.createJwk();
    }

    public static RsaJsonWebKey createJwk() throws JoseException {
        RsaJsonWebKey jwk = RsaJwkGenerator.generateJwk((int)2048);
        jwk.setKeyId("key-1");
        return jwk;
    }

    public String audience() {
        return this.audience;
    }

    public AccessTokenBuilder audience(String audience) {
        this.audience = audience;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public AccessTokenBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public String subjectClaimName() {
        return this.subjectClaimName;
    }

    public AccessTokenBuilder subjectClaimName(String subjectClaimName) {
        this.subjectClaimName = subjectClaimName;
        return this;
    }

    public Object scope() {
        return this.scope;
    }

    public AccessTokenBuilder scope(Object scope) {
        this.scope = scope;
        if (scope instanceof String) {
            return this;
        }
        if (scope instanceof Collection) {
            return this;
        }
        throw new IllegalArgumentException(String.format("%s parameter must be a %s or a %s containing %s", this.scopeClaimName, String.class.getName(), Collection.class.getName(), String.class.getName()));
    }

    public String scopeClaimName() {
        return this.scopeClaimName;
    }

    public AccessTokenBuilder scopeClaimName(String scopeClaimName) {
        this.scopeClaimName = scopeClaimName;
        return this;
    }

    public Long issuedAtSeconds() {
        return this.issuedAtSeconds;
    }

    public AccessTokenBuilder issuedAtSeconds(Long issuedAtSeconds) {
        this.issuedAtSeconds = issuedAtSeconds;
        return this;
    }

    public Long expirationSeconds() {
        return this.expirationSeconds;
    }

    public AccessTokenBuilder expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    public RsaJsonWebKey jwk() {
        return this.jwk;
    }

    public AccessTokenBuilder jwk(RsaJsonWebKey jwk) {
        this.jwk = jwk;
        return this;
    }

    public String build() throws JoseException, IOException {
        ObjectNode node = this.objectMapper.createObjectNode();
        if (this.audience != null) {
            node.put("aud", this.audience);
        }
        if (this.subject != null) {
            node.put(this.subjectClaimName, this.subject);
        }
        if (this.scope instanceof String) {
            node.put(this.scopeClaimName, (String)this.scope);
        } else if (this.scope instanceof Collection) {
            ArrayNode child = node.putArray(this.scopeClaimName);
            ((Collection)this.scope).forEach(arg_0 -> ((ArrayNode)child).add(arg_0));
        } else {
            throw new IllegalArgumentException(String.format("%s claim must be a %s or a %s containing %s", this.scopeClaimName, String.class.getName(), Collection.class.getName(), String.class.getName()));
        }
        if (this.issuedAtSeconds != null) {
            node.put("iat", this.issuedAtSeconds);
        }
        if (this.expirationSeconds != null) {
            node.put("exp", this.expirationSeconds);
        }
        String json = this.objectMapper.writeValueAsString((Object)node);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(json);
        jws.setKey((Key)this.jwk.getPrivateKey());
        jws.setKeyIdHeaderValue(this.jwk.getKeyId());
        jws.setAlgorithmHeaderValue("RS256");
        return jws.getCompactSerialization();
    }
}

