/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.resource;

import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceFilterTest {
    @Test
    public void shouldNotMatchIfDifferentResourceType() {
        Assertions.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.GROUP, "Name")));
    }

    @Test
    public void shouldNotMatchIfDifferentName() {
        Assertions.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Different").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldNotMatchIfDifferentNameCase() {
        Assertions.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "NAME").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWhereResourceTypeIsAny() {
        Assertions.assertTrue((boolean)new ResourceFilter(ResourceType.ANY, "Name").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWhereResourceNameIsAny() {
        Assertions.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, null).matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchIfExactMatch() {
        Assertions.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.TOPIC, "Name")));
    }

    @Test
    public void shouldMatchWildcardIfExactMatch() {
        Assertions.assertTrue((boolean)new ResourceFilter(ResourceType.TOPIC, "*").matches(new Resource(ResourceType.TOPIC, "*")));
    }

    @Test
    public void shouldNotMatchWildcardAgainstOtherName() {
        Assertions.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "Name").matches(new Resource(ResourceType.TOPIC, "*")));
    }

    @Test
    public void shouldNotMatchLiteralWildcardTheWayAround() {
        Assertions.assertFalse((boolean)new ResourceFilter(ResourceType.TOPIC, "*").matches(new Resource(ResourceType.TOPIC, "Name")));
    }
}

