/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndTxnResponseTest {
    @Test
    public void testConstructor() {
        int throttleTimeMs = 10;
        EndTxnResponseData data = new EndTxnResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(throttleTimeMs);
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        for (short version = 0; version <= ApiKeys.END_TXN.latestVersion(); version = (short)(version + 1)) {
            EndTxnResponse response = new EndTxnResponse(data);
            Assertions.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
            response = EndTxnResponse.parse((ByteBuffer)response.serialize(version), (short)version);
            Assertions.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

