/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class BrokerHeartbeatRequestData
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    long currentMetadataOffset;
    boolean wantFence;
    boolean wantShutDown;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker ID."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch."), new Field("current_metadata_offset", (Type)Type.INT64, "The highest metadata offset which the broker has reached."), new Field("want_fence", (Type)Type.BOOLEAN, "True if the broker wants to be fenced, false otherwise."), new Field("want_shut_down", (Type)Type.BOOLEAN, "True if the broker wants to be shut down, false otherwise."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public BrokerHeartbeatRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BrokerHeartbeatRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
        this.currentMetadataOffset = 0L;
        this.wantFence = false;
        this.wantShutDown = false;
    }

    public short apiKey() {
        return 63;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        this.currentMetadataOffset = _readable.readLong();
        this.wantFence = _readable.readByte() != 0;
        this.wantShutDown = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeLong(this.currentMetadataOffset);
        _writable.writeByte(this.wantFence ? (byte)1 : 0);
        _writable.writeByte(this.wantShutDown ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(1);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerHeartbeatRequestData)) {
            return false;
        }
        BrokerHeartbeatRequestData other = (BrokerHeartbeatRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.currentMetadataOffset != other.currentMetadataOffset) {
            return false;
        }
        if (this.wantFence != other.wantFence) {
            return false;
        }
        if (this.wantShutDown != other.wantShutDown) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + ((int)(this.currentMetadataOffset >> 32) ^ (int)this.currentMetadataOffset);
        hashCode = 31 * hashCode + (this.wantFence ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.wantShutDown ? 1231 : 1237);
        return hashCode;
    }

    public BrokerHeartbeatRequestData duplicate() {
        BrokerHeartbeatRequestData _duplicate = new BrokerHeartbeatRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.currentMetadataOffset = this.currentMetadataOffset;
        _duplicate.wantFence = this.wantFence;
        _duplicate.wantShutDown = this.wantShutDown;
        return _duplicate;
    }

    public String toString() {
        return "BrokerHeartbeatRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", currentMetadataOffset=" + this.currentMetadataOffset + ", wantFence=" + (this.wantFence ? "true" : "false") + ", wantShutDown=" + (this.wantShutDown ? "true" : "false") + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public long currentMetadataOffset() {
        return this.currentMetadataOffset;
    }

    public boolean wantFence() {
        return this.wantFence;
    }

    public boolean wantShutDown() {
        return this.wantShutDown;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerHeartbeatRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public BrokerHeartbeatRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public BrokerHeartbeatRequestData setCurrentMetadataOffset(long v) {
        this.currentMetadataOffset = v;
        return this;
    }

    public BrokerHeartbeatRequestData setWantFence(boolean v) {
        this.wantFence = v;
        return this;
    }

    public BrokerHeartbeatRequestData setWantShutDown(boolean v) {
        this.wantShutDown = v;
        return this;
    }
}

