/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;

public class TypeTest {
    @Test
    public void testEmptyRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.RECORDS.write(buffer, (Object)MemoryRecords.EMPTY);
        buffer.flip();
        Assert.assertEquals((long)4L, (long)Type.RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assert.assertEquals((long)4L, (long)buffer.limit());
        Assert.assertEquals((Object)MemoryRecords.EMPTY, (Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testNullRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.RECORDS.write(buffer, null);
        buffer.flip();
        Assert.assertEquals((long)4L, (long)Type.RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assert.assertEquals((long)4L, (long)buffer.limit());
        Assert.assertNull((Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testRecordsSerde() {
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        ByteBuffer buffer = ByteBuffer.allocate(Type.RECORDS.sizeOf((Object)records));
        Type.RECORDS.write(buffer, (Object)records);
        buffer.flip();
        Assert.assertEquals((Object)records, (Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testEmptyCompactRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.COMPACT_RECORDS.write(buffer, (Object)MemoryRecords.EMPTY);
        buffer.flip();
        Assert.assertEquals((long)1L, (long)Type.COMPACT_RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assert.assertEquals((long)1L, (long)buffer.limit());
        Assert.assertEquals((Object)MemoryRecords.EMPTY, (Object)Type.COMPACT_RECORDS.read(buffer));
    }

    @Test
    public void testNullCompactRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.COMPACT_RECORDS.write(buffer, null);
        buffer.flip();
        Assert.assertEquals((long)1L, (long)Type.COMPACT_RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assert.assertEquals((long)1L, (long)buffer.limit());
        Assert.assertNull((Object)Type.COMPACT_RECORDS.read(buffer));
    }

    @Test
    public void testCompactRecordsSerde() {
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        ByteBuffer buffer = ByteBuffer.allocate(Type.COMPACT_RECORDS.sizeOf((Object)records));
        Type.COMPACT_RECORDS.write(buffer, (Object)records);
        buffer.flip();
        Assert.assertEquals((Object)records, (Object)Type.COMPACT_RECORDS.read(buffer));
    }
}

