/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ClusterTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(2, "localhost", 101), new Node(11, "localhost", 102)};
    private static final String TOPIC_A = "topicA";
    private static final String TOPIC_B = "topicB";
    private static final String TOPIC_C = "topicC";
    private static final String TOPIC_D = "topicD";
    private static final String TOPIC_E = "topicE";

    @Test
    public void testBootstrap() {
        String ipAddress = "140.211.11.105";
        String hostName = "www.example.com";
        Cluster cluster = Cluster.bootstrap(Arrays.asList(new InetSocketAddress(ipAddress, 9002), new InetSocketAddress(hostName, 9002)));
        Set expectedHosts = Utils.mkSet((Object[])new String[]{ipAddress, hostName});
        HashSet<String> actualHosts = new HashSet<String>();
        for (Node node : cluster.nodes()) {
            actualHosts.add(node.host());
        }
        Assert.assertEquals((Object)expectedHosts, actualHosts);
    }

    @Test
    public void testReturnUnmodifiableCollections() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, null, NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[2], NODES, NODES), new PartitionInfo(TOPIC_B, 0, null, NODES, NODES), new PartitionInfo(TOPIC_B, 1, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_C, 0, null, NODES, NODES), new PartitionInfo(TOPIC_D, 0, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_E, 0, NODES[0], NODES, NODES));
        Set unauthorizedTopics = Utils.mkSet((Object[])new String[]{TOPIC_C});
        Set invalidTopics = Utils.mkSet((Object[])new String[]{TOPIC_D});
        Set internalTopics = Utils.mkSet((Object[])new String[]{TOPIC_E});
        Cluster cluster = new Cluster("clusterId", Arrays.asList(NODES), allPartitions, unauthorizedTopics, invalidTopics, internalTopics, NODES[1]);
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.invalidTopics().add("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.internalTopics().add("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.unauthorizedTopics().add("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.topics().add("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.nodes().add(NODES[3]));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.partitionsForTopic(TOPIC_A).add(new PartitionInfo(TOPIC_A, 3, NODES[0], NODES, NODES)));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.availablePartitionsForTopic(TOPIC_B).add(new PartitionInfo(TOPIC_B, 2, NODES[0], NODES, NODES)));
        Assert.assertThrows(UnsupportedOperationException.class, () -> cluster.partitionsForNode(NODES[1].id()).add(new PartitionInfo(TOPIC_B, 2, NODES[1], NODES, NODES)));
    }
}

