/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveMembersFromConsumerGroupResultTest {
    private final MemberToRemove instanceOne = new MemberToRemove("instance-1");
    private final MemberToRemove instanceTwo = new MemberToRemove("instance-2");
    private Set<MemberToRemove> membersToRemove;
    private Map<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap;
    private KafkaFutureImpl<Map<LeaveGroupRequestData.MemberIdentity, Errors>> memberFutures;

    @Before
    public void setUp() {
        this.memberFutures = new KafkaFutureImpl();
        this.membersToRemove = new HashSet<MemberToRemove>();
        this.membersToRemove.add(this.instanceOne);
        this.membersToRemove.add(this.instanceTwo);
        this.errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        this.errorsMap.put(this.instanceOne.toMemberIdentity(), Errors.NONE);
        this.errorsMap.put(this.instanceTwo.toMemberIdentity(), Errors.FENCED_INSTANCE_ID);
    }

    @Test
    public void testTopLevelErrorConstructor() throws InterruptedException {
        this.memberFutures.completeExceptionally((Throwable)Errors.GROUP_AUTHORIZATION_FAILED.exception());
        RemoveMembersFromConsumerGroupResult topLevelErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureError(topLevelErrorResult.all(), GroupAuthorizationException.class);
    }

    @Test
    public void testMemberLevelErrorConstructor() throws InterruptedException, ExecutionException {
        this.createAndVerifyMemberLevelError();
    }

    @Test
    public void testMemberMissingErrorInRequestConstructor() throws InterruptedException, ExecutionException {
        this.errorsMap.remove(this.instanceTwo.toMemberIdentity());
        this.memberFutures.complete(this.errorsMap);
        Assert.assertFalse((boolean)this.memberFutures.isCompletedExceptionally());
        RemoveMembersFromConsumerGroupResult missingMemberResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureError(missingMemberResult.all(), IllegalArgumentException.class);
        Assert.assertNull((Object)missingMemberResult.memberResult(this.instanceOne).get());
        TestUtils.assertFutureError(missingMemberResult.memberResult(this.instanceTwo), IllegalArgumentException.class);
    }

    @Test
    public void testMemberLevelErrorInResponseConstructor() throws InterruptedException, ExecutionException {
        RemoveMembersFromConsumerGroupResult memberLevelErrorResult = this.createAndVerifyMemberLevelError();
        Assert.assertThrows(IllegalArgumentException.class, () -> memberLevelErrorResult.memberResult(new MemberToRemove("invalid-instance-id")));
    }

    @Test
    public void testNoErrorConstructor() throws ExecutionException, InterruptedException {
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(this.instanceOne.toMemberIdentity(), Errors.NONE);
        errorsMap.put(this.instanceTwo.toMemberIdentity(), Errors.NONE);
        RemoveMembersFromConsumerGroupResult noErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        this.memberFutures.complete(errorsMap);
        Assert.assertNull((Object)noErrorResult.all().get());
        Assert.assertNull((Object)noErrorResult.memberResult(this.instanceOne).get());
        Assert.assertNull((Object)noErrorResult.memberResult(this.instanceTwo).get());
    }

    private RemoveMembersFromConsumerGroupResult createAndVerifyMemberLevelError() throws InterruptedException, ExecutionException {
        this.memberFutures.complete(this.errorsMap);
        Assert.assertFalse((boolean)this.memberFutures.isCompletedExceptionally());
        RemoveMembersFromConsumerGroupResult memberLevelErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureError(memberLevelErrorResult.all(), FencedInstanceIdException.class);
        Assert.assertNull((Object)memberLevelErrorResult.memberResult(this.instanceOne).get());
        TestUtils.assertFutureError(memberLevelErrorResult.memberResult(this.instanceTwo), FencedInstanceIdException.class);
        return memberLevelErrorResult;
    }
}

