/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.memory.GarbageCollectedMemoryPool;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class GarbageCollectedMemoryPoolTest {
    @Test(expected=IllegalArgumentException.class)
    public void testZeroSize() throws Exception {
        new GarbageCollectedMemoryPool(0L, 7, true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeSize() throws Exception {
        new GarbageCollectedMemoryPool(-1L, 7, false, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroMaxAllocation() throws Exception {
        new GarbageCollectedMemoryPool(100L, 0, true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeMaxAllocation() throws Exception {
        new GarbageCollectedMemoryPool(100L, -1, false, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxAllocationLargerThanSize() throws Exception {
        new GarbageCollectedMemoryPool(100L, 101, true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllocationOverMaxAllocation() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        pool.tryAllocate(11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllocationZero() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        pool.tryAllocate(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllocationNegative() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        pool.tryAllocate(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReleaseNull() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        pool.release(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReleaseForeignBuffer() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        ByteBuffer fellOffATruck = ByteBuffer.allocate(1);
        pool.release(fellOffATruck);
    }

    @Test
    public void testDoubleFree() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        ByteBuffer buffer = pool.tryAllocate(5);
        Assert.assertNotNull((Object)buffer);
        pool.release(buffer);
        try {
            pool.release(buffer);
            Assert.fail((String)"2nd release() should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            Assert.fail((String)("expected an IllegalArgumentException. instead got " + t));
        }
    }

    @Test
    public void testAllocationBound() throws Exception {
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(21L, 10, false, null);
        ByteBuffer buf1 = pool.tryAllocate(10);
        Assert.assertNotNull((Object)buf1);
        Assert.assertEquals((long)10L, (long)buf1.capacity());
        ByteBuffer buf2 = pool.tryAllocate(10);
        Assert.assertNotNull((Object)buf2);
        Assert.assertEquals((long)10L, (long)buf2.capacity());
        ByteBuffer buf3 = pool.tryAllocate(10);
        Assert.assertNotNull((Object)buf3);
        Assert.assertEquals((long)10L, (long)buf3.capacity());
        Assert.assertNull((Object)pool.tryAllocate(1));
        pool.release(buf3);
        ByteBuffer buf4 = pool.tryAllocate(10);
        Assert.assertNotNull((Object)buf4);
        Assert.assertEquals((long)10L, (long)buf4.capacity());
        Assert.assertNull((Object)pool.tryAllocate(1));
    }

    @Test
    public void testBuffersGarbageCollected() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long maxHeap = runtime.maxMemory();
        long maxPool = maxHeap / 2L;
        long maxSingleAllocation = maxPool / 10L;
        Assert.assertTrue((maxSingleAllocation < 0x3FFFFFFFL ? 1 : 0) != 0);
        GarbageCollectedMemoryPool pool = new GarbageCollectedMemoryPool(maxPool, (int)maxSingleAllocation, false, null);
        int timeoutSeconds = 30;
        long giveUp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
        boolean success = false;
        int buffersAllocated = 0;
        while (System.currentTimeMillis() < giveUp) {
            ByteBuffer buffer = pool.tryAllocate((int)maxSingleAllocation);
            if (buffer == null) {
                System.gc();
                Thread.sleep(10L);
                continue;
            }
            if (++buffersAllocated < 30) continue;
            success = true;
            break;
        }
        Assert.assertTrue((String)("failed to allocate 30 buffers in " + timeoutSeconds + " seconds. buffers allocated: " + buffersAllocated + " heap " + Utils.formatBytes((long)maxHeap) + " pool " + Utils.formatBytes((long)maxPool) + " single allocation " + Utils.formatBytes((long)maxSingleAllocation)), (boolean)success);
    }
}

