/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DeleteRecordsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private DeleteRecordsTopicResultCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DeleteRecordsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteRecordsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DeleteRecordsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new DeleteRecordsTopicResultCollection(0);
    }

    public short apiKey() {
        return 21;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int i;
        DeleteRecordsTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new DeleteRecordsTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteRecordsTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new DeleteRecordsTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteRecordsTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsTopicResult topicsElement = (DeleteRecordsTopicResult)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsTopicResult topicsElement = (DeleteRecordsTopicResult)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new DeleteRecordsTopicResultCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new DeleteRecordsTopicResult((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            DeleteRecordsTopicResult element = (DeleteRecordsTopicResult)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            DeleteRecordsTopicResult topicsElement = (DeleteRecordsTopicResult)iterator.next();
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteRecordsResponseData)) {
            return false;
        }
        DeleteRecordsResponseData other = (DeleteRecordsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public DeleteRecordsResponseData duplicate() {
        DeleteRecordsResponseData _duplicate = new DeleteRecordsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        DeleteRecordsTopicResultCollection newTopics = new DeleteRecordsTopicResultCollection(this.topics.size());
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            DeleteRecordsTopicResult _element = (DeleteRecordsTopicResult)iterator.next();
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "DeleteRecordsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeleteRecordsTopicResultCollection topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteRecordsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteRecordsResponseData setTopics(DeleteRecordsTopicResultCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)DeleteRecordsTopicResult.SCHEMA_0), "Each topic that we wanted to delete records from.")});
        SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new CompactArrayOf((Type)DeleteRecordsTopicResult.SCHEMA_2), "Each topic that we wanted to delete records from."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DeleteRecordsTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<DeleteRecordsTopicResult> {
        public DeleteRecordsTopicResultCollection() {
        }

        public DeleteRecordsTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeleteRecordsTopicResultCollection(Iterator<DeleteRecordsTopicResult> iterator) {
            super(iterator);
        }

        public DeleteRecordsTopicResult find(String name) {
            DeleteRecordsTopicResult _key = new DeleteRecordsTopicResult();
            _key.setName(name);
            return (DeleteRecordsTopicResult)this.find(_key);
        }

        public List<DeleteRecordsTopicResult> findAll(String name) {
            DeleteRecordsTopicResult _key = new DeleteRecordsTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public DeleteRecordsTopicResultCollection duplicate() {
            DeleteRecordsTopicResultCollection _duplicate = new DeleteRecordsTopicResultCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsTopicResult _element = (DeleteRecordsTopicResult)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class DeleteRecordsPartitionResultCollection
    extends ImplicitLinkedHashMultiCollection<DeleteRecordsPartitionResult> {
        public DeleteRecordsPartitionResultCollection() {
        }

        public DeleteRecordsPartitionResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeleteRecordsPartitionResultCollection(Iterator<DeleteRecordsPartitionResult> iterator) {
            super(iterator);
        }

        public DeleteRecordsPartitionResult find(int partitionIndex) {
            DeleteRecordsPartitionResult _key = new DeleteRecordsPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return (DeleteRecordsPartitionResult)this.find(_key);
        }

        public List<DeleteRecordsPartitionResult> findAll(int partitionIndex) {
            DeleteRecordsPartitionResult _key = new DeleteRecordsPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public DeleteRecordsPartitionResultCollection duplicate() {
            DeleteRecordsPartitionResultCollection _duplicate = new DeleteRecordsPartitionResultCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsPartitionResult _element = (DeleteRecordsPartitionResult)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class DeleteRecordsPartitionResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private int partitionIndex;
        private long lowWatermark;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsPartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeleteRecordsPartitionResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeleteRecordsPartitionResult() {
            this.partitionIndex = 0;
            this.lowWatermark = 0L;
            this.errorCode = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsPartitionResult");
            }
            this.partitionIndex = _readable.readInt();
            this.lowWatermark = _readable.readLong();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.lowWatermark);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsPartitionResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionIndex = struct.getInt("partition_index");
            this.lowWatermark = struct.getLong("low_watermark");
            this.errorCode = struct.getShort("error_code");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsPartitionResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("low_watermark", (Object)this.lowWatermark);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteRecordsPartitionResult");
            }
            _size += 4;
            _size += 8;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DeleteRecordsPartitionResult)) {
                return false;
            }
            DeleteRecordsPartitionResult other = (DeleteRecordsPartitionResult)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsPartitionResult)) {
                return false;
            }
            DeleteRecordsPartitionResult other = (DeleteRecordsPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.lowWatermark != other.lowWatermark) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public DeleteRecordsPartitionResult duplicate() {
            DeleteRecordsPartitionResult _duplicate = new DeleteRecordsPartitionResult();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.lowWatermark = this.lowWatermark;
            _duplicate.errorCode = this.errorCode;
            return _duplicate;
        }

        public String toString() {
            return "DeleteRecordsPartitionResult(partitionIndex=" + this.partitionIndex + ", lowWatermark=" + this.lowWatermark + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long lowWatermark() {
            return this.lowWatermark;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteRecordsPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DeleteRecordsPartitionResult setLowWatermark(long v) {
            this.lowWatermark = v;
            return this;
        }

        public DeleteRecordsPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("low_watermark", (Type)Type.INT64, "The partition low water mark."), new Field("error_code", (Type)Type.INT16, "The deletion error code, or 0 if the deletion succeeded.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("low_watermark", (Type)Type.INT64, "The partition low water mark."), new Field("error_code", (Type)Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DeleteRecordsTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private DeleteRecordsPartitionResultCollection partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeleteRecordsTopicResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeleteRecordsTopicResult() {
            this.name = "";
            this.partitions = new DeleteRecordsPartitionResultCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            int i;
            DeleteRecordsPartitionResultCollection newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsTopicResult");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new DeleteRecordsPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DeleteRecordsPartitionResult(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new DeleteRecordsPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DeleteRecordsPartitionResult(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DeleteRecordsPartitionResult partitionsElement = (DeleteRecordsPartitionResult)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    DeleteRecordsPartitionResult partitionsElement = (DeleteRecordsPartitionResult)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsTopicResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new DeleteRecordsPartitionResultCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new DeleteRecordsPartitionResult((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsTopicResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            Iterator iterator = this.partitions.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsPartitionResult element = (DeleteRecordsPartitionResult)iterator.next();
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteRecordsTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1))) : (_arraySize += 4);
            Iterator iterator = this.partitions.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsPartitionResult partitionsElement = (DeleteRecordsPartitionResult)iterator.next();
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DeleteRecordsTopicResult)) {
                return false;
            }
            DeleteRecordsTopicResult other = (DeleteRecordsTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsTopicResult)) {
                return false;
            }
            DeleteRecordsTopicResult other = (DeleteRecordsTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals((Object)other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public DeleteRecordsTopicResult duplicate() {
            DeleteRecordsTopicResult _duplicate = new DeleteRecordsTopicResult();
            _duplicate.name = this.name;
            DeleteRecordsPartitionResultCollection newPartitions = new DeleteRecordsPartitionResultCollection(this.partitions.size());
            Iterator iterator = this.partitions.iterator();
            while (iterator.hasNext()) {
                DeleteRecordsPartitionResult _element = (DeleteRecordsPartitionResult)iterator.next();
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "DeleteRecordsTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString((Iterator)this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public DeleteRecordsPartitionResultCollection partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteRecordsTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public DeleteRecordsTopicResult setPartitions(DeleteRecordsPartitionResultCollection v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)DeleteRecordsPartitionResult.SCHEMA_0), "Each partition that we wanted to delete records from.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partitions", (Type)new CompactArrayOf((Type)DeleteRecordsPartitionResult.SCHEMA_2), "Each partition that we wanted to delete records from."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

