/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public class MockAdminClient
extends AdminClient {
    public static final String DEFAULT_CLUSTER_ID = "I4ZmrWqfT2e-upky_4fdPA";
    private final List<Node> brokers;
    private final Map<String, TopicMetadata> allTopics = new HashMap<String, TopicMetadata>();
    private final String clusterId;
    private Node controller;
    private int timeoutNextRequests = 0;
    private Map<MetricName, Metric> mockMetrics = new HashMap<MetricName, Metric>();

    public MockAdminClient(List<Node> brokers, Node controller) {
        this(brokers, controller, DEFAULT_CLUSTER_ID);
    }

    public MockAdminClient(List<Node> brokers, Node controller, String clusterId) {
        this.brokers = brokers;
        this.controller(controller);
        this.clusterId = clusterId;
    }

    public void controller(Node controller) {
        if (!this.brokers.contains(controller)) {
            throw new IllegalArgumentException("The controller node must be in the list of brokers");
        }
        this.controller = controller;
    }

    public void addTopic(boolean internal, String name, List<TopicPartitionInfo> partitions, Map<String, String> configs) {
        if (this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s was already added.", name));
        }
        List replicas = null;
        for (TopicPartitionInfo partition : partitions) {
            if (!this.brokers.contains(partition.leader())) {
                throw new IllegalArgumentException("Leader broker unknown");
            }
            if (!this.brokers.containsAll(partition.replicas())) {
                throw new IllegalArgumentException("Unknown brokers in replica list");
            }
            if (!this.brokers.containsAll(partition.isr())) {
                throw new IllegalArgumentException("Unknown brokers in isr list");
            }
            if (replicas == null) {
                replicas = partition.replicas();
                continue;
            }
            if (replicas.equals(partition.replicas())) continue;
            throw new IllegalArgumentException("All partitions need to have the same replica nodes.");
        }
        this.allTopics.put(name, new TopicMetadata(internal, partitions, configs));
    }

    public void markTopicForDeletion(String name) {
        if (!this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s did not exist.", name));
        }
        this.allTopics.get((Object)name).markedForDeletion = true;
    }

    public void timeoutNextRequest(int numberOfRequest) {
        this.timeoutNextRequests = numberOfRequest;
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions options) {
        KafkaFutureImpl nodesFuture = new KafkaFutureImpl();
        KafkaFutureImpl controllerFuture = new KafkaFutureImpl();
        KafkaFutureImpl brokerIdFuture = new KafkaFutureImpl();
        KafkaFutureImpl authorizedOperationsFuture = new KafkaFutureImpl();
        if (this.timeoutNextRequests > 0) {
            nodesFuture.completeExceptionally((Throwable)new TimeoutException());
            controllerFuture.completeExceptionally((Throwable)new TimeoutException());
            brokerIdFuture.completeExceptionally((Throwable)new TimeoutException());
            authorizedOperationsFuture.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
        } else {
            nodesFuture.complete(this.brokers);
            controllerFuture.complete((Object)this.controller);
            brokerIdFuture.complete((Object)this.clusterId);
            authorizedOperationsFuture.complete(Collections.emptySet());
        }
        return new DescribeClusterResult((KafkaFuture)nodesFuture, (KafkaFuture)controllerFuture, (KafkaFuture)brokerIdFuture, (KafkaFuture)authorizedOperationsFuture);
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> createTopicResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (NewTopic newTopic : newTopics) {
                String topicName = newTopic.name();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                createTopicResult.put(topicName, future);
            }
            --this.timeoutNextRequests;
            return new CreateTopicsResult(createTopicResult);
        }
        for (NewTopic newTopic : newTopics) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String topicName = newTopic.name();
            if (this.allTopics.containsKey(topicName)) {
                future.completeExceptionally((Throwable)new TopicExistsException(String.format("Topic %s exists already.", topicName)));
                createTopicResult.put(topicName, future);
                continue;
            }
            int replicationFactor = newTopic.replicationFactor();
            if (replicationFactor > this.brokers.size()) {
                throw new IllegalArgumentException(String.format("NewTopic %s cannot have a replication factor of %d that is larger than the number of brokers %s", newTopic, replicationFactor, this.brokers));
            }
            ArrayList<Node> replicas = new ArrayList<Node>(replicationFactor);
            for (int i = 0; i < replicationFactor; ++i) {
                replicas.add(this.brokers.get(i));
            }
            int numberOfPartitions = newTopic.numPartitions();
            ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(numberOfPartitions);
            for (int p = 0; p < numberOfPartitions; ++p) {
                partitions.add(new TopicPartitionInfo(p, this.brokers.get(0), replicas, Collections.emptyList()));
            }
            this.allTopics.put(topicName, new TopicMetadata(false, partitions, newTopic.configs()));
            future.complete(null);
            createTopicResult.put(topicName, future);
        }
        return new CreateTopicsResult(createTopicResult);
    }

    public ListTopicsResult listTopics(ListTopicsOptions options) {
        HashMap<String, TopicListing> topicListings = new HashMap<String, TopicListing>();
        if (this.timeoutNextRequests > 0) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
            return new ListTopicsResult((KafkaFuture)future);
        }
        for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
            String topicName = topicDescription.getKey();
            if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                --topicDescription.getValue().fetchesRemainingUntilVisible;
                continue;
            }
            topicListings.put(topicName, new TopicListing(topicName, topicDescription.getValue().isInternalTopic));
        }
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(topicListings);
        return new ListTopicsResult((KafkaFuture)future);
    }

    public DescribeTopicsResult describeTopics(Collection<String> topicNames, DescribeTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> topicDescriptions = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (String requestedTopic : topicNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                topicDescriptions.put(requestedTopic, future);
            }
            --this.timeoutNextRequests;
            return new DescribeTopicsResult(topicDescriptions);
        }
        for (String requestedTopic : topicNames) {
            for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
                String topicName = topicDescription.getKey();
                if (!topicName.equals(requestedTopic) || topicDescription.getValue().markedForDeletion) continue;
                if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                    --topicDescription.getValue().fetchesRemainingUntilVisible;
                    continue;
                }
                TopicMetadata topicMetadata = topicDescription.getValue();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new TopicDescription(topicName, topicMetadata.isInternalTopic, topicMetadata.partitions, Collections.emptySet()));
                topicDescriptions.put(topicName, future);
                break;
            }
            if (topicDescriptions.containsKey(requestedTopic)) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Topic " + requestedTopic + " not found."));
            topicDescriptions.put(requestedTopic, future);
        }
        return new DescribeTopicsResult(topicDescriptions);
    }

    public DeleteTopicsResult deleteTopics(Collection<String> topicsToDelete, DeleteTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> deleteTopicsResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (String topicName : topicsToDelete) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteTopicsResult.put(topicName, future);
            }
            --this.timeoutNextRequests;
            return new DeleteTopicsResult(deleteTopicsResult);
        }
        for (String topicName : topicsToDelete) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.allTopics.remove(topicName) == null) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s does not exist.", topicName)));
            } else {
                future.complete(null);
            }
            deleteTopicsResult.put(topicName, future);
        }
        return new DeleteTopicsResult(deleteTopicsResult);
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        HashMap deletedRecordsResult = new HashMap();
        if (recordsToDelete.isEmpty()) {
            return new DeleteRecordsResult(deletedRecordsResult);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] hmac, RenewDelegationTokenOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] hmac, ExpireDelegationTokenOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Deprecated
    public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions, ElectPreferredLeadersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions, ElectLeadersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl> configescriptions = new HashMap<ConfigResource, KafkaFutureImpl>();
        for (ConfigResource resource : resources) {
            if (resource.type() == ConfigResource.Type.TOPIC) {
                Map<String, String> configs = this.allTopics.get((Object)resource.name()).configs;
                ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
                for (Map.Entry<String, String> entry : configs.entrySet()) {
                    configEntries.add(new ConfigEntry(entry.getKey(), entry.getValue()));
                }
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new Config(configEntries));
                configescriptions.put(resource, future);
                continue;
            }
            throw new UnsupportedOperationException("Not implemented yet");
        }
        return new DescribeConfigsResult(configescriptions);
    }

    @Deprecated
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments, AlterPartitionReassignmentsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public void close(Duration timeout) {
    }

    public void setMockMetrics(MetricName name, Metric metric) {
        this.mockMetrics.put(name, metric);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.mockMetrics;
    }

    public void setFetchesRemainingUntilVisible(String topicName, int fetchesRemainingUntilVisible) {
        TopicMetadata metadata = this.allTopics.get(topicName);
        if (metadata == null) {
            throw new RuntimeException("No such topic as " + topicName);
        }
        metadata.fetchesRemainingUntilVisible = fetchesRemainingUntilVisible;
    }

    private static final class TopicMetadata {
        final boolean isInternalTopic;
        final List<TopicPartitionInfo> partitions;
        final Map<String, String> configs;
        int fetchesRemainingUntilVisible;
        public boolean markedForDeletion;

        TopicMetadata(boolean isInternalTopic, List<TopicPartitionInfo> partitions, Map<String, String> configs) {
            this.isInternalTopic = isInternalTopic;
            this.partitions = partitions;
            this.configs = configs != null ? configs : Collections.emptyMap();
            this.markedForDeletion = false;
            this.fetchesRemainingUntilVisible = 0;
        }
    }
}

