/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.junit.Assert;
import org.junit.Test;

public class JmxReporterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmxRegistration() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try (Metrics metrics = new Metrics();){
            JmxReporter reporter = new JmxReporter();
            metrics.addReporter((MetricsReporter)reporter);
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("pack.bean1.avg", "grp1"), (MeasurableStat)new Avg());
            sensor.add(metrics.metricName("pack.bean2.total", "grp2"), (MeasurableStat)new CumulativeSum());
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assert.assertEquals((Object)Double.NaN, (Object)server.getAttribute(new ObjectName(":type=grp1"), "pack.bean1.avg"));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=grp2"), "pack.bean2.total"));
            MetricName metricName = metrics.metricName("pack.bean1.avg", "grp1");
            String mBeanName = JmxReporter.getMBeanName((String)"", (MetricName)metricName);
            Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
            metrics.removeMetric(metricName);
            Assert.assertFalse((boolean)reporter.containsMbean(mBeanName));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=grp2"), "pack.bean2.total"));
            metricName = metrics.metricName("pack.bean2.total", "grp2");
            metrics.removeMetric(metricName);
            Assert.assertFalse((boolean)reporter.containsMbean(mBeanName));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp2")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmxRegistrationSanitization() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try (Metrics metrics = new Metrics();){
            metrics.addReporter((MetricsReporter)new JmxReporter());
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo*"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo+"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo?"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo:"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo%"}), (MeasurableStat)new CumulativeSum());
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\*\"")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo\\*\""), "name"));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo+\"")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo+\""), "name"));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\?\"")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo\\?\""), "name"));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo:\"")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo:\""), "name"));
            Assert.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=foo%")));
            Assert.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=foo%"), "name"));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo*"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo+"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo?"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo:"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo%"}));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\*\"")));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=foo+")));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\?\"")));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo:\"")));
            Assert.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=foo%")));
        }
    }
}

