/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;

public final class MessageTestUtil {
    public static int messageSize(Message message, short version) {
        return message.size(new ObjectSerializationCache(), version);
    }

    public static ByteBuffer messageToByteBuffer(Message message, short version) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer bytes = ByteBuffer.allocate(size);
        message.write((Writable)new ByteBufferAccessor(bytes), cache, version);
        bytes.flip();
        return bytes;
    }

    public static void messageFromByteBuffer(ByteBuffer bytes, Message message, short version) {
        message.read((Readable)new ByteBufferAccessor(bytes.duplicate()), version);
    }
}

