/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageTestUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Struct;
import org.junit.Assert;
import org.junit.Test;

public class SimpleExampleMessageTest {
    @Test
    public void shouldStoreField() {
        UUID uuid = UUID.randomUUID();
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        Assert.assertEquals((Object)uuid, (Object)out.processId());
    }

    @Test
    public void shouldDefaultField() {
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        Assert.assertEquals((Object)UUID.fromString("00000000-0000-0000-0000-000000000000"), (Object)out.processId());
    }

    @Test
    public void shouldRoundTripFieldThroughStruct() {
        UUID uuid = UUID.randomUUID();
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        Struct struct = out.toStruct((short)1);
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.fromStruct(struct, (short)1);
        Assert.assertEquals((Object)uuid, (Object)in.processId());
    }

    @Test
    public void shouldRoundTripFieldThroughBuffer() {
        UUID uuid = UUID.randomUUID();
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(out.size(cache, (short)1));
        out.write((Writable)new ByteBufferAccessor(buffer), cache, (short)1);
        buffer.rewind();
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.read((Readable)new ByteBufferAccessor(buffer), (short)1);
        Assert.assertEquals((Object)uuid, (Object)in.processId());
    }

    @Test
    public void shouldImplementJVMMethods() {
        UUID uuid = UUID.randomUUID();
        SimpleExampleMessageData a = new SimpleExampleMessageData();
        a.setProcessId(uuid);
        SimpleExampleMessageData b = new SimpleExampleMessageData();
        b.setProcessId(uuid);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertEquals((Object)a.toString(), (Object)b.toString());
    }

    @Test
    public void testMyTaggedIntArray() {
        SimpleExampleMessageData data = new SimpleExampleMessageData();
        data.setMyTaggedIntArray(Arrays.asList(1, 2, 3));
        short version = 1;
        ByteBuffer buf = MessageTestUtil.messageToByteBuffer((Message)data, version);
        SimpleExampleMessageData data2 = new SimpleExampleMessageData();
        data2.read((Readable)new ByteBufferAccessor(buf.duplicate()), version);
        Assert.assertEquals(Arrays.asList(1, 2, 3), data.myTaggedIntArray());
        Assert.assertEquals(Arrays.asList(1, 2, 3), data2.myTaggedIntArray());
        Assert.assertEquals((Object)data, (Object)data2);
    }
}

