/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class SimpleExampleMessageData
implements ApiMessage {
    private UUID processId;
    private List<Integer> myTaggedIntArray;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[0]);
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), "")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public SimpleExampleMessageData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SimpleExampleMessageData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SimpleExampleMessageData() {
        this.processId = MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>();
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version) {
        this.processId = _version >= 1 ? _readable.readUUID() : MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>();
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field myTaggedIntArray was serialized as null");
                        }
                        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.myTaggedIntArray = newCollection;
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeUUID(this.processId);
        } else if (this.processId != MessageUtil.ZERO_UUID) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.myTaggedIntArray.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.myTaggedIntArray) + 1);
                _writable.writeUnsignedVarint(this.myTaggedIntArray.size() + 1);
                for (Integer myTaggedIntArrayElement : this.myTaggedIntArray) {
                    _writable.writeInt(myTaggedIntArrayElement.intValue());
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.processId = _version >= 1 ? struct.getUUID("process_id") : MessageUtil.ZERO_UUID;
        if (_version >= 1) {
            if (_taggedFields.containsKey(0)) {
                Object[] _nestedObjects = (Object[])_taggedFields.remove(0);
                this.myTaggedIntArray = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.myTaggedIntArray.add((Integer)nestedObject);
                }
            } else {
                this.myTaggedIntArray = new ArrayList<Integer>();
            }
        } else {
            this.myTaggedIntArray = new ArrayList<Integer>();
        }
        if (_version >= 1 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap<Integer, Integer[]> _taggedFields = null;
        if (_version >= 1) {
            _taggedFields = new TreeMap<Integer, Integer[]>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("process_id", (Object)this.processId);
        }
        if (_version >= 1 && !this.myTaggedIntArray.isEmpty()) {
            Integer[] _nestedObjects = new Integer[this.myTaggedIntArray.size()];
            int i = 0;
            for (Integer element : this.myTaggedIntArray) {
                _nestedObjects[i++] = element;
            }
            _taggedFields.put(0, _nestedObjects);
        }
        if (_version >= 1) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 16;
        }
        if (_version >= 1 && !this.myTaggedIntArray.isEmpty()) {
            ++_numTaggedFields;
            ++_size;
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.myTaggedIntArray.size() + 1));
            _cache.setArraySizeInBytes(this.myTaggedIntArray, _arraySize += this.myTaggedIntArray.size() * 4);
            _size += _arraySize + ByteUtils.sizeOfUnsignedVarint((int)_arraySize);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 1) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleExampleMessageData)) {
            return false;
        }
        SimpleExampleMessageData other = (SimpleExampleMessageData)obj;
        if (!this.processId.equals(other.processId)) {
            return false;
        }
        return !(this.myTaggedIntArray == null ? other.myTaggedIntArray != null : !this.myTaggedIntArray.equals(other.myTaggedIntArray));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.myTaggedIntArray == null ? 0 : this.myTaggedIntArray.hashCode());
        return hashCode;
    }

    public String toString() {
        return "SimpleExampleMessageData(processId=" + this.processId.toString() + ", myTaggedIntArray=" + MessageUtil.deepToString(this.myTaggedIntArray.iterator()) + ")";
    }

    public UUID processId() {
        return this.processId;
    }

    public List<Integer> myTaggedIntArray() {
        return this.myTaggedIntArray;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SimpleExampleMessageData setProcessId(UUID v) {
        this.processId = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedIntArray(List<Integer> v) {
        this.myTaggedIntArray = v;
        return this;
    }
}

