/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public final class MessageTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testAddOffsetsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnRequestData().setTransactionalId("foobar").setProducerId(52596993799604990L).setProducerEpoch((short)123).setGroupId("baaz"));
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnResponseData().setThrottleTimeMs(42).setErrorCode((short)0));
    }

    @Test
    public void testAddPartitionsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddPartitionsToTxnRequestData().setTransactionalId("blah").setProducerId(52596993799604990L).setProducerEpoch((short)30000).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("Topic").setPartitions(Collections.singletonList(1))).iterator())));
    }

    @Test
    public void testCreateTopicsVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new CreateTopicsRequestData().setTimeoutMs(1000).setTopics(new CreateTopicsRequestData.CreatableTopicCollection()));
    }

    @Test
    public void testDescribeAclsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeAclsRequestData().setResourceType((byte)42).setResourceNameFilter(null).setResourcePatternType((byte)3).setPrincipalFilter("abc").setHostFilter(null).setOperation((byte)0).setPermissionType((byte)0));
    }

    @Test
    public void testMetadataVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new MetadataRequestData().setTopics(Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName("foo"), new MetadataRequestData.MetadataRequestTopic().setName("bar"))));
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(false).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
    }

    @Test
    public void testHeartbeatVersions() throws Exception {
        Supplier<HeartbeatRequestData> newRequest = () -> new HeartbeatRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupRequestVersions() throws Exception {
        Supplier<JoinGroupRequestData> newRequest = () -> new JoinGroupRequestData().setGroupId("groupId").setMemberId("memberId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection()).setSessionTimeoutMs(10000);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newRequest.get().setRebalanceTimeoutMs(20000));
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupResponseVersions() throws Exception {
        String memberId = "memberId";
        Supplier<JoinGroupResponseData> newResponse = () -> new JoinGroupResponseData().setMemberId(memberId).setLeader(memberId).setGenerationId(1).setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(memberId)));
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTrips(newResponse.get().members().get(0).setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, newResponse.get().members().get(0).setGroupInstanceId("instanceId"));
    }

    @Test
    public void testSyncGroupDefaultGroupInstanceId() throws Exception {
        Supplier<SyncGroupRequestData> request = () -> new SyncGroupRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15).setAssignments(new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>());
        this.testAllMessageRoundTrips((Message)request.get());
        this.testAllMessageRoundTrips((Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetCommitDefaultGroupInstanceId() throws Exception {
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>()).setGroupId("groupId"));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>()).setGenerationId(15);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)7, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetForLeaderEpochVersions() throws Exception {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataNoCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartitionIndex(0).setLeaderEpoch(3);
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataWithCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartitionIndex(0).setLeaderEpoch(3).setCurrentLeaderEpoch(5);
        this.testAllMessageRoundTrips((Message)new OffsetForLeaderEpochRequestData().setTopics(Collections.singletonList(new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setName("foo").setPartitions(Collections.singletonList(partitionDataNoCurrentEpoch)))));
        this.testAllMessageRoundTripsBeforeVersion((short)2, partitionDataWithCurrentEpoch, partitionDataNoCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)2, partitionDataWithCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5));
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData());
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData().setReplicaId(-2));
    }

    private void testAllMessageRoundTrips(Message message) throws Exception {
        this.testAllMessageRoundTripsFromVersion(message.lowestSupportedVersion(), message);
    }

    private void testAllMessageRoundTripsBeforeVersion(short beforeVersion, Message message, Message expected) throws Exception {
        for (short version = 0; version < beforeVersion; version = (short)(version + 1)) {
            this.testMessageRoundTrip(version, message, expected);
        }
    }

    private void testAllMessageRoundTripsFromVersion(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version < message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testMessageRoundTrip(short version, Message message, Message expected) throws Exception {
        this.testByteBufferRoundTrip(version, message, expected);
        this.testStructRoundTrip(version, message, expected);
    }

    private void testEquivalentMessageRoundTrip(short version, Message message) throws Exception {
        this.testStructRoundTrip(version, message, message);
        this.testByteBufferRoundTrip(version, message, message);
    }

    private void testByteBufferRoundTrip(short version, Message message, Message expected) throws Exception {
        int size = message.size(version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, version);
        Assert.assertEquals((long)size, (long)buf.position());
        Message message2 = (Message)message.getClass().newInstance();
        buf.flip();
        message2.read((Readable)byteBufferAccessor, version);
        Assert.assertEquals((long)size, (long)buf.position());
        Assert.assertEquals((Object)expected, (Object)message2);
        Assert.assertEquals((long)expected.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private void testStructRoundTrip(short version, Message message, Message expected) throws Exception {
        Struct struct = message.toStruct(version);
        Message message2 = (Message)message.getClass().newInstance();
        message2.fromStruct(struct, version);
        Assert.assertEquals((Object)expected, (Object)message2);
        Assert.assertEquals((long)expected.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    @Test
    public void testMessageVersions() throws Exception {
        for (ApiKeys apiKey : ApiKeys.values()) {
            ApiMessage message = null;
            try {
                message = ApiMessageType.fromApiKey(apiKey.id).newRequest();
            }
            catch (UnsupportedVersionException e) {
                Assert.fail((String)("No request message spec found for API " + apiKey));
            }
            Assert.assertTrue((String)("Request message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()), (apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0);
            try {
                message = ApiMessageType.fromApiKey(apiKey.id).newResponse();
            }
            catch (UnsupportedVersionException e) {
                Assert.fail((String)("No response message spec found for API " + apiKey));
            }
            Assert.assertTrue((String)("Response message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()), (apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRequestSchemas() throws Exception {
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema[] manualSchemas = apiKey.requestSchemas;
            Schema[] generatedSchemas = ApiMessageType.fromApiKey(apiKey.id).requestSchemas();
            Assert.assertEquals((String)("Mismatching request SCHEMAS lengths for api key " + apiKey), (long)manualSchemas.length, (long)generatedSchemas.length);
            for (int v = 0; v < manualSchemas.length; ++v) {
                try {
                    if (generatedSchemas[v] == null) continue;
                    MessageTest.compareTypes(manualSchemas[v], generatedSchemas[v]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to compare request schemas for version " + v + " of " + apiKey, e);
                }
            }
        }
    }

    @Test
    public void testResponseSchemas() throws Exception {
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema[] manualSchemas = apiKey.responseSchemas;
            Schema[] generatedSchemas = ApiMessageType.fromApiKey(apiKey.id).responseSchemas();
            Assert.assertEquals((String)("Mismatching response SCHEMAS lengths for api key " + apiKey), (long)manualSchemas.length, (long)generatedSchemas.length);
            for (int v = 0; v < manualSchemas.length; ++v) {
                try {
                    if (generatedSchemas[v] == null) continue;
                    MessageTest.compareTypes(manualSchemas[v], generatedSchemas[v]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to compare response schemas for version " + v + " of " + apiKey, e);
                }
            }
        }
    }

    private static void compareTypes(Schema schemaA, Schema schemaB) {
        MessageTest.compareTypes(new NamedType("schemaA", (Type)schemaA), new NamedType("schemaB", (Type)schemaB));
    }

    private static void compareTypes(NamedType typeA, NamedType typeB) {
        List<NamedType> listA = MessageTest.flatten(typeA);
        List<NamedType> listB = MessageTest.flatten(typeB);
        if (listA.size() != listB.size()) {
            throw new RuntimeException("Can't match up structures: typeA has " + Utils.join(listA, (String)", ") + ", but typeB has " + Utils.join(listB, (String)", "));
        }
        for (int i = 0; i < listA.size(); ++i) {
            NamedType entryB;
            NamedType entryA = listA.get(i);
            if (!entryA.hasSimilarType(entryB = listB.get(i))) {
                throw new RuntimeException("Type " + entryA + " in schema A does not match type " + entryB + " in schema B.");
            }
            if (entryA.type.isNullable() != entryB.type.isNullable()) {
                throw new RuntimeException(String.format("Type %s in Schema A is %s, but type %s in Schema B is %s", entryA, entryA.type.isNullable() ? "nullable" : "non-nullable", entryB, entryB.type.isNullable() ? "nullable" : "non-nullable"));
            }
            if (!(entryA.type instanceof ArrayOf)) continue;
            MessageTest.compareTypes(new NamedType(entryA.name, ((ArrayOf)entryA.type).type()), new NamedType(entryB.name, ((ArrayOf)entryB.type).type()));
        }
    }

    private static List<NamedType> flatten(NamedType type) {
        if (!(type.type instanceof Schema)) {
            return Collections.singletonList(type);
        }
        Schema schema = (Schema)type.type;
        ArrayList<NamedType> results = new ArrayList<NamedType>();
        for (BoundField field : schema.fields()) {
            results.addAll(MessageTest.flatten(new NamedType(field.def.name, field.def.type)));
        }
        return results;
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.verifySizeRaisesUve((short)0, "validateOnly", (Message)new CreateTopicsRequestData().setValidateOnly(true));
        this.verifySizeSucceeds((short)0, (Message)new CreateTopicsRequestData().setValidateOnly(false));
        this.verifySizeSucceeds((short)0, (Message)new OffsetCommitRequestData().setRetentionTimeMs(123L));
        this.verifySizeRaisesUve((short)5, "forgotten", (Message)new FetchRequestData().setForgotten(Collections.singletonList(new FetchRequestData.ForgottenTopic().setName("foo"))));
    }

    @Test
    public void testNonIgnorableFieldWithDefaultNull() throws Exception {
        this.verifySizeRaisesUve((short)0, "groupInstanceId", (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId("instanceId"));
        this.verifySizeSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId(null));
        this.verifySizeSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId"));
    }

    private void verifySizeRaisesUve(short version, String problemFieldName, Message message) throws Exception {
        try {
            message.size(version);
            Assert.fail((String)("Expected to see an UnsupportedVersionException when writing " + message + " at version " + version));
        }
        catch (UnsupportedVersionException e) {
            Assert.assertTrue((String)("Expected to get an error message about " + problemFieldName), (boolean)e.getMessage().contains(problemFieldName));
        }
    }

    private void verifySizeSucceeds(short version, Message message) throws Exception {
        message.size(version);
    }

    private static class NamedType {
        final String name;
        final Type type;

        NamedType(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        boolean hasSimilarType(NamedType other) {
            if (this.type.getClass().equals(other.type.getClass())) {
                return true;
            }
            return this.type.getClass().equals(Type.RECORDS.getClass()) ? other.type.getClass().equals(Type.NULLABLE_BYTES.getClass()) : this.type.getClass().equals(Type.NULLABLE_BYTES.getClass()) && other.type.getClass().equals(Type.RECORDS.getClass());
        }

        public String toString() {
            return this.name + "[" + this.type + "]";
        }
    }
}

