/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;

public abstract class AbstractControlRequest
extends AbstractRequest {
    public static final long UNKNOWN_BROKER_EPOCH = -1L;
    protected static final Field.Int32 CONTROLLER_ID = new Field.Int32("controller_id", "The controller id");
    protected static final Field.Int32 CONTROLLER_EPOCH = new Field.Int32("controller_epoch", "The controller epoch");
    protected static final Field.Int64 BROKER_EPOCH = new Field.Int64("broker_epoch", "The broker epoch");
    protected final int controllerId;
    protected final int controllerEpoch;
    protected final long brokerEpoch;

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    protected AbstractControlRequest(ApiKeys api, short version, int controllerId, int controllerEpoch, long brokerEpoch) {
        super(api, version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.brokerEpoch = brokerEpoch;
    }

    protected AbstractControlRequest(ApiKeys api, Struct struct, short version) {
        super(api, version);
        this.controllerId = struct.get(CONTROLLER_ID);
        this.controllerEpoch = struct.get(CONTROLLER_EPOCH);
        this.brokerEpoch = struct.getOrElse(BROKER_EPOCH, -1L);
    }

    long size() {
        return this.toStruct().sizeOf();
    }

    public static abstract class Builder<T extends AbstractRequest>
    extends AbstractRequest.Builder<T> {
        protected final int controllerId;
        protected final int controllerEpoch;
        protected final long brokerEpoch;

        protected Builder(ApiKeys api, short version, int controllerId, int controllerEpoch, long brokerEpoch) {
            super(api, version);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.brokerEpoch = brokerEpoch;
        }
    }
}

