/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MockProducerTest {
    private final String topic = "topic";
    private MockProducer<byte[], byte[]> producer;
    private final ProducerRecord<byte[], byte[]> record1 = new ProducerRecord("topic", (Object)"key1".getBytes(), (Object)"value1".getBytes());
    private final ProducerRecord<byte[], byte[]> record2 = new ProducerRecord("topic", (Object)"key2".getBytes(), (Object)"value2".getBytes());

    private void buildMockProducer(boolean autoComplete) {
        this.producer = new MockProducer(autoComplete, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
    }

    @After
    public void cleanup() {
        if (this.producer != null && !this.producer.closed()) {
            this.producer.close();
        }
    }

    @Test
    public void testAutoCompleteMock() throws Exception {
        this.buildMockProducer(true);
        Future metadata = this.producer.send(this.record1);
        Assert.assertTrue((String)"Send should be immediately complete", (boolean)metadata.isDone());
        Assert.assertFalse((String)"Send should be successful", (boolean)this.isError(metadata));
        Assert.assertEquals((String)"Offset should be 0", (long)0L, (long)((RecordMetadata)metadata.get()).offset());
        Assert.assertEquals((Object)"topic", (Object)((RecordMetadata)metadata.get()).topic());
        Assert.assertEquals((String)"We should have the record in our history", Collections.singletonList(this.record1), (Object)this.producer.history());
        this.producer.clear();
        Assert.assertEquals((String)"Clear should erase our history", (long)0L, (long)this.producer.history().size());
    }

    @Test
    public void testPartitioner() throws Exception {
        PartitionInfo partitionInfo0 = new PartitionInfo("topic", 0, null, null, null);
        PartitionInfo partitionInfo1 = new PartitionInfo("topic", 1, null, null, null);
        Cluster cluster = new Cluster(null, new ArrayList(0), Arrays.asList(partitionInfo0, partitionInfo1), Collections.emptySet(), Collections.emptySet());
        MockProducer producer = new MockProducer(cluster, true, (Partitioner)new DefaultPartitioner(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ProducerRecord record = new ProducerRecord("topic", (Object)"key", (Object)"value");
        Future metadata = producer.send(record);
        Assert.assertEquals((String)"Partition should be correct", (long)1L, (long)((RecordMetadata)metadata.get()).partition());
        producer.clear();
        Assert.assertEquals((String)"Clear should erase our history", (long)0L, (long)producer.history().size());
        producer.close();
    }

    @Test
    public void testManualCompletion() throws Exception {
        this.buildMockProducer(false);
        Future md1 = this.producer.send(this.record1);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md1.isDone());
        Future md2 = this.producer.send(this.record2);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md2.isDone());
        Assert.assertTrue((String)"Complete the first request", (boolean)this.producer.completeNext());
        Assert.assertFalse((String)"Requst should be successful", (boolean)this.isError(md1));
        Assert.assertFalse((String)"Second request still incomplete", (boolean)md2.isDone());
        IllegalArgumentException e = new IllegalArgumentException("blah");
        Assert.assertTrue((String)"Complete the second request with an error", (boolean)this.producer.errorNext((RuntimeException)e));
        try {
            md2.get();
            Assert.fail((String)"Expected error to be thrown");
        }
        catch (ExecutionException err) {
            Assert.assertEquals((Object)e, (Object)err.getCause());
        }
        Assert.assertFalse((String)"No more requests to complete", (boolean)this.producer.completeNext());
        Future md3 = this.producer.send(this.record1);
        Future md4 = this.producer.send(this.record2);
        Assert.assertTrue((String)"Requests should not be completed.", (!md3.isDone() && !md4.isDone() ? 1 : 0) != 0);
        this.producer.flush();
        Assert.assertTrue((String)"Requests should be completed.", (md3.isDone() && md4.isDone() ? 1 : 0) != 0);
    }

    @Test
    public void shouldInitTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assert.assertTrue((boolean)this.producer.transactionInitialized());
    }

    @Test
    public void shouldThrowOnInitTransactionIfProducerAlreadyInitializedForTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        try {
            this.producer.initTransactions();
            Assert.fail((String)"Should have thrown as producer is already initialized");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowOnBeginTransactionIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        this.producer.beginTransaction();
    }

    @Test
    public void shouldBeginTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assert.assertTrue((boolean)this.producer.transactionInFlight());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowOnSendOffsetsToTransactionIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        this.producer.sendOffsetsToTransaction(null, null);
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        try {
            this.producer.sendOffsetsToTransaction(null, null);
            Assert.fail((String)"Should have thrown as producer has no open transaction");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowOnCommitIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        this.producer.commitTransaction();
    }

    @Test
    public void shouldThrowOnCommitTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        try {
            this.producer.commitTransaction();
            Assert.fail((String)"Should have thrown as producer has no open transaction");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldCommitEmptyTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assert.assertFalse((boolean)this.producer.transactionInFlight());
        Assert.assertTrue((boolean)this.producer.transactionCommitted());
        Assert.assertFalse((boolean)this.producer.transactionAborted());
    }

    @Test
    public void shouldCountCommittedTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        MatcherAssert.assertThat((Object)this.producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        this.producer.commitTransaction();
        MatcherAssert.assertThat((Object)this.producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldNotCountAbortedTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        MatcherAssert.assertThat((Object)this.producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowOnAbortIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        this.producer.abortTransaction();
    }

    @Test
    public void shouldThrowOnAbortTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        try {
            this.producer.abortTransaction();
            Assert.fail((String)"Should have thrown as producer has no open transaction");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldAbortEmptyTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        Assert.assertFalse((boolean)this.producer.transactionInFlight());
        Assert.assertTrue((boolean)this.producer.transactionAborted());
        Assert.assertFalse((boolean)this.producer.transactionCommitted());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowFenceProducerIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        this.producer.fenceProducer();
    }

    @Test
    public void shouldThrowOnBeginTransactionsIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        try {
            this.producer.beginTransaction();
            Assert.fail((String)"Should have thrown as producer is fenced off");
        }
        catch (ProducerFencedException producerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnSendIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        try {
            this.producer.send(null);
            Assert.fail((String)"Should have thrown as producer is fenced off");
        }
        catch (KafkaException e) {
            Assert.assertTrue((String)"The root cause of the exception should be ProducerFenced", (boolean)(e.getCause() instanceof ProducerFencedException));
        }
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        try {
            this.producer.sendOffsetsToTransaction(null, null);
            Assert.fail((String)"Should have thrown as producer is fenced off");
        }
        catch (ProducerFencedException producerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnCommitTransactionIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        try {
            this.producer.commitTransaction();
            Assert.fail((String)"Should have thrown as producer is fenced off");
        }
        catch (ProducerFencedException producerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnAbortTransactionIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        try {
            this.producer.abortTransaction();
            Assert.fail((String)"Should have thrown as producer is fenced off");
        }
        catch (ProducerFencedException producerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldPublishMessagesOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        Assert.assertTrue((boolean)this.producer.history().isEmpty());
        this.producer.commitTransaction();
        ArrayList<ProducerRecord<byte[], byte[]>> expectedResult = new ArrayList<ProducerRecord<byte[], byte[]>>();
        expectedResult.add(this.record1);
        expectedResult.add(this.record2);
        MatcherAssert.assertThat((Object)this.producer.history(), (Matcher)CoreMatchers.equalTo(expectedResult));
    }

    @Test
    public void shouldFlushOnCommitForNonAutoCompleteIfTransactionsAreEnabled() {
        this.buildMockProducer(false);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Future md1 = this.producer.send(this.record1);
        Future md2 = this.producer.send(this.record2);
        Assert.assertFalse((boolean)md1.isDone());
        Assert.assertFalse((boolean)md2.isDone());
        this.producer.commitTransaction();
        Assert.assertTrue((boolean)md1.isDone());
        Assert.assertTrue((boolean)md2.isDone());
    }

    @Test
    public void shouldDropMessagesOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        this.producer.abortTransaction();
        Assert.assertTrue((boolean)this.producer.history().isEmpty());
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assert.assertTrue((boolean)this.producer.history().isEmpty());
    }

    @Test
    public void shouldThrowOnAbortForNonAutoCompleteIfTransactionsAreEnabled() throws Exception {
        this.buildMockProducer(false);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Future md1 = this.producer.send(this.record1);
        Assert.assertFalse((boolean)md1.isDone());
        this.producer.abortTransaction();
        Assert.assertTrue((boolean)md1.isDone());
    }

    @Test
    public void shouldPreserveCommittedMessagesOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        this.producer.commitTransaction();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        ArrayList<ProducerRecord<byte[], byte[]>> expectedResult = new ArrayList<ProducerRecord<byte[], byte[]>>();
        expectedResult.add(this.record1);
        expectedResult.add(this.record2);
        MatcherAssert.assertThat((Object)this.producer.history(), (Matcher)CoreMatchers.equalTo(expectedResult));
    }

    @Test
    public void shouldPublishConsumerGroupOffsetsOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group1 = "g1";
        HashMap<TopicPartition, OffsetAndMetadata> group1Commit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
            }
        };
        String group2 = "g2";
        HashMap<TopicPartition, OffsetAndMetadata> group2Commit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(101L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(21L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)group1Commit, group1);
        this.producer.sendOffsetsToTransaction((Map)group2Commit, group2);
        Assert.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
        HashMap<String, HashMap> expectedResult = new HashMap<String, HashMap>();
        expectedResult.put(group1, group1Commit);
        expectedResult.put(group2, group2Commit);
        this.producer.commitTransaction();
        MatcherAssert.assertThat((Object)this.producer.consumerGroupOffsetsHistory(), (Matcher)CoreMatchers.equalTo(Collections.singletonList(expectedResult)));
    }

    @Test
    public void shouldThrowOnNullConsumerGroupIdWhenSendOffsetsToTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        try {
            this.producer.sendOffsetsToTransaction(Collections.emptyMap(), null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void shouldIgnoreEmptyOffsetsWhenSendOffsetsToTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.sendOffsetsToTransaction(Collections.emptyMap(), "groupId");
        Assert.assertFalse((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldAddOffsetsWhenSendOffsetsToTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assert.assertFalse((boolean)this.producer.sentOffsets());
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)groupCommit, "groupId");
        Assert.assertTrue((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldResetSentOffsetsFlagOnlyWhenBeginningNewTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assert.assertFalse((boolean)this.producer.sentOffsets());
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)groupCommit, "groupId");
        this.producer.commitTransaction();
        Assert.assertTrue((boolean)this.producer.sentOffsets());
        this.producer.beginTransaction();
        Assert.assertFalse((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldPublishLatestAndCumulativeConsumerGroupOffsetsOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit1 = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
            }
        };
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit2 = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(101L, null));
                this.put(new TopicPartition("topic", 2), new OffsetAndMetadata(21L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)groupCommit1, group);
        this.producer.sendOffsetsToTransaction((Map)groupCommit2, group);
        Assert.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
        HashMap<String, 7> expectedResult = new HashMap<String, 7>();
        expectedResult.put(group, new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(101L, null));
                this.put(new TopicPartition("topic", 2), new OffsetAndMetadata(21L, null));
            }
        });
        this.producer.commitTransaction();
        MatcherAssert.assertThat((Object)this.producer.consumerGroupOffsetsHistory(), (Matcher)CoreMatchers.equalTo(Collections.singletonList(expectedResult)));
    }

    @Test
    public void shouldDropConsumerGroupOffsetsOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)groupCommit, group);
        this.producer.abortTransaction();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assert.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
    }

    @Test
    public void shouldPreserveCommittedConsumerGroupsOffsetsOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        HashMap<TopicPartition, OffsetAndMetadata> groupCommit = new HashMap<TopicPartition, OffsetAndMetadata>(){
            {
                this.put(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
                this.put(new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
            }
        };
        this.producer.sendOffsetsToTransaction((Map)groupCommit, group);
        this.producer.commitTransaction();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        HashMap<String, 9> expectedResult = new HashMap<String, 9>();
        expectedResult.put(group, groupCommit);
        MatcherAssert.assertThat((Object)this.producer.consumerGroupOffsetsHistory(), (Matcher)CoreMatchers.equalTo(Collections.singletonList(expectedResult)));
    }

    @Test
    public void shouldThrowOnInitTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.initTransactions();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnSendIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.send(null);
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnBeginTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.beginTransaction();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowSendOffsetsToTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.sendOffsetsToTransaction(null, null);
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnCommitTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.commitTransaction();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnAbortTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.abortTransaction();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnFenceProducerIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.fenceProducer();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnFlushProducerIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        try {
            this.producer.flush();
            Assert.fail((String)"Should have thrown as producer is already closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeFlushedIfNoBufferedRecords() {
        this.buildMockProducer(true);
        Assert.assertTrue((boolean)this.producer.flushed());
    }

    @Test
    public void shouldBeFlushedWithAutoCompleteIfBufferedRecords() {
        this.buildMockProducer(true);
        this.producer.send(this.record1);
        Assert.assertTrue((boolean)this.producer.flushed());
    }

    @Test
    public void shouldNotBeFlushedWithNoAutoCompleteIfBufferedRecords() {
        this.buildMockProducer(false);
        this.producer.send(this.record1);
        Assert.assertFalse((boolean)this.producer.flushed());
    }

    @Test
    public void shouldNotBeFlushedAfterFlush() {
        this.buildMockProducer(false);
        this.producer.send(this.record1);
        this.producer.flush();
        Assert.assertTrue((boolean)this.producer.flushed());
    }

    private boolean isError(Future<?> future) {
        try {
            future.get();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

