/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.network.InvalidReceiveException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SaslServerAuthenticatorTest {
    @Test(expected=InvalidReceiveException.class)
    public void testOversizeRequest() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName());
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(524289);
            return 4;
        });
        authenticator.authenticate();
        ((TransportLayer)Mockito.verify((Object)transportLayer)).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void testUnexpectedRequestType() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName());
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, 0, "clientId", 13243);
        Struct headerStruct = header.toStruct();
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerStruct.sizeOf());
            return 4;
        }).then(invocation -> {
            headerStruct.writeTo((ByteBuffer)invocation.getArgument(0));
            return headerStruct.sizeOf();
        });
        try {
            authenticator.authenticate();
            Assert.fail((String)"Expected authenticate() to raise an exception");
        }
        catch (IllegalSaslStateException illegalSaslStateException) {
            // empty catch block
        }
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism) throws IOException {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        Map<String, JaasContext> jaasContexts = Collections.singletonMap(mechanism, new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null));
        Map<String, Subject> subjects = Collections.singletonMap(mechanism, new Subject());
        Map<String, SaslServerCallbackHandler> callbackHandlers = Collections.singletonMap(mechanism, new SaslServerCallbackHandler());
        return new SaslServerAuthenticator(configs, callbackHandlers, "node", subjects, null, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, transportLayer);
    }
}

