/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientAuthenticationFailureTest {
    private static MockTime time = new MockTime(50L);
    private NioEchoServer server;
    private Map<String, Object> saslServerConfigs;
    private Map<String, Object> saslClientConfigs;
    private final String topic = "test";
    private TestJaasConfig testJaasConfig;

    @Before
    public void setup() throws Exception {
        LoginManager.closeAll();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.saslServerConfigs = new HashMap<String, Object>();
        this.saslServerConfigs.put("sasl.enabled.mechanisms", Arrays.asList("PLAIN"));
        this.saslClientConfigs = new HashMap<String, Object>();
        this.saslClientConfigs.put("security.protocol", "SASL_PLAINTEXT");
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.testJaasConfig = TestJaasConfig.createConfiguration("PLAIN", Arrays.asList("PLAIN"));
        this.testJaasConfig.setClientOptions("PLAIN", "myuser", "anotherpassword");
        this.server = this.createEchoServer(securityProtocol);
    }

    @After
    public void teardown() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
    }

    @Test
    public void testConsumerWithInvalidCredentials() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.saslClientConfigs);
        props.put("bootstrap.servers", "localhost:" + this.server.port());
        StringDeserializer deserializer = new StringDeserializer();
        try (KafkaConsumer consumer2 = new KafkaConsumer(props, (Deserializer)deserializer, (Deserializer)deserializer);){
            consumer2.subscribe(Arrays.asList("test"));
            consumer2.poll(Duration.ofSeconds(10L));
            Assert.fail((String)"Expected an authentication error!");
        }
        catch (SaslAuthenticationException consumer2) {
        }
        catch (Exception e) {
            throw new AssertionError("Expected only an authentication error, but another error occurred.", e);
        }
    }

    @Test
    public void testProducerWithInvalidCredentials() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.saslClientConfigs);
        props.put("bootstrap.servers", "localhost:" + this.server.port());
        StringSerializer serializer = new StringSerializer();
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)serializer, (Serializer)serializer);){
            ProducerRecord record = new ProducerRecord("test", (Object)"message");
            producer.send(record).get();
            Assert.fail((String)"Expected an authentication error!");
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Expected SaslAuthenticationException, got " + e.getCause().getClass()), (boolean)(e.getCause() instanceof SaslAuthenticationException));
        }
    }

    @Test
    public void testAdminClientWithInvalidCredentials() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.saslClientConfigs);
        props.put("bootstrap.servers", "localhost:" + this.server.port());
        try (AdminClient client = AdminClient.create(props);){
            DescribeTopicsResult result = client.describeTopics(Collections.singleton("test"));
            result.all().get();
            Assert.fail((String)"Expected an authentication error!");
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Expected SaslAuthenticationException, got " + e.getCause().getClass()), (boolean)(e.getCause() instanceof SaslAuthenticationException));
        }
    }

    @Test
    public void testTransactionalProducerWithInvalidCredentials() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.saslClientConfigs);
        props.put("bootstrap.servers", "localhost:" + this.server.port());
        props.put("transactional.id", "txclient-1");
        props.put("enable.idempotence", "true");
        StringSerializer serializer = new StringSerializer();
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)serializer, (Serializer)serializer);){
            producer.initTransactions();
            Assert.fail((String)"Expected an authentication error!");
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            // empty catch block
        }
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol) throws Exception {
        return this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), new CredentialCache(), time);
    }
}

