/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.clients.consumer.internals.MockPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerCoordinatorTest {
    private final String topic1 = "test1";
    private final String topic2 = "test2";
    private final TopicPartition t1p = new TopicPartition("test1", 0);
    private final TopicPartition t2p = new TopicPartition("test2", 0);
    private final String groupId = "test-group";
    private final int rebalanceTimeoutMs = 60000;
    private final int sessionTimeoutMs = 10000;
    private final int heartbeatIntervalMs = 5000;
    private final long retryBackoffMs = 100L;
    private final int autoCommitIntervalMs = 2000;
    private final int requestTimeoutMs = 30000;
    private final MockTime time = new MockTime();
    private final Heartbeat heartbeat = new Heartbeat((Time)this.time, 10000, 5000, 60000, 100L);
    private MockPartitionAssignor partitionAssignor = new MockPartitionAssignor();
    private List<PartitionAssignor> assignors = Collections.singletonList(this.partitionAssignor);
    private MockClient client;
    private Cluster cluster = TestUtils.clusterWith(1, (Map<String, Integer>)new HashMap<String, Integer>(){
        {
            this.put("test1", 1);
            this.put("test2", 1);
        }
    });
    private Node node = (Node)this.cluster.nodes().get(0);
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private Metrics metrics;
    private ConsumerNetworkClient consumerClient;
    private MockRebalanceListener rebalanceListener;
    private MockCommitCallback mockOffsetCommitCallback;
    private ConsumerCoordinator coordinator;

    @Before
    public void setup() {
        this.subscriptions = new SubscriptionState(OffsetResetStrategy.EARLIEST);
        this.metadata = new Metadata(0L, Long.MAX_VALUE, true);
        this.metadata.update(this.cluster, Collections.emptySet(), this.time.milliseconds());
        this.client = new MockClient(this.time, this.metadata);
        this.consumerClient = new ConsumerNetworkClient(new LogContext(), (KafkaClient)this.client, this.metadata, (Time)this.time, 100L, 30000, Integer.MAX_VALUE);
        this.metrics = new Metrics((Time)this.time);
        this.rebalanceListener = new MockRebalanceListener();
        this.mockOffsetCommitCallback = new MockCommitCallback();
        this.partitionAssignor.clear();
        this.client.setNode(this.node);
        this.coordinator = this.buildCoordinator(this.metrics, this.assignors, true, false, true);
    }

    @After
    public void teardown() {
        this.metrics.close();
        this.coordinator.close(this.time.timer(0L));
    }

    @Test
    public void testNormalHeartbeat() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.NONE));
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.succeeded());
    }

    @Test(expected=GroupAuthorizationException.class)
    public void testGroupDescribeUnauthorized() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.GROUP_AUTHORIZATION_FAILED));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
    }

    @Test(expected=GroupAuthorizationException.class)
    public void testGroupReadUnauthorized() {
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(0, "memberId", Collections.emptyMap(), Errors.GROUP_AUTHORIZATION_FAILED));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testCoordinatorNotAvailable() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.COORDINATOR_NOT_AVAILABLE));
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testManyInFlightAsyncCommitsWithCoordinatorDisconnect() throws Exception {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        int numRequests = 1000;
        TopicPartition tp = new TopicPartition("foo", 0);
        final AtomicInteger responses = new AtomicInteger(0);
        for (int i = 0; i < numRequests; ++i) {
            Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(tp, new OffsetAndMetadata((long)i));
            this.coordinator.commitOffsetsAsync(offsets, new OffsetCommitCallback(){

                public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                    responses.incrementAndGet();
                    Throwable cause = exception.getCause();
                    Assert.assertTrue((String)("Unexpected exception cause type: " + (cause == null ? null : cause.getClass())), (boolean)(cause instanceof DisconnectException));
                }
            });
        }
        this.coordinator.markCoordinatorUnknown();
        this.consumerClient.pollNoWakeup();
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertEquals((long)numRequests, (long)responses.get());
    }

    @Test
    public void testCoordinatorUnknownInUnsentCallbacksAfterCoordinatorDead() throws Exception {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        final AtomicBoolean asyncCallbackInvoked = new AtomicBoolean(false);
        Map<TopicPartition, OffsetCommitRequest.PartitionData> offsets = Collections.singletonMap(new TopicPartition("foo", 0), new OffsetCommitRequest.PartitionData(13L, -1L, ""));
        this.consumerClient.send(this.coordinator.checkAndGetCoordinator(), (AbstractRequest.Builder)new OffsetCommitRequest.Builder("test-group", offsets)).compose((RequestFutureAdapter)new RequestFutureAdapter<ClientResponse, Object>(){

            public void onSuccess(ClientResponse value, RequestFuture<Object> future) {
            }

            public void onFailure(RuntimeException e, RequestFuture<Object> future) {
                Assert.assertTrue((String)("Unexpected exception type: " + e.getClass()), (boolean)(e instanceof DisconnectException));
                Assert.assertTrue((boolean)ConsumerCoordinatorTest.this.coordinator.coordinatorUnknown());
                asyncCallbackInvoked.set(true);
            }
        });
        this.coordinator.markCoordinatorUnknown();
        this.consumerClient.pollNoWakeup();
        Assert.assertTrue((boolean)asyncCallbackInvoked.get());
    }

    @Test
    public void testNotCoordinator() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.NOT_COORDINATOR));
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testIllegalGeneration() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.assignFromSubscribed(Collections.singletonList(this.t1p));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.ILLEGAL_GENERATION));
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.ILLEGAL_GENERATION.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.rejoinNeededOrPending());
    }

    @Test
    public void testUnknownConsumerId() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.assignFromSubscribed(Collections.singletonList(this.t1p));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.UNKNOWN_MEMBER_ID));
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.UNKNOWN_MEMBER_ID.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.rejoinNeededOrPending());
    }

    @Test
    public void testCoordinatorDisconnect() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(10000L);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.NONE), true);
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertTrue((boolean)(future.exception() instanceof DisconnectException));
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test(expected=ApiException.class)
    public void testJoinGroupInvalidGroupId() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(this.cluster, Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(0, "leader", Collections.emptyMap(), Errors.INVALID_GROUP_ID));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testNormalJoinGroupLeader() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(this.cluster, Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Collections.singletonList(this.t1p)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.memberId().equals("leader") && sync.generationId() == 1 && sync.groupAssignment().containsKey("leader");
            }
        }, (AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals(Collections.singleton("test1"), (Object)this.subscriptions.groupSubscription());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
    }

    @Test
    public void testPatternJoinGroupLeader() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Pattern.compile("test.*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(TestUtils.singletonCluster("test1", 1), Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Arrays.asList(this.t1p, this.t2p)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.memberId().equals("leader") && sync.generationId() == 1 && sync.groupAssignment().containsKey("leader");
            }
        }, (AbstractResponse)this.syncGroupResponse(Arrays.asList(this.t1p, this.t2p), Errors.NONE));
        this.client.prepareMetadataUpdate(this.cluster, Collections.emptySet());
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)2L, (long)this.subscriptions.numAssignedPartitions());
        Assert.assertEquals((long)2L, (long)this.subscriptions.groupSubscription().size());
        Assert.assertEquals((long)2L, (long)this.subscriptions.subscription().size());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.assigned.size());
    }

    @Test
    public void testMetadataRefreshDuringRebalance() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.needMetadataForAllTopics(true);
        this.metadata.update(TestUtils.singletonCluster("test1", 1), Collections.emptySet(), this.time.milliseconds());
        Assert.assertEquals(Collections.singleton("test1"), (Object)this.subscriptions.subscription());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> initialSubscription = Collections.singletonMap("leader", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Collections.singletonList(this.t1p)));
        final List<String> updatedSubscription = Arrays.asList("test1", "test2");
        final HashSet<String> updatedSubscriptionSet = new HashSet<String>(updatedSubscription);
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "leader", initialSubscription, Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                HashMap<String, Integer> updatedPartitions = new HashMap<String, Integer>();
                for (String topic : updatedSubscription) {
                    updatedPartitions.put(topic, 1);
                }
                ConsumerCoordinatorTest.this.metadata.update(TestUtils.clusterWith(1, updatedPartitions), Collections.emptySet(), ConsumerCoordinatorTest.this.time.milliseconds());
                return true;
            }
        }, (AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        List<TopicPartition> newAssignment = Arrays.asList(this.t1p, this.t2p);
        HashSet<TopicPartition> newAssignmentSet = new HashSet<TopicPartition>(newAssignment);
        Map<String, List<String>> updatedSubscriptions = Collections.singletonMap("leader", Arrays.asList("test1", "test2"));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", newAssignment));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                JoinGroupRequest join = (JoinGroupRequest)body;
                JoinGroupRequest.ProtocolMetadata protocolMetadata = (JoinGroupRequest.ProtocolMetadata)join.groupProtocols().iterator().next();
                PartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)protocolMetadata.metadata());
                protocolMetadata.metadata().rewind();
                return subscription.topics().containsAll(updatedSubscriptionSet);
            }
        }, (AbstractResponse)this.joinGroupLeaderResponse(2, "leader", updatedSubscriptions, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(newAssignment, Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(updatedSubscriptionSet, (Object)this.subscriptions.subscription());
        Assert.assertEquals(newAssignmentSet, (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.revoked);
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(newAssignmentSet, this.rebalanceListener.assigned);
    }

    @Test
    public void testForceMetadataRefreshForPatternSubscriptionDuringRebalance() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.update(TestUtils.singletonCluster("test1", 1), Collections.emptySet(), this.time.milliseconds());
        Assert.assertEquals(Collections.singleton("test1"), (Object)this.subscriptions.subscription());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareMetadataUpdate(this.cluster, Collections.emptySet());
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.memberId().equals("consumer") && sync.generationId() == 1 && sync.groupAssignment().isEmpty();
            }
        }, (AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.partitionAssignor.prepare(Collections.singletonMap("consumer", Collections.singletonList(this.t1p)));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        HashSet<String> updatedSubscriptionSet = new HashSet<String>(Arrays.asList("test1", "test2"));
        Assert.assertEquals(updatedSubscriptionSet, (Object)this.subscriptions.subscription());
        this.metadata.requestUpdate();
        this.client.poll(Long.MAX_VALUE, this.time.milliseconds());
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
    }

    @Test
    public void testWakeupDuringJoin() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(this.cluster, Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Collections.singletonList(this.t1p)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE));
        this.consumerClient.wakeup();
        try {
            this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
    }

    @Test
    public void testNormalJoinGroupFollower() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.memberId().equals("consumer") && sync.generationId() == 1 && sync.groupAssignment().isEmpty();
            }
        }, (AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals(Collections.singleton("test1"), (Object)this.subscriptions.groupSubscription());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
    }

    @Test
    public void testUpdateLastHeartbeatPollWhenCoordinatorUnknown() throws Exception {
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(Errors.NOT_COORDINATOR));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(5000L);
        TestUtils.waitForCondition(() -> !this.client.hasPendingResponses(), "Failed to observe expected heartbeat from background thread");
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertFalse((boolean)this.coordinator.poll(this.time.timer(0L)));
        Assert.assertEquals((long)this.time.milliseconds(), (long)this.heartbeat.lastPollTime());
        this.time.sleep(59999L);
        Assert.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testPatternJoinGroupFollower() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Pattern.compile("test.*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(TestUtils.singletonCluster("test1", 1), Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.memberId().equals("consumer") && sync.generationId() == 1 && sync.groupAssignment().isEmpty();
            }
        }, (AbstractResponse)this.syncGroupResponse(Arrays.asList(this.t1p, this.t2p), Errors.NONE));
        this.client.prepareMetadataUpdate(this.cluster, Collections.emptySet());
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)2L, (long)this.subscriptions.numAssignedPartitions());
        Assert.assertEquals((long)2L, (long)this.subscriptions.subscription().size());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.assigned.size());
    }

    @Test
    public void testLeaveGroupOnClose() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", this.coordinator, Collections.singletonList(this.t1p));
        final AtomicBoolean received = new AtomicBoolean(false);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                received.set(true);
                LeaveGroupRequest leaveRequest = (LeaveGroupRequest)body;
                return leaveRequest.memberId().equals("consumer") && leaveRequest.groupId().equals("test-group");
            }
        }, (AbstractResponse)new LeaveGroupResponse(Errors.NONE));
        this.coordinator.close(this.time.timer(0L));
        Assert.assertTrue((boolean)received.get());
    }

    @Test
    public void testMaybeLeaveGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", this.coordinator, Collections.singletonList(this.t1p));
        final AtomicBoolean received = new AtomicBoolean(false);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                received.set(true);
                LeaveGroupRequest leaveRequest = (LeaveGroupRequest)body;
                return leaveRequest.memberId().equals("consumer") && leaveRequest.groupId().equals("test-group");
            }
        }, (AbstractResponse)new LeaveGroupResponse(Errors.NONE));
        this.coordinator.maybeLeaveGroup();
        Assert.assertTrue((boolean)received.get());
        AbstractCoordinator.Generation generation = this.coordinator.generation();
        Assert.assertNull((Object)generation);
    }

    @Test(expected=KafkaException.class)
    public void testUnexpectedErrorOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.emptyList(), Errors.UNKNOWN_SERVER_ERROR));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testUnknownMemberIdOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.emptyList(), Errors.UNKNOWN_MEMBER_ID));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                JoinGroupRequest joinRequest = (JoinGroupRequest)body;
                return joinRequest.memberId().equals("");
            }
        }, (AbstractResponse)this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testRebalanceInProgressOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.emptyList(), Errors.REBALANCE_IN_PROGRESS));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testIllegalGenerationOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.emptyList(), Errors.ILLEGAL_GENERATION));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                JoinGroupRequest joinRequest = (JoinGroupRequest)body;
                return joinRequest.memberId().equals("");
            }
        }, (AbstractResponse)this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testMetadataChangeTriggersRebalance() {
        String consumerId = "consumer";
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.metadata.update(this.cluster, Collections.emptySet(), this.time.milliseconds());
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("consumer", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.singletonMap("consumer", Collections.singletonList(this.t1p)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "consumer", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        this.metadata.update(TestUtils.singletonCluster("test1", 2), Collections.emptySet(), this.time.milliseconds());
        Assert.assertTrue((boolean)this.coordinator.rejoinNeededOrPending());
    }

    @Test
    public void testUpdateMetadataDuringRebalance() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        String consumerId = "leader";
        List<String> topics = Arrays.asList("topic1", "topic2");
        this.subscriptions.subscribe(new HashSet<String>(topics), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(topics);
        this.metadata.update(TestUtils.singletonCluster("topic1", 1), Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", topics);
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Collections.singletonList(tp1)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                if (sync.memberId().equals("leader") && sync.generationId() == 1 && sync.groupAssignment().containsKey("leader")) {
                    HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
                    topicPartitionCounts.put("topic1", 1);
                    topicPartitionCounts.put("topic2", 1);
                    ConsumerCoordinatorTest.this.metadata.update(TestUtils.singletonCluster(topicPartitionCounts), Collections.emptySet(), ConsumerCoordinatorTest.this.time.milliseconds());
                    return true;
                }
                return false;
            }
        }, (AbstractResponse)this.syncGroupResponse(Collections.singletonList(tp1), Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(2, "leader", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Arrays.asList(tp1, tp2), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testWakeupFromAssignmentCallback() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, false, true);
        String topic = "topic1";
        TopicPartition partition = new TopicPartition("topic1", 0);
        String consumerId = "follower";
        Set<String> topics = Collections.singleton("topic1");
        MockRebalanceListener rebalanceListener = new MockRebalanceListener(){

            @Override
            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                boolean raiseWakeup = this.assignedCount == 0;
                super.onPartitionsAssigned(partitions);
                if (raiseWakeup) {
                    throw new WakeupException();
                }
            }
        };
        this.subscriptions.subscribe(topics, (ConsumerRebalanceListener)rebalanceListener);
        this.metadata.setTopics(topics);
        this.metadata.update(TestUtils.singletonCluster("topic1", 1), Collections.emptySet(), this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.partitionAssignor.prepare(Collections.singletonMap("follower", Collections.singletonList(partition)));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "follower", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(partition), Errors.NONE));
        try {
            coordinator.poll(this.time.timer(Long.MAX_VALUE));
            Assert.fail((String)"Expected exception thrown from assignment callback");
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)coordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)1L, (long)rebalanceListener.revokedCount);
        Assert.assertEquals((long)2L, (long)rebalanceListener.assignedCount);
    }

    @Test
    public void testRebalanceAfterTopicUnavailableWithSubscribe() {
        this.unavailableTopicTest(false, false, Collections.emptySet());
    }

    @Test
    public void testRebalanceAfterTopicUnavailableWithPatternSubscribe() {
        this.unavailableTopicTest(true, false, Collections.emptySet());
    }

    @Test
    public void testRebalanceAfterNotMatchingTopicUnavailableWithPatternSSubscribe() {
        this.unavailableTopicTest(true, false, Collections.singleton("notmatching"));
    }

    @Test
    public void testAssignWithTopicUnavailable() {
        this.unavailableTopicTest(true, false, Collections.emptySet());
    }

    private void unavailableTopicTest(boolean patternSubscribe, boolean assign, Set<String> unavailableTopicsInLastMetadata) {
        String consumerId = "consumer";
        this.metadata.setTopics(Collections.singletonList("test1"));
        this.client.prepareMetadataUpdate(Cluster.empty(), Collections.singleton("test1"));
        if (assign) {
            this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        } else if (patternSubscribe) {
            this.subscriptions.subscribe(Pattern.compile("test.*"), (ConsumerRebalanceListener)this.rebalanceListener);
        } else {
            this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        }
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("consumer", Collections.singletonList("test1"));
        this.partitionAssignor.prepare(Collections.emptyMap());
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, "consumer", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.emptyList(), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        if (!assign) {
            Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
            Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.assigned);
        }
        Assert.assertTrue((String)"Metadata refresh not requested for unavailable partitions", (boolean)this.metadata.updateRequested());
        this.client.prepareMetadataUpdate(this.cluster, unavailableTopicsInLastMetadata);
        this.client.poll(0L, this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(2, "consumer", memberSubscriptions, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((String)"Metadata refresh requested unnecessarily", (boolean)this.metadata.updateRequested());
        if (!assign) {
            Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
            Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
        }
    }

    @Test
    public void testExcludeInternalTopicsConfigOption() {
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.update(TestUtils.singletonCluster("__consumer_offsets", 2), Collections.emptySet(), this.time.milliseconds());
        Assert.assertFalse((boolean)this.subscriptions.subscription().contains("__consumer_offsets"));
    }

    @Test
    public void testIncludeInternalTopicsConfigOption() {
        this.coordinator = this.buildCoordinator(new Metrics(), this.assignors, false, false, true);
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.update(TestUtils.singletonCluster("__consumer_offsets", 2), Collections.emptySet(), this.time.milliseconds());
        Assert.assertTrue((boolean)this.subscriptions.subscription().contains("__consumer_offsets"));
    }

    @Test
    public void testRejoinGroup() {
        String otherTopic = "otherTopic";
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", this.coordinator, Collections.singletonList(this.t1p));
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertTrue((boolean)this.rebalanceListener.revoked.isEmpty());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
        this.subscriptions.subscribe(new HashSet<String>(Arrays.asList("test1", otherTopic)), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.revoked);
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
    }

    @Test
    public void testDisconnectInJoin() {
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE), true);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.rejoinNeededOrPending());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.t1p), this.rebalanceListener.assigned);
    }

    @Test(expected=ApiException.class)
    public void testInvalidSessionTimeout() {
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(0, "consumer", "", Errors.INVALID_SESSION_TIMEOUT));
        this.coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testCommitOffsetOnly() {
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        AtomicBoolean success = new AtomicBoolean(false);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.callback(success));
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)success.get());
    }

    @Test
    public void testCoordinatorDisconnectAfterNotCoordinatorError() {
        this.testInFlightRequestsFailedAfterCoordinatorMarkedDead(Errors.NOT_COORDINATOR);
    }

    @Test
    public void testCoordinatorDisconnectAfterCoordinatorNotAvailableError() {
        this.testInFlightRequestsFailedAfterCoordinatorMarkedDead(Errors.COORDINATOR_NOT_AVAILABLE);
    }

    private void testInFlightRequestsFailedAfterCoordinatorMarkedDead(Errors error) {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        MockCommitCallback firstCommitCallback = new MockCommitCallback();
        MockCommitCallback secondCommitCallback = new MockCommitCallback();
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)firstCommitCallback);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)secondCommitCallback);
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), error);
        this.consumerClient.pollNoWakeup();
        this.consumerClient.pollNoWakeup();
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertTrue((boolean)(firstCommitCallback.exception instanceof RetriableCommitFailedException));
        Assert.assertTrue((boolean)(secondCommitCallback.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testAutoCommitDynamicAssignment() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", coordinator, Collections.singletonList(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.time.sleep(2000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.client.hasPendingResponses());
    }

    @Test
    public void testAutoCommitRetryBackoff() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", coordinator, Collections.singletonList(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        this.time.sleep(2000L);
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NOT_COORDINATOR);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertTrue((boolean)coordinator.coordinatorUnknown());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.seek(this.t1p, 200L);
        this.time.sleep(50L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)this.client.inFlightRequestCount());
        this.time.sleep(50L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.client.inFlightRequestCount());
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, 200L), Errors.NONE);
    }

    @Test
    public void testAutoCommitAwaitsInterval() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", coordinator, Collections.singletonList(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        this.time.sleep(2000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.client.inFlightRequestCount());
        this.time.sleep(1000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.client.inFlightRequestCount());
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)this.client.inFlightRequestCount());
        this.subscriptions.seek(this.t1p, 200L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)this.client.inFlightRequestCount());
        this.time.sleep(1000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.client.inFlightRequestCount());
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, 200L), Errors.NONE);
    }

    @Test
    public void testAutoCommitDynamicAssignmentRebalance() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(2000L);
        this.consumerClient.poll(this.time.timer(0L));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
        coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.seek(this.t1p, 100L);
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.time.sleep(2000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.client.hasPendingResponses());
    }

    @Test
    public void testAutoCommitManualAssignment() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.time.sleep(2000L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.client.hasPendingResponses());
    }

    @Test
    public void testAutoCommitManualAssignmentCoordinatorUnknown() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        this.consumerClient.poll(this.time.timer(0L));
        this.time.sleep(2000L);
        this.consumerClient.poll(this.time.timer(0L));
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.time.sleep(100L);
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.client.hasPendingResponses());
    }

    @Test
    public void testCommitOffsetMetadata() {
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        AtomicBoolean success = new AtomicBoolean(false);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "hello"));
        this.coordinator.commitOffsetsAsync(offsets, this.callback(offsets, success));
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)success.get());
    }

    @Test
    public void testCommitOffsetAsyncWithDefaultCallback() {
        int invokedBeforeTest = this.mockOffsetCommitCallback.invoked;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)this.mockOffsetCommitCallback);
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertEquals((long)(invokedBeforeTest + 1), (long)this.mockOffsetCommitCallback.invoked);
        Assert.assertNull((Object)this.mockOffsetCommitCallback.exception);
    }

    @Test
    public void testCommitAfterLeaveGroup() {
        this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.joinAsFollowerAndReceiveAssignment("consumer", this.coordinator, Collections.singletonList(this.t1p));
        this.client.prepareResponse((AbstractResponse)new LeaveGroupResponse(Errors.NONE));
        this.subscriptions.unsubscribe();
        this.coordinator.maybeLeaveGroup();
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                OffsetCommitRequest commitRequest = (OffsetCommitRequest)body;
                return commitRequest.memberId().equals("") && commitRequest.generationId() == -1;
            }
        }, (AbstractResponse)this.offsetCommitResponse(Collections.singletonMap(this.t1p, Errors.NONE)));
        AtomicBoolean success = new AtomicBoolean(false);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.callback(success));
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)success.get());
    }

    @Test
    public void testCommitOffsetAsyncFailedWithDefaultCallback() {
        int invokedBeforeTest = this.mockOffsetCommitCallback.invoked;
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.COORDINATOR_NOT_AVAILABLE);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)this.mockOffsetCommitCallback);
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertEquals((long)(invokedBeforeTest + 1), (long)this.mockOffsetCommitCallback.invoked);
        Assert.assertTrue((boolean)(this.mockOffsetCommitCallback.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncCoordinatorNotAvailable() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        MockCommitCallback cb = new MockCommitCallback();
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.COORDINATOR_NOT_AVAILABLE);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncNotCoordinator() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        MockCommitCallback cb = new MockCommitCallback();
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.COORDINATOR_NOT_AVAILABLE);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncDisconnected() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        MockCommitCallback cb = new MockCommitCallback();
        this.prepareOffsetCommitRequestDisconnect(Collections.singletonMap(this.t1p, 100L));
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        this.coordinator.invokeCompletedOffsetCommitCallbacks();
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetSyncNotCoordinator() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NOT_COORDINATOR);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testCommitOffsetSyncCoordinatorNotAvailable() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.COORDINATOR_NOT_AVAILABLE);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testCommitOffsetSyncCoordinatorDisconnected() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequestDisconnect(Collections.singletonMap(this.t1p, 100L));
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testAsyncCommitCallbacksInvokedPriorToSyncCommitCompletion() throws Exception {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        final List committedOffsets = Collections.synchronizedList(new ArrayList());
        final OffsetAndMetadata firstOffset = new OffsetAndMetadata(0L);
        final OffsetAndMetadata secondOffset = new OffsetAndMetadata(1L);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.t1p, firstOffset), new OffsetCommitCallback(){

            public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                committedOffsets.add(firstOffset);
            }
        });
        Thread thread = new Thread(){

            @Override
            public void run() {
                ConsumerCoordinatorTest.this.coordinator.commitOffsetsSync(Collections.singletonMap(ConsumerCoordinatorTest.this.t1p, secondOffset), ConsumerCoordinatorTest.this.time.timer(10000L));
                committedOffsets.add(secondOffset);
            }
        };
        thread.start();
        this.client.waitForRequests(2, 5000L);
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, firstOffset.offset()), Errors.NONE);
        this.respondToOffsetCommitRequest(Collections.singletonMap(this.t1p, secondOffset.offset()), Errors.NONE);
        thread.join();
        Assert.assertEquals(Arrays.asList(firstOffset, secondOffset), committedOffsets);
    }

    @Test
    public void testRetryCommitUnknownTopicOrPartition() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.offsetCommitResponse(Collections.singletonMap(this.t1p, Errors.UNKNOWN_TOPIC_OR_PARTITION)));
        this.client.prepareResponse((AbstractResponse)this.offsetCommitResponse(Collections.singletonMap(this.t1p, Errors.NONE)));
        Assert.assertTrue((boolean)this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "metadata")), this.time.timer(10000L)));
    }

    @Test(expected=OffsetMetadataTooLarge.class)
    public void testCommitOffsetMetadataTooLarge() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.OFFSET_METADATA_TOO_LARGE);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "metadata")), this.time.timer(Long.MAX_VALUE));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetIllegalGeneration() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.ILLEGAL_GENERATION);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "metadata")), this.time.timer(Long.MAX_VALUE));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetUnknownMemberId() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.UNKNOWN_MEMBER_ID);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "metadata")), this.time.timer(Long.MAX_VALUE));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetRebalanceInProgress() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.REBALANCE_IN_PROGRESS);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L, "metadata")), this.time.timer(Long.MAX_VALUE));
    }

    @Test(expected=KafkaException.class)
    public void testCommitOffsetSyncCallbackWithNonRetriableException() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.UNKNOWN_SERVER_ERROR);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testCommitOffsetSyncWithoutFutureGetsCompleted() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.coordinator.commitOffsetsSync(Collections.singletonMap(this.t1p, new OffsetAndMetadata(100L)), this.time.timer(0L)));
    }

    @Test
    public void testRefreshOffset() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(this.t1p, Errors.NONE, "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertTrue((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals((long)100L, (long)this.subscriptions.position(this.t1p));
    }

    @Test
    public void testFetchCommittedOffsets() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        long offset = 500L;
        String metadata = "blahblah";
        Optional<Integer> leaderEpoch = Optional.of(15);
        OffsetFetchResponse.PartitionData data = new OffsetFetchResponse.PartitionData(offset, leaderEpoch, metadata, Errors.NONE);
        this.client.prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NONE, Collections.singletonMap(this.t1p, data)));
        Map fetchedOffsets = this.coordinator.fetchCommittedOffsets(Collections.singleton(this.t1p), this.time.timer(Long.MAX_VALUE));
        Assert.assertNotNull((Object)fetchedOffsets);
        Assert.assertEquals((Object)new OffsetAndMetadata(offset, leaderEpoch, metadata), fetchedOffsets.get(this.t1p));
    }

    @Test
    public void testRefreshOffsetLoadInProgress() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(this.t1p, Errors.NONE, "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertTrue((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals((long)100L, (long)this.subscriptions.position(this.t1p));
    }

    @Test
    public void testRefreshOffsetsGroupNotAuthorized() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.GROUP_AUTHORIZATION_FAILED));
        try {
            this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
            Assert.fail((String)"Expected group authorization error");
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)"test-group", (Object)e.groupId());
        }
    }

    @Test(expected=KafkaException.class)
    public void testRefreshOffsetUnknownTopicOrPartition() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(this.t1p, Errors.UNKNOWN_TOPIC_OR_PARTITION, "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
    }

    @Test
    public void testRefreshOffsetNotCoordinatorForConsumer() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NOT_COORDINATOR));
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(this.t1p, Errors.NONE, "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertTrue((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals((long)100L, (long)this.subscriptions.position(this.t1p));
    }

    @Test
    public void testRefreshOffsetWithNoFetchableOffsets() {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.client.prepareResponse((AbstractResponse)this.offsetFetchResponse(this.t1p, Errors.NONE, "", -1L));
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.partitionsNeedingReset(this.time.milliseconds()));
        Assert.assertFalse((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals(null, (Object)this.subscriptions.position(this.t1p));
    }

    @Test
    public void testNoCoordinatorDiscoveryIfPositionsKnown() {
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.subscriptions.seek(this.t1p, 500L);
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertTrue((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals((long)500L, (long)this.subscriptions.position(this.t1p));
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testNoCoordinatorDiscoveryIfPartitionAwaitingReset() {
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.subscriptions.requestOffsetReset(this.t1p, OffsetResetStrategy.EARLIEST);
        this.coordinator.refreshCommittedOffsetsIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assert.assertEquals(Collections.emptySet(), (Object)this.subscriptions.missingFetchPositions());
        Assert.assertFalse((boolean)this.subscriptions.hasAllFetchPositions());
        Assert.assertEquals(Collections.singleton(this.t1p), (Object)this.subscriptions.partitionsNeedingReset(this.time.milliseconds()));
        Assert.assertEquals((Object)OffsetResetStrategy.EARLIEST, (Object)this.subscriptions.resetStrategy(this.t1p));
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testAuthenticationFailureInEnsureActiveGroup() {
        this.client.createPendingAuthenticationError(this.node, 300L);
        try {
            this.coordinator.ensureActiveGroup();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    @Test
    public void testProtocolMetadataOrder() {
        List metadata;
        ConsumerCoordinator coordinator;
        RoundRobinAssignor roundRobin = new RoundRobinAssignor();
        RangeAssignor range = new RangeAssignor();
        try (Metrics metrics = new Metrics((Time)this.time);){
            coordinator = this.buildCoordinator(metrics, Arrays.asList(roundRobin, range), true, false, true);
            metadata = coordinator.metadata();
            Assert.assertEquals((long)2L, (long)metadata.size());
            Assert.assertEquals((Object)roundRobin.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(0)).name());
            Assert.assertEquals((Object)range.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(1)).name());
        }
        metrics = new Metrics((Time)this.time);
        var4_4 = null;
        try {
            coordinator = this.buildCoordinator(metrics, Arrays.asList(range, roundRobin), true, false, true);
            metadata = coordinator.metadata();
            Assert.assertEquals((long)2L, (long)metadata.size());
            Assert.assertEquals((Object)range.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(0)).name());
            Assert.assertEquals((Object)roundRobin.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(1)).name());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (metrics != null) {
                if (var4_4 != null) {
                    try {
                        metrics.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    metrics.close();
                }
            }
        }
    }

    @Test
    public void testThreadSafeAssignedPartitionsMetric() throws Exception {
        KafkaMetric metric = this.metrics.metric(new MetricName("assigned-partitions", "consumertest-group-coordinator-metrics", "", Collections.emptyMap()));
        final AtomicBoolean doStop = new AtomicBoolean();
        final AtomicReference exceptionHolder = new AtomicReference();
        final AtomicInteger observedSize = new AtomicInteger();
        Thread poller = new Thread((Metric)metric, observedSize, exceptionHolder){
            final /* synthetic */ Metric val$metric;
            final /* synthetic */ AtomicInteger val$observedSize;
            final /* synthetic */ AtomicReference val$exceptionHolder;
            {
                this.val$metric = metric;
                this.val$observedSize = atomicInteger;
                this.val$exceptionHolder = atomicReference;
            }

            @Override
            public void run() {
                while (!doStop.get()) {
                    try {
                        int size = ((Double)this.val$metric.metricValue()).intValue();
                        this.val$observedSize.set(size);
                    }
                    catch (Exception e) {
                        this.val$exceptionHolder.set(e);
                        return;
                    }
                }
            }
        };
        poller.start();
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        final int totalPartitions = 10;
        for (int partition = 0; partition < totalPartitions; ++partition) {
            partitions.add(new TopicPartition("test1", partition));
            this.subscriptions.assignFromUser(partitions);
        }
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return observedSize.get() == totalPartitions || exceptionHolder.get() != null;
            }
        }, "Failed to observe expected assignment change");
        doStop.set(true);
        poller.join();
        Assert.assertNull((String)"Failed fetching the metric at least once", exceptionHolder.get());
    }

    @Test
    public void testCloseDynamicAssignment() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.gracefulCloseTest(coordinator, true);
    }

    @Test
    public void testCloseManualAssignment() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(false, true, true);
        this.gracefulCloseTest(coordinator, false);
    }

    @Test
    public void shouldNotLeaveGroupWhenLeaveGroupFlagIsFalse() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, false);
        this.gracefulCloseTest(coordinator, false);
    }

    @Test
    public void testCloseCoordinatorNotKnownManualAssignment() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(false, true, true);
        this.makeCoordinatorUnknown(coordinator, Errors.NOT_COORDINATOR);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, 1000L, 1000L, 1000L);
    }

    @Test
    public void testCloseCoordinatorNotKnownNoCommits() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, false, true);
        this.makeCoordinatorUnknown(coordinator, Errors.NOT_COORDINATOR);
        this.closeVerifyTimeout(coordinator, 1000L, 0L, 0L);
    }

    @Test
    public void testCloseCoordinatorNotKnownWithCommits() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.makeCoordinatorUnknown(coordinator, Errors.NOT_COORDINATOR);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, 1000L, 1000L, 1000L);
    }

    @Test
    public void testCloseCoordinatorUnavailableNoCommits() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, false, true);
        this.makeCoordinatorUnknown(coordinator, Errors.COORDINATOR_NOT_AVAILABLE);
        this.closeVerifyTimeout(coordinator, 1000L, 0L, 0L);
    }

    @Test
    public void testCloseTimeoutCoordinatorUnavailableForCommit() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.makeCoordinatorUnknown(coordinator, Errors.COORDINATOR_NOT_AVAILABLE);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, 1000L, 1000L, 1000L);
    }

    @Test
    public void testCloseMaxWaitCoordinatorUnavailableForCommit() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.makeCoordinatorUnknown(coordinator, Errors.COORDINATOR_NOT_AVAILABLE);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, Long.MAX_VALUE, 30000L, 30000L);
    }

    @Test
    public void testCloseNoResponseForCommit() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, Long.MAX_VALUE, 30000L, 30000L);
    }

    @Test
    public void testCloseNoResponseForLeaveGroup() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, false, true);
        this.closeVerifyTimeout(coordinator, Long.MAX_VALUE, 30000L, 30000L);
    }

    @Test
    public void testCloseNoWait() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        this.time.sleep(2000L);
        this.closeVerifyTimeout(coordinator, 0L, 0L, 0L);
    }

    @Test
    public void testHeartbeatThreadClose() throws Exception {
        ConsumerCoordinator coordinator = this.prepareCoordinatorForCloseTest(true, true, true);
        coordinator.ensureActiveGroup();
        this.time.sleep(5100L);
        Thread.yield();
        this.closeVerifyTimeout(coordinator, Long.MAX_VALUE, 30000L, 30000L);
        Thread[] threads = new Thread[Thread.activeCount()];
        int threadCount = Thread.enumerate(threads);
        for (int i = 0; i < threadCount; ++i) {
            Assert.assertFalse((String)"Heartbeat thread active after close", (boolean)threads[i].getName().contains("test-group"));
        }
    }

    @Test
    public void testAutoCommitAfterCoordinatorBackToService() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true, true);
        this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        this.subscriptions.seek(this.t1p, 100L);
        coordinator.markCoordinatorUnknown();
        Assert.assertTrue((boolean)coordinator.coordinatorUnknown());
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        this.prepareOffsetCommitRequest(Collections.singletonMap(this.t1p, 100L), Errors.NONE);
        this.time.sleep(2000L);
        coordinator.maybeAutoCommitOffsetsAsync(this.time.milliseconds());
        Assert.assertFalse((boolean)coordinator.coordinatorUnknown());
        Assert.assertEquals((long)100L, (long)this.subscriptions.position(this.t1p));
    }

    private ConsumerCoordinator prepareCoordinatorForCloseTest(boolean useGroupManagement, boolean autoCommit, boolean leaveGroup) {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, autoCommit, leaveGroup);
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        if (useGroupManagement) {
            this.subscriptions.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
            this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE));
            this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.t1p), Errors.NONE));
            coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
        } else {
            this.subscriptions.assignFromUser(Collections.singleton(this.t1p));
        }
        this.subscriptions.seek(this.t1p, 100L);
        coordinator.poll(this.time.timer(Long.MAX_VALUE));
        return coordinator;
    }

    private void makeCoordinatorUnknown(ConsumerCoordinator coordinator, Errors error) {
        this.time.sleep(10000L);
        coordinator.sendHeartbeatRequest();
        this.client.prepareResponse((AbstractResponse)this.heartbeatResponse(error));
        this.time.sleep(10000L);
        this.consumerClient.poll(this.time.timer(0L));
        Assert.assertTrue((boolean)coordinator.coordinatorUnknown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeVerifyTimeout(final ConsumerCoordinator coordinator, final long closeTimeoutMs, long expectedMinTimeMs, long expectedMaxTimeMs) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            boolean coordinatorUnknown = coordinator.coordinatorUnknown();
            Future<?> future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    coordinator.close(ConsumerCoordinatorTest.this.time.timer(Math.min(closeTimeoutMs, 30000L)));
                }
            });
            if (!coordinatorUnknown) {
                this.client.waitForRequests(1, 1000L);
            } else {
                Thread.sleep(200L);
            }
            if (expectedMinTimeMs > 0L) {
                this.time.sleep(expectedMinTimeMs - 1L);
                try {
                    future.get(500L, TimeUnit.MILLISECONDS);
                    Assert.fail((String)"Close completed ungracefully without waiting for timeout");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
            if (expectedMaxTimeMs >= 0L) {
                this.time.sleep(expectedMaxTimeMs - expectedMinTimeMs + 2L);
            }
            future.get(2000L, TimeUnit.MILLISECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void gracefulCloseTest(ConsumerCoordinator coordinator, boolean shouldLeaveGroup) throws Exception {
        final AtomicBoolean commitRequested = new AtomicBoolean();
        final AtomicBoolean leaveGroupRequested = new AtomicBoolean();
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                commitRequested.set(true);
                OffsetCommitRequest commitRequest = (OffsetCommitRequest)body;
                return commitRequest.groupId().equals("test-group");
            }
        }, (AbstractResponse)new OffsetCommitResponse(new HashMap()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                leaveGroupRequested.set(true);
                LeaveGroupRequest leaveRequest = (LeaveGroupRequest)body;
                return leaveRequest.groupId().equals("test-group");
            }
        }, (AbstractResponse)new LeaveGroupResponse(Errors.NONE));
        coordinator.close();
        Assert.assertTrue((String)"Commit not requested", (boolean)commitRequested.get());
        Assert.assertEquals((String)("leaveGroupRequested should be " + shouldLeaveGroup), (Object)shouldLeaveGroup, (Object)leaveGroupRequested.get());
    }

    private ConsumerCoordinator buildCoordinator(Metrics metrics, List<PartitionAssignor> assignors, boolean excludeInternalTopics, boolean autoCommitEnabled, boolean leaveGroup) {
        return new ConsumerCoordinator(new LogContext(), this.consumerClient, "test-group", 60000, 10000, this.heartbeat, assignors, this.metadata, this.subscriptions, metrics, "consumertest-group", (Time)this.time, 100L, autoCommitEnabled, 2000, null, excludeInternalTopics, leaveGroup);
    }

    private FindCoordinatorResponse groupCoordinatorResponse(Node node, Errors error) {
        return new FindCoordinatorResponse(error, node);
    }

    private HeartbeatResponse heartbeatResponse(Errors error) {
        return new HeartbeatResponse(error);
    }

    private JoinGroupResponse joinGroupLeaderResponse(int generationId, String memberId, Map<String, List<String>> subscriptions, Errors error) {
        HashMap<String, ByteBuffer> metadata = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, List<String>> subscriptionEntry : subscriptions.entrySet()) {
            PartitionAssignor.Subscription subscription = new PartitionAssignor.Subscription(subscriptionEntry.getValue());
            ByteBuffer buf = ConsumerProtocol.serializeSubscription((PartitionAssignor.Subscription)subscription);
            metadata.put(subscriptionEntry.getKey(), buf);
        }
        return new JoinGroupResponse(error, generationId, this.partitionAssignor.name(), memberId, memberId, metadata);
    }

    private JoinGroupResponse joinGroupFollowerResponse(int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(error, generationId, this.partitionAssignor.name(), memberId, leaderId, Collections.emptyMap());
    }

    private SyncGroupResponse syncGroupResponse(List<TopicPartition> partitions, Errors error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(error, buf);
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private OffsetFetchResponse offsetFetchResponse(Errors topLevelError) {
        return new OffsetFetchResponse(topLevelError, Collections.emptyMap());
    }

    private OffsetFetchResponse offsetFetchResponse(TopicPartition tp, Errors partitionLevelError, String metadata, long offset) {
        OffsetFetchResponse.PartitionData data = new OffsetFetchResponse.PartitionData(offset, Optional.empty(), metadata, partitionLevelError);
        return new OffsetFetchResponse(Errors.NONE, Collections.singletonMap(tp, data));
    }

    private OffsetCommitCallback callback(final AtomicBoolean success) {
        return new OffsetCommitCallback(){

            public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception == null) {
                    success.set(true);
                }
            }
        };
    }

    private void joinAsFollowerAndReceiveAssignment(String consumerId, ConsumerCoordinator coordinator, List<TopicPartition> assignment) {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, Errors.NONE));
        coordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, consumerId, "leader", Errors.NONE));
        this.client.prepareResponse((AbstractResponse)this.syncGroupResponse(assignment, Errors.NONE));
        coordinator.joinGroupIfNeeded(this.time.timer(Long.MAX_VALUE));
    }

    private void prepareOffsetCommitRequest(Map<TopicPartition, Long> expectedOffsets, Errors error) {
        this.prepareOffsetCommitRequest(expectedOffsets, error, false);
    }

    private void prepareOffsetCommitRequestDisconnect(Map<TopicPartition, Long> expectedOffsets) {
        this.prepareOffsetCommitRequest(expectedOffsets, Errors.NONE, true);
    }

    private void prepareOffsetCommitRequest(Map<TopicPartition, Long> expectedOffsets, Errors error, boolean disconnected) {
        Map<TopicPartition, Errors> errors = this.partitionErrors(expectedOffsets.keySet(), error);
        this.client.prepareResponse(this.offsetCommitRequestMatcher(expectedOffsets), (AbstractResponse)this.offsetCommitResponse(errors), disconnected);
    }

    private Map<TopicPartition, Errors> partitionErrors(Collection<TopicPartition> partitions, Errors error) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitions) {
            errors.put(partition, error);
        }
        return errors;
    }

    private void respondToOffsetCommitRequest(Map<TopicPartition, Long> expectedOffsets, Errors error) {
        Map<TopicPartition, Errors> errors = this.partitionErrors(expectedOffsets.keySet(), error);
        this.client.respond(this.offsetCommitRequestMatcher(expectedOffsets), (AbstractResponse)this.offsetCommitResponse(errors));
    }

    private MockClient.RequestMatcher offsetCommitRequestMatcher(final Map<TopicPartition, Long> expectedOffsets) {
        return new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                OffsetCommitRequest req = (OffsetCommitRequest)body;
                Map offsets = req.offsetData();
                if (offsets.size() != expectedOffsets.size()) {
                    return false;
                }
                for (Map.Entry expectedOffset : expectedOffsets.entrySet()) {
                    if (!offsets.containsKey(expectedOffset.getKey())) {
                        return false;
                    }
                    OffsetCommitRequest.PartitionData offsetCommitData = (OffsetCommitRequest.PartitionData)offsets.get(expectedOffset.getKey());
                    if (offsetCommitData.offset == (Long)expectedOffset.getValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private OffsetCommitCallback callback(final Map<TopicPartition, OffsetAndMetadata> expectedOffsets, final AtomicBoolean success) {
        return new OffsetCommitCallback(){

            public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (expectedOffsets.equals(offsets) && exception == null) {
                    success.set(true);
                }
            }
        };
    }

    private static class MockRebalanceListener
    implements ConsumerRebalanceListener {
        public Collection<TopicPartition> revoked;
        public Collection<TopicPartition> assigned;
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.assigned = partitions;
            ++this.assignedCount;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.revoked = partitions;
            ++this.revokedCount;
        }
    }

    private static class MockCommitCallback
    implements OffsetCommitCallback {
        public int invoked = 0;
        public Exception exception = null;

        private MockCommitCallback() {
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            ++this.invoked;
            this.exception = exception;
        }
    }
}

