/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class FetchSessionHandlerTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);
    private static final LogContext LOG_CONTEXT = new LogContext("[FetchSessionHandler]=");

    private static Set<TopicPartition> toSet(TopicPartition ... arr) {
        TreeSet<TopicPartition> set = new TreeSet<TopicPartition>(new Comparator<TopicPartition>(){

            @Override
            public int compare(TopicPartition o1, TopicPartition o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        set.addAll(Arrays.asList(arr));
        return set;
    }

    @Test
    public void testFindMissing() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        TopicPartition baz0 = new TopicPartition("baz", 0);
        TopicPartition baz1 = new TopicPartition("baz", 1);
        Assert.assertEquals(FetchSessionHandlerTest.toSet(new TopicPartition[0]), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0), FetchSessionHandlerTest.toSet(foo0)));
        Assert.assertEquals(FetchSessionHandlerTest.toSet(foo0), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0), FetchSessionHandlerTest.toSet(foo1)));
        Assert.assertEquals(FetchSessionHandlerTest.toSet(foo0, foo1), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1), FetchSessionHandlerTest.toSet(baz0)));
        Assert.assertEquals(FetchSessionHandlerTest.toSet(bar1, foo0, foo1), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1), FetchSessionHandlerTest.toSet(bar0, baz0, baz1)));
        Assert.assertEquals(FetchSessionHandlerTest.toSet(new TopicPartition[0]), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1, baz1), FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1, baz0, baz1)));
    }

    private static LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqMap(ReqEntry ... entries) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> map = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        for (ReqEntry entry : entries) {
            map.put(entry.part, entry.data);
        }
        return map;
    }

    private static void assertMapEquals(Map<TopicPartition, FetchRequest.PartitionData> expected, Map<TopicPartition, FetchRequest.PartitionData> actual) {
        Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> expectedIter = expected.entrySet().iterator();
        Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> actualIter = actual.entrySet().iterator();
        int i = 1;
        while (expectedIter.hasNext()) {
            Map.Entry<TopicPartition, FetchRequest.PartitionData> expectedEntry = expectedIter.next();
            if (!actualIter.hasNext()) {
                Assert.fail((String)("Element " + i + " not found."));
            }
            Map.Entry<TopicPartition, FetchRequest.PartitionData> actuaLEntry = actualIter.next();
            Assert.assertEquals((String)("Element " + i + " had a different TopicPartition than expected."), (Object)expectedEntry.getKey(), (Object)actuaLEntry.getKey());
            Assert.assertEquals((String)("Element " + i + " had different PartitionData than expected."), (Object)expectedEntry.getValue(), (Object)actuaLEntry.getValue());
            ++i;
        }
        if (expectedIter.hasNext()) {
            Assert.fail((String)("Unexpected element " + i + " found."));
        }
    }

    private static void assertMapsEqual(Map<TopicPartition, FetchRequest.PartitionData> expected, Map<TopicPartition, FetchRequest.PartitionData> ... actuals) {
        for (Map<TopicPartition, FetchRequest.PartitionData> actual : actuals) {
            FetchSessionHandlerTest.assertMapEquals(expected, actual);
        }
    }

    private static void assertListEquals(List<TopicPartition> expected, List<TopicPartition> actual) {
        for (TopicPartition expectedPart : expected) {
            if (actual.contains(expectedPart)) continue;
            Assert.fail((String)("Failed to find expected partition " + expectedPart));
        }
        for (TopicPartition actualPart : actual) {
            if (expected.contains(actualPart)) continue;
            Assert.fail((String)("Found unexpected partition " + actualPart));
        }
    }

    private static LinkedHashMap<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> respMap(RespEntry ... entries) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> map = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>();
        for (RespEntry entry : entries) {
            map.put(entry.part, entry.data);
        }
        return map;
    }

    @Test
    public void testSessionless() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210)), data.toSend(), data.sessionPartitions());
        Assert.assertEquals((long)0L, (long)data.metadata().sessionId());
        Assert.assertEquals((long)0L, (long)data.metadata().epoch());
        FetchResponse resp = new FetchResponse(Errors.NONE, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 0L, 0L), new RespEntry("foo", 1, 0L, 0L)), 0, 0);
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assert.assertEquals((long)0L, (long)data2.metadata().sessionId());
        Assert.assertEquals((long)0L, (long)data2.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200)), data.toSend(), data.sessionPartitions());
    }

    @Test
    public void testIncrementals() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210)), data.toSend(), data.sessionPartitions());
        Assert.assertEquals((long)0L, (long)data.metadata().sessionId());
        Assert.assertEquals((long)0L, (long)data.metadata().epoch());
        FetchResponse resp = new FetchResponse(Errors.NONE, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L)), 0, 123);
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder2.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 120L, 210, Optional.empty()));
        builder2.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 200L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assert.assertFalse((boolean)data2.metadata().isFull());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 120L, 210), new ReqEntry("bar", 0, 20L, 200L, 200)), data2.sessionPartitions());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("bar", 0, 20L, 200L, 200), new ReqEntry("foo", 1, 10L, 120L, 210)), data2.toSend());
        FetchResponse resp2 = new FetchResponse(Errors.NONE, FetchSessionHandlerTest.respMap(new RespEntry("foo", 1, 20L, 20L)), 0, 123);
        handler.handleResponse(resp2);
        FetchResponse resp3 = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, FetchSessionHandlerTest.respMap(new RespEntry[0]), 0, 0);
        handler.handleResponse(resp3);
        FetchSessionHandler.Builder builder4 = handler.newBuilder();
        builder4.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder4.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 120L, 210, Optional.empty()));
        builder4.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 200L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data4 = builder4.build();
        Assert.assertTrue((boolean)data4.metadata().isFull());
        Assert.assertEquals((long)data2.metadata().sessionId(), (long)data4.metadata().sessionId());
        Assert.assertEquals((long)0L, (long)data4.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 120L, 210), new ReqEntry("bar", 0, 20L, 200L, 200)), data4.sessionPartitions(), data4.toSend());
    }

    @Test
    public void testDoubleBuild() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.build();
        try {
            builder.build();
            Assert.fail((String)"Expected calling build twice to fail.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementalPartitionRemoval() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        builder.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 120L, 220, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210), new ReqEntry("bar", 0, 20L, 120L, 220)), data.toSend(), data.sessionPartitions());
        Assert.assertTrue((boolean)data.metadata().isFull());
        FetchResponse resp = new FetchResponse(Errors.NONE, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L), new RespEntry("bar", 0, 10L, 20L)), 0, 123);
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assert.assertFalse((boolean)data2.metadata().isFull());
        Assert.assertEquals((long)123L, (long)data2.metadata().sessionId());
        Assert.assertEquals((long)1L, (long)data2.metadata().epoch());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 1, 10L, 110L, 210)), data2.sessionPartitions());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry[0]), data2.toSend());
        ArrayList<TopicPartition> expectedToForget2 = new ArrayList<TopicPartition>();
        expectedToForget2.add(new TopicPartition("foo", 0));
        expectedToForget2.add(new TopicPartition("bar", 0));
        FetchSessionHandlerTest.assertListEquals(expectedToForget2, data2.toForget());
        FetchResponse resp2 = new FetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, FetchSessionHandlerTest.respMap(new RespEntry[0]), 0, 0);
        handler.handleResponse(resp2);
        FetchSessionHandler.Builder builder3 = handler.newBuilder();
        builder3.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data3 = builder3.build();
        Assert.assertTrue((boolean)data3.metadata().isFull());
        Assert.assertEquals((long)0L, (long)data3.metadata().sessionId());
        Assert.assertEquals((long)0L, (long)data3.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200)), data3.sessionPartitions(), data3.toSend());
    }

    private static final class RespEntry {
        final TopicPartition part;
        final FetchResponse.PartitionData<MemoryRecords> data;

        RespEntry(String topic, int partition, long highWatermark, long lastStableOffset) {
            this.part = new TopicPartition(topic, partition);
            this.data = new FetchResponse.PartitionData(Errors.NONE, highWatermark, lastStableOffset, 0L, null, null);
        }
    }

    private static final class ReqEntry {
        final TopicPartition part;
        final FetchRequest.PartitionData data;

        ReqEntry(String topic, int partition, long fetchOffset, long logStartOffset, int maxBytes) {
            this.part = new TopicPartition(topic, partition);
            this.data = new FetchRequest.PartitionData(fetchOffset, logStartOffset, maxBytes, Optional.empty());
        }
    }
}

