/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String url : urls) {
            if (url == null || url.isEmpty()) continue;
            try {
                String host = Utils.getHost(url);
                Integer port = Utils.getPort(url);
                if (host == null || port == null) {
                    throw new ConfigException("Invalid url in bootstrap.servers: " + url);
                }
                InetSocketAddress address = new InetSocketAddress(host, (int)port);
                if (address.isUnresolved()) {
                    log.warn("Removing server {} from {} as DNS resolution failed for {}", new Object[]{url, "bootstrap.servers", host});
                    continue;
                }
                addresses.add(address);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Invalid port in bootstrap.servers: " + url);
            }
        }
        if (addresses.isEmpty()) {
            throw new ConfigException("No resolvable bootstrap urls given in bootstrap.servers");
        }
        return addresses;
    }

    public static void closeQuietly(Closeable c, String name, AtomicReference<Throwable> firstException) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable t) {
                firstException.compareAndSet(null, t);
                log.error("Failed to close " + name, t);
            }
        }
    }

    public static ChannelBuilder createChannelBuilder(AbstractConfig config) {
        SecurityProtocol securityProtocol = SecurityProtocol.forName(config.getString("security.protocol"));
        String clientSaslMechanism = config.getString("sasl.mechanism");
        return ChannelBuilders.clientChannelBuilder(securityProtocol, JaasContext.Type.CLIENT, config, null, clientSaslMechanism, true);
    }
}

