/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class AclBindingTest {
    private static final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "", AclOperation.ALL, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:*", "", AclOperation.READ, AclPermissionType.ALLOW));
    private static final AclBinding ACL3 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic2"), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBinding UNKNOWN_ACL = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic2"), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.UNKNOWN, AclPermissionType.DENY));
    private static final AclBindingFilter ANY_ANONYMOUS = new AclBindingFilter(new ResourceFilter(ResourceType.ANY, null), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter ANY_DENY = new AclBindingFilter(new ResourceFilter(ResourceType.ANY, null), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.DENY));
    private static final AclBindingFilter ANY_MYTOPIC = new AclBindingFilter(new ResourceFilter(ResourceType.TOPIC, "mytopic"), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testMatching() throws Exception {
        Assert.assertTrue((boolean)ACL1.equals((Object)ACL1));
        AclBinding acl1Copy = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "", AclOperation.ALL, AclPermissionType.ALLOW));
        Assert.assertTrue((boolean)ACL1.equals((Object)acl1Copy));
        Assert.assertTrue((boolean)acl1Copy.equals((Object)ACL1));
        Assert.assertTrue((boolean)ACL2.equals((Object)ACL2));
        Assert.assertFalse((boolean)ACL1.equals((Object)ACL2));
        Assert.assertFalse((boolean)ACL2.equals((Object)ACL1));
        Assert.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL1));
        Assert.assertFalse((boolean)AclBindingFilter.ANY.equals((Object)ACL1));
        Assert.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL2));
        Assert.assertFalse((boolean)AclBindingFilter.ANY.equals((Object)ACL2));
        Assert.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL3));
        Assert.assertFalse((boolean)AclBindingFilter.ANY.equals((Object)ACL3));
        Assert.assertTrue((boolean)AclBindingFilter.ANY.equals((Object)AclBindingFilter.ANY));
        Assert.assertTrue((boolean)ANY_ANONYMOUS.matches(ACL1));
        Assert.assertFalse((boolean)ANY_ANONYMOUS.equals((Object)ACL1));
        Assert.assertFalse((boolean)ANY_ANONYMOUS.matches(ACL2));
        Assert.assertFalse((boolean)ANY_ANONYMOUS.equals((Object)ACL2));
        Assert.assertTrue((boolean)ANY_ANONYMOUS.matches(ACL3));
        Assert.assertFalse((boolean)ANY_ANONYMOUS.equals((Object)ACL3));
        Assert.assertFalse((boolean)ANY_DENY.matches(ACL1));
        Assert.assertFalse((boolean)ANY_DENY.matches(ACL2));
        Assert.assertTrue((boolean)ANY_DENY.matches(ACL3));
        Assert.assertTrue((boolean)ANY_MYTOPIC.matches(ACL1));
        Assert.assertTrue((boolean)ANY_MYTOPIC.matches(ACL2));
        Assert.assertFalse((boolean)ANY_MYTOPIC.matches(ACL3));
        Assert.assertTrue((boolean)ANY_ANONYMOUS.matches(UNKNOWN_ACL));
        Assert.assertTrue((boolean)ANY_DENY.matches(UNKNOWN_ACL));
        Assert.assertTrue((boolean)UNKNOWN_ACL.equals((Object)UNKNOWN_ACL));
        Assert.assertFalse((boolean)ANY_MYTOPIC.matches(UNKNOWN_ACL));
    }

    @Test
    public void testUnknowns() throws Exception {
        Assert.assertFalse((boolean)ACL1.isUnknown());
        Assert.assertFalse((boolean)ACL2.isUnknown());
        Assert.assertFalse((boolean)ACL3.isUnknown());
        Assert.assertFalse((boolean)ANY_ANONYMOUS.isUnknown());
        Assert.assertFalse((boolean)ANY_DENY.isUnknown());
        Assert.assertFalse((boolean)ANY_MYTOPIC.isUnknown());
        Assert.assertTrue((boolean)UNKNOWN_ACL.isUnknown());
    }

    @Test
    public void testMatchesAtMostOne() throws Exception {
        Assert.assertEquals(null, (Object)ACL1.toFilter().findIndefiniteField());
        Assert.assertEquals(null, (Object)ACL2.toFilter().findIndefiniteField());
        Assert.assertEquals(null, (Object)ACL3.toFilter().findIndefiniteField());
        Assert.assertFalse((boolean)ANY_ANONYMOUS.matchesAtMostOne());
        Assert.assertFalse((boolean)ANY_DENY.matchesAtMostOne());
        Assert.assertFalse((boolean)ANY_MYTOPIC.matchesAtMostOne());
    }
}

