/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.ssl.SslFactory;

class EchoServer
extends Thread {
    public final int port;
    private final ServerSocket serverSocket;
    private final List<Thread> threads;
    private final List<Socket> sockets;
    private final SslFactory sslFactory;
    private final AtomicBoolean renegotiate = new AtomicBoolean();

    public EchoServer(SecurityProtocol securityProtocol, Map<String, ?> configs) throws Exception {
        switch (securityProtocol) {
            case SSL: {
                this.sslFactory = new SslFactory(Mode.SERVER);
                this.sslFactory.configure(configs);
                SSLContext sslContext = this.sslFactory.sslContext();
                this.serverSocket = sslContext.getServerSocketFactory().createServerSocket(0);
                break;
            }
            case PLAINTEXT: {
                this.serverSocket = new ServerSocket(0);
                this.sslFactory = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported securityProtocol " + securityProtocol);
            }
        }
        this.port = this.serverSocket.getLocalPort();
        this.threads = Collections.synchronizedList(new ArrayList());
        this.sockets = Collections.synchronizedList(new ArrayList());
    }

    public void renegotiate() {
        this.renegotiate.set(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                final Socket socket = this.serverSocket.accept();
                this.sockets.add(socket);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            DataInputStream input = new DataInputStream(socket.getInputStream());
                            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                            while (socket.isConnected() && !socket.isClosed()) {
                                int size = input.readInt();
                                if (EchoServer.this.renegotiate.get()) {
                                    EchoServer.this.renegotiate.set(false);
                                    ((SSLSocket)socket).startHandshake();
                                }
                                byte[] bytes = new byte[size];
                                input.readFully(bytes);
                                output.writeInt(size);
                                output.write(bytes);
                                output.flush();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                };
                thread.start();
                this.threads.add(thread);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void closeConnections() throws IOException {
        for (Socket socket : this.sockets) {
            socket.close();
        }
    }

    public void close() throws IOException, InterruptedException {
        this.serverSocket.close();
        this.closeConnections();
        for (Thread t : this.threads) {
            t.join();
        }
        this.join();
    }
}

