/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;

public class TestUtils {
    public static final File IO_TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGITS = "0123456789";
    public static final String LETTERS_AND_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final Random SEEDED_RANDOM = new Random(192348092834L);
    public static final Random RANDOM = new Random();

    public static Cluster singletonCluster(String topic, int partitions) {
        return TestUtils.clusterWith(1, topic, partitions);
    }

    public static Cluster clusterWith(int nodes, String topic, int partitions) {
        Node[] ns = new Node[nodes];
        for (int i = 0; i < nodes; ++i) {
            ns[i] = new Node(0, "localhost", 1969);
        }
        ArrayList<PartitionInfo> parts = new ArrayList<PartitionInfo>();
        for (int i = 0; i < partitions; ++i) {
            parts.add(new PartitionInfo(topic, i, ns[i % ns.length], ns, ns));
        }
        return new Cluster(Arrays.asList(ns), parts, Collections.emptySet());
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        SEEDED_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(SEEDED_RANDOM.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }
}

