/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class MockConsumerTest {
    private MockConsumer<String, String> consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);

    @Test
    public void testSimpleMock() {
        this.consumer.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        Assert.assertEquals((long)0L, (long)this.consumer.poll(1000L).count());
        this.consumer.rebalance(Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1)));
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(new TopicPartition("test", 0), 0L);
        beginningOffsets.put(new TopicPartition("test", 1), 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.consumer.seek(new TopicPartition("test", 0), 0L);
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 0L, (Object)"key1", (Object)"value1");
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 1L, (Object)"key2", (Object)"value2");
        this.consumer.addRecord(rec1);
        this.consumer.addRecord(rec2);
        ConsumerRecords recs = this.consumer.poll(1L);
        Iterator iter = recs.iterator();
        Assert.assertEquals((Object)rec1, iter.next());
        Assert.assertEquals((Object)rec2, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)2L, (long)this.consumer.position(new TopicPartition("test", 0)));
        this.consumer.commitSync();
        Assert.assertEquals((long)2L, (long)this.consumer.committed(new TopicPartition("test", 0)).offset());
    }
}

