/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private Metadata metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs);
    private AtomicReference<String> backgroundError = new AtomicReference();

    @After
    public void tearDown() {
        Assert.assertNull((String)("Exception in background thread : " + this.backgroundError.get()), (Object)this.backgroundError.get());
    }

    @Test
    public void testMetadata() throws Exception {
        long time = 0L;
        this.metadata.update(Cluster.empty(), time);
        Assert.assertFalse((String)"No update needed.", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        this.metadata.requestUpdate();
        Assert.assertFalse((String)"Still no updated needed due to backoff", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Update needed now that backoff time expired", (this.metadata.timeToNextUpdate(time += this.refreshBackoffMs) == 0L ? 1 : 0) != 0);
        String topic = "my-topic";
        Thread t1 = this.asyncFetch(topic);
        Thread t2 = this.asyncFetch(topic);
        Assert.assertTrue((String)"Awaiting update", (boolean)t1.isAlive());
        Assert.assertTrue((String)"Awaiting update", (boolean)t2.isAlive());
        while (t1.isAlive() || t2.isAlive()) {
            if (this.metadata.timeToNextUpdate(time) == 0L) {
                this.metadata.update(TestUtils.singletonCluster(topic, 1), time);
                time += this.refreshBackoffMs;
            }
            Thread.sleep(1L);
        }
        t1.join();
        t2.join();
        Assert.assertFalse((String)"No update needed.", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Update needed due to stale metadata.", (this.metadata.timeToNextUpdate(time += this.metadataExpireMs) == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMetadataUpdateWaitTime() throws Exception {
        long time = 0L;
        this.metadata.update(Cluster.empty(), time);
        Assert.assertFalse((String)"No update needed.", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 0L);
            Assert.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        long twoSecondWait = 2000L;
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 2000L);
            Assert.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testFailedUpdate() {
        long time = 100L;
        this.metadata.update(Cluster.empty(), time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
        this.metadata.failedUpdate(1100L);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1100L));
        Assert.assertEquals((long)100L, (long)this.metadata.lastSuccessfulUpdate());
        this.metadata.needMetadataForAllTopics(true);
        this.metadata.update(null, time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
    }

    @Test
    public void testUpdateWithNeedMetadataForAllTopics() {
        long time = 0L;
        this.metadata.update(Cluster.empty(), time);
        this.metadata.needMetadataForAllTopics(true);
        List<String> expectedTopics = Collections.singletonList("topic");
        this.metadata.setTopics(expectedTopics);
        this.metadata.update(new Cluster(Collections.singletonList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo("topic", 0, null, null, null), new PartitionInfo("topic1", 0, null, null, null)), Collections.emptySet()), 100L);
        Assert.assertArrayEquals((String)"Metadata got updated with wrong set of topics.", (Object[])expectedTopics.toArray(), (Object[])this.metadata.topics().toArray());
        this.metadata.needMetadataForAllTopics(false);
    }

    @Test
    public void testListenerGetsNotifiedOfUpdate() {
        long time = 0L;
        final HashSet topics = new HashSet();
        this.metadata.update(Cluster.empty(), time);
        this.metadata.addListener(new Metadata.Listener(){

            public void onMetadataUpdate(Cluster cluster) {
                topics.clear();
                topics.addAll(cluster.topics());
            }
        });
        this.metadata.update(new Cluster(Arrays.asList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo("topic", 0, null, null, null), new PartitionInfo("topic1", 0, null, null, null)), Collections.emptySet()), 100L);
        Assert.assertEquals((String)"Listener did not update topics list correctly", new HashSet<String>(Arrays.asList("topic", "topic1")), topics);
    }

    @Test
    public void testListenerCanUnregister() {
        long time = 0L;
        final HashSet topics = new HashSet();
        this.metadata.update(Cluster.empty(), time);
        Metadata.Listener listener = new Metadata.Listener(){

            public void onMetadataUpdate(Cluster cluster) {
                topics.clear();
                topics.addAll(cluster.topics());
            }
        };
        this.metadata.addListener(listener);
        this.metadata.update(new Cluster(Collections.singletonList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo("topic", 0, null, null, null), new PartitionInfo("topic1", 0, null, null, null)), Collections.emptySet()), 100L);
        this.metadata.removeListener(listener);
        this.metadata.update(new Cluster(Arrays.asList(new Node(0, "host1", 1000)), Arrays.asList(new PartitionInfo("topic2", 0, null, null, null), new PartitionInfo("topic3", 0, null, null, null)), Collections.emptySet()), 100L);
        Assert.assertEquals((String)"Listener did not update topics list correctly", new HashSet<String>(Arrays.asList("topic", "topic1")), topics);
    }

    private Thread asyncFetch(final String topic) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (MetadataTest.this.metadata.fetch().partitionsForTopic(topic) == null) {
                    try {
                        MetadataTest.this.metadata.awaitUpdate(MetadataTest.this.metadata.requestUpdate(), MetadataTest.this.refreshBackoffMs);
                    }
                    catch (Exception e) {
                        MetadataTest.this.backgroundError.set(e.toString());
                    }
                }
            }
        };
        thread.start();
        return thread;
    }
}

