/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import org.apache.kafka.common.Metric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.utils.Time;

public final class KafkaMetric
implements Metric {
    private final String name;
    private final String description;
    private final Object lock;
    private final Time time;
    private final Measurable measurable;
    private MetricConfig config;

    KafkaMetric(Object lock, String name, String description, Measurable measurable, MetricConfig config, Time time) {
        this.name = name;
        this.description = description;
        this.lock = lock;
        this.measurable = measurable;
        this.config = config;
        this.time = time;
    }

    MetricConfig config() {
        return this.config;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double value() {
        Object object = this.lock;
        synchronized (object) {
            return this.value(this.time.milliseconds());
        }
    }

    double value(long timeMs) {
        return this.measurable.measure(this.config, timeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void config(MetricConfig config) {
        Object object = this.lock;
        synchronized (object) {
            this.config = config;
        }
    }
}

