/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

public final class ProducerRecord {
    private final String topic;
    private final Integer partition;
    private final byte[] key;
    private final byte[] value;

    public ProducerRecord(String topic, Integer partition, byte[] key, byte[] value) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.topic = topic;
        this.partition = partition;
        this.key = key;
        this.value = value;
    }

    public ProducerRecord(String topic, byte[] key, byte[] value) {
        this(topic, null, key, value);
    }

    public ProducerRecord(String topic, byte[] value) {
        this(topic, null, value);
    }

    public String topic() {
        return this.topic;
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    public Integer partition() {
        return this.partition;
    }

    public String toString() {
        String key = this.key == null ? "null" : "byte[" + this.key.length + "]";
        String value = this.value == null ? "null" : "byte[" + this.value.length + "]";
        return "ProducerRecord(topic=" + this.topic + ", partition=" + this.partition + ", key=" + key + ", value=" + value;
    }
}

